/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Element;

public class InitCurrencyInfoDisplaySymbolHandler
implements SetupUpdateHandler {
    private final Map<String, String> data = new HashMap<String, String>();

    public InitCurrencyInfoDisplaySymbolHandler() {
        try (InputStream is = this.getClass().getResourceAsStream("InitCurrencyInfoDisplaySymbolHandler.txt");
             InputStreamReader r = new InputStreamReader(Objects.requireNonNull(is));
             BufferedReader br = new BufferedReader(r);){
            String line;
            while ((line = br.readLine()) != null) {
                String code = line.substring(0, 3);
                String symbol = line.substring(4);
                this.data.put(code, symbol);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void execute(Element command) throws Exception {
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            CurrencyInfo info = DictHelper.getCurrencyInfoByAnyCode((String)entry.getKey());
            if (info == null || info.getDisplaySymbol() != null) continue;
            info.setDisplaySymbol(entry.getValue());
            info.setDataSource("InitCurrencyInfoDisplaySymbolHandler");
            DictionaryStorage.get().save((BaseDictionary)info);
        }
    }
}

