/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.rules.finance.Actions;
import com.gridnine.xtrip.common.model.rules.finance.Properties;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class InvoicePrepaymentRulesMigrationHandler
implements SetupUpdateHandler {
    private static final Predicate<RuleResult> RULE_RESULT_PREDICATE = rr -> rr.getAction() == Actions.FINANCE_DOCUMENT_DATA && rr.getValue() != null && rr.getValue() instanceof FinanceDocumentData && ((FinanceDocumentData)rr.getValue()).getType() == FinanceDocumentType.INVOICE_PREPAYMENT;
    private static final Predicate<RuleRestriction> RULE_RESTRICTION_PREDICATE = rr -> rr.getProperty() == Properties.SHIPMENT_SUPPLIER || rr.getProperty() == Properties.SHIPMENT_VENDOR_AGREEMENT_TYPE;

    public void execute(Element command) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add("uid");
        for (ModelContractIndex idx : EntityStorage.get().search(ModelContractIndex.class, query).getData()) {
            EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
            boolean modified = false;
            Optional<Iterator> optIter = Optional.ofNullable(ctr).map(EntityContainer::getEntity).map(BaseRulesContainer::getRuleSet).map(RuleSet::getRules).map(List::iterator);
            if (!optIter.isPresent()) continue;
            List<RuleSettings> newRules = new ArrayList<RuleSettings>();
            Iterator iter = optIter.get();
            while (iter.hasNext()) {
                RuleSettings rule = (RuleSettings)iter.next();
                if (InvoicePrepaymentRulesMigrationHandler.needsMigration(rule)) {
                    modified = true;
                    newRules.add(InvoicePrepaymentRulesMigrationHandler.migrate(rule));
                }
                if (!InvoicePrepaymentRulesMigrationHandler.canBeRemoved(rule)) continue;
                iter.remove();
            }
            if (!newRules.isEmpty()) {
                newRules = this.compact(newRules);
                ((ModelContract)ctr.getEntity()).getRuleSet().getRules().addAll(newRules);
            }
            if (!modified) continue;
            ctr.getVersionInfo().setDataSource("InvoicePrepaymentRulesMigrationHandler");
            EntityStorage.get().save(ctr, true);
        }
    }

    private static boolean needsMigration(RuleSettings rule) {
        return rule.getResults().stream().anyMatch(RULE_RESULT_PREDICATE);
    }

    private static RuleSettings migrate(RuleSettings rule) {
        List<RuleResult> results = rule.getResults().stream().filter(RULE_RESULT_PREDICATE).collect(Collectors.toList());
        rule.getResults().removeAll(results);
        results.forEach(rr -> rr.setAction((RuleAction)Actions.INVOICE_PREPAYMENT_DATA));
        RuleSettings newRule = new RuleSettings();
        newRule.setTarget((RuleTarget)Targets.INVOICE_PREPAYMENT);
        newRule.setName(rule.getName());
        newRule.setRemarks(rule.getRemarks());
        newRule.setPeriodBegin(rule.getPeriodBegin());
        newRule.setPeriodEnd(rule.getPeriodEnd());
        newRule.setFilteringCategory(rule.getFilteringCategory());
        newRule.setIgnoreOnExport(rule.isIgnoreOnExport());
        newRule.setPreserveOnImport(rule.isPreserveOnImport());
        newRule.getRestrictions().addAll(rule.getRestrictions().stream().filter(RULE_RESTRICTION_PREDICATE).collect(Collectors.toList()));
        newRule.setDescription(rule.getDescription());
        newRule.getResults().addAll(results);
        newRule.setRevisionDate(rule.getRevisionDate());
        return newRule;
    }

    private static boolean canBeRemoved(RuleSettings rule) {
        return rule.getResults().isEmpty();
    }

    private List<RuleSettings> compact(List<RuleSettings> rules) {
        ArrayList<RuleSettings> result = new ArrayList<RuleSettings>();
        boolean noRestrictionsProcessed = false;
        for (RuleSettings rule : rules) {
            if (!rule.getRestrictions().isEmpty()) {
                result.add(rule);
                continue;
            }
            if (noRestrictionsProcessed) continue;
            result.add(rule);
            noRestrictionsProcessed = true;
        }
        return result;
    }
}

