/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class MailServerSettingsMigrationHandler
implements SetupUpdateHandler {
    public void execute(Element elm) throws Exception {
        boolean settingsAlreadyPresent;
        Logger log = LoggerFactory.getLogger(this.getClass());
        String displayName = ((EntityType)MetaRegistry.get().getEntities().get(MailServerSettings.class.getName())).getDisplayName();
        log.debug("mail server settings migration started");
        boolean bl = settingsAlreadyPresent = EntityStorage.get().load(MailServerSettings.class, UniqueSettingsRegistry.get().getUidByClassName(MailServerSettings.class.getName())) != null;
        if (settingsAlreadyPresent) {
            log.debug("mail server settings migration interrupted - settings already present");
            return;
        }
        MailServerSettings settings = MailConfigUtil.readMailServerParametersFromProperties();
        this.setEmptyStringsNull(settings);
        settings.setName(displayName);
        settings.setType(SystemSettingsType.OTHER);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)settings, (String)UniqueSettingsRegistry.get().getUidByClassName(MailServerSettings.class.getName())), true);
        Path path = Paths.get(Environment.getConfigurationFolder() + File.separator + "boot.properties", new String[0]);
        List result = Files.readAllLines(path).stream().filter(entry -> {
            boolean isToBeExcluded = entry.contains("com.gridnine.xtrip.server.mail.host") || entry.contains("com.gridnine.xtrip.server.mail.port") || entry.contains("com.gridnine.xtrip.server.mail.user") || entry.contains("com.gridnine.xtrip.server.mail.password") || entry.contains("com.gridnine.xtrip.server.mail.admin") || entry.contains("com.gridnine.xtrip.server.mail.defaultFrom");
            return !isToBeExcluded || entry.startsWith("#");
        }).collect(Collectors.toList());
        Files.write(path, result, StandardOpenOption.TRUNCATE_EXISTING);
        log.debug("mail server settings migration finished");
    }

    private void setEmptyStringsNull(MailServerSettings settings) {
        if (TextUtil.isBlank((String)settings.getAdminAddress())) {
            settings.setAdminAddress(null);
        }
        if (TextUtil.isBlank((String)settings.getDefaultFrom())) {
            settings.setDefaultFrom(null);
        }
        if (TextUtil.isBlank((String)settings.getMailServerParameters().getUser())) {
            settings.getMailServerParameters().setUser(null);
        }
        if (TextUtil.isBlank((String)settings.getMailServerParameters().getHost())) {
            settings.getMailServerParameters().setHost(null);
        }
        if (TextUtil.isBlank((String)settings.getMailServerParameters().getPasswrod())) {
            settings.getMailServerParameters().setPasswrod(null);
        }
    }
}

