/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.BaseResourceSetupUpdateHandler;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class OeCodeUpdateHandler
extends BaseResourceSetupUpdateHandler {
    public void execute(Element elm) throws Exception {
        Set airlinesHB = DictionaryCache.get().lookup(Airline.class, "EO", new String[]{CodeSystem.IATA.name()});
        Set airlinesIkar = DictionaryCache.get().lookup(Airline.class, "\u0410\u042c", new String[]{CodeSystem.CRT.name()});
        this.setCloseDateHB(airlinesHB);
        this.setIata(airlinesIkar);
    }

    private void setIata(Set<Airline> airlinesIkar) throws Exception {
        for (Airline airline : airlinesIkar) {
            String iata;
            Map translations = airline.getTranslations();
            if (translations.isEmpty() || !this.isContainName(translations.values(), "\u0418\u043a\u0430\u0440") && !((String)airline.getCodeVariants().get(CodeSystem.CRT.name())).equals("\u0410\u042c") || !TextUtil.isBlank((String)(iata = (String)airline.getCodeVariants().get(CodeSystem.IATA.name()))) && (!TextUtil.nonBlank((String)iata) || iata.equals("EO"))) continue;
            airline.getCodeVariants().put(CodeSystem.IATA.name(), "EO");
            airline.setOpenDate(new SimpleDateFormat("yyyy-MM-dd").parse("2013-04-16"));
            airline.setDataSource("OeCodeUpdateHandler");
            DictionaryStorage.get().save((BaseDictionary)airline);
        }
    }

    private void setCloseDateHB(Set<Airline> airlinesHB) throws Exception {
        for (Airline airline : airlinesHB) {
            Map translations = airline.getTranslations();
            if (translations.isEmpty() || !this.isContainName(translations.values(), "Hewa Bora")) continue;
            airline.setCloseDate(new SimpleDateFormat("yyyy-MM-dd").parse("2011-07-16"));
            airline.setDataSource("OeCodeUpdateHandler");
            DictionaryStorage.get().save((BaseDictionary)airline);
        }
    }

    private boolean isContainName(Collection<String> names, String value) {
        for (String s : names) {
            if (!s.contains(value)) continue;
            return true;
        }
        return false;
    }
}

