/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductDateData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.system.ProductPeriodData;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ProductDateDatasSetProductPeriodDataHandler
implements SetupUpdateHandler {
    private final Log log = LogFactory.getLog(this.getClass());

    public void execute(Element command) throws Exception {
    }

    private void updateProductDateData() {
        this.log.debug((Object)"productDateDatas set productPeriodData started");
        SearchQuery query = new SearchQuery();
        Set modelContractReferences = EntityStorage.get().search(ModelContractIndex.class, query).getData().stream().map(ModelContractIndex::getSource).filter(Objects::nonNull).collect(Collectors.toSet());
        for (EntityReference modelContractRef : modelContractReferences) {
            RuleSet ruleSet;
            ModelContract modelContract;
            this.log.debug((Object)String.format("processing %s", modelContractRef));
            EntityContainer modelContractCtr = EntityStorage.get().resolve(modelContractRef);
            if (modelContractCtr == null || (modelContract = (ModelContract)modelContractCtr.getEntity()) == null || (ruleSet = modelContract.getRuleSet()) == null) continue;
            for (RuleSettings ruleSettings : ruleSet.getRules()) {
                for (RuleResult ruleResult : ruleSettings.getResults()) {
                    if (!(ruleResult.getValue() instanceof ProductDateData)) continue;
                    ProductDateData productDateData = (ProductDateData)ruleResult.getValue();
                    this.log.debug((Object)String.format("processing %s", productDateData));
                    if (productDateData.getProductPeriodType() == null || productDateData.getProductPeriodData() != null) continue;
                    ProductPeriodData productPeriodData = new ProductPeriodData();
                    productPeriodData.setProductPeriodType(productDateData.getProductPeriodType());
                    productDateData.setProductPeriodData(productPeriodData);
                }
            }
            try {
                modelContractCtr.getVersionInfo().setDataSource("set-product-period-data");
                EntityStorage.get().save(modelContractCtr, true);
            }
            catch (Exception e) {
                this.log.debug((Object)String.format("unable to save %s", modelContractCtr));
            }
        }
        this.log.debug((Object)"productDateDatas set productPeriodData finished");
    }
}

