/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.tasks.QueryBasedReindexTaskConfiguration;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksManager;
import com.gridnine.xtrip.server.model.tasks.ManagerPublisher;
import com.gridnine.xtrip.server.model.tasks.standard.QueryBasedReindexLongRunningTask;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ReindexCommonProductIndexWithProductTypeHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        String indexClass = "com.gridnine.xtrip.common.model.booking.CommonProductIndex";
        String productType = command.getAttribute("productType");
        if (TextUtil.isBlank((String)productType)) {
            throw Xeption.forDeveloper((String)"productType is empty", (Object[])new Object[0]);
        }
        new ManagerPublisher().publish();
        QueryBasedReindexTaskConfiguration configuration = new QueryBasedReindexTaskConfiguration();
        ProductType product = this.getProductType(productType);
        if (product != null) {
            configuration.getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)product));
        }
        LoggerFactory.getLogger(this.getClass()).debug(String.format("requested reindex of index: %s", indexClass));
        configuration.setIndexType(indexClass);
        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(QueryBasedReindexLongRunningTask.class, null, configuration);
    }

    private ProductType getProductType(String productType) {
        try {
            return ProductType.valueOf((String)productType);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).debug("ProductType '" + productType + "' not found");
            return null;
        }
    }
}

