/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.tasks.QueryBasedReindexTaskConfiguration;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksManager;
import com.gridnine.xtrip.server.model.tasks.ManagerPublisher;
import com.gridnine.xtrip.server.model.tasks.standard.QueryBasedReindexLongRunningTask;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ReindexPersonHandler
implements SetupUpdateHandler {
    public void execute(Element elm) throws Exception {
        new ManagerPublisher().publish();
        QueryBasedReindexTaskConfiguration personConfig = new QueryBasedReindexTaskConfiguration();
        LoggerFactory.getLogger(this.getClass()).debug(String.format("requested reindex of classes: %s", "Person"));
        personConfig.setIndexType(PersonIndex.class.getName());
        personConfig.getCriterions().add(SearchCriterion.ne((String)PersonIndex.Property.sabreProfilesLastSyncDate.name(), null));
        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(QueryBasedReindexLongRunningTask.class, null, personConfig);
        QueryBasedReindexTaskConfiguration organizationConfig = new QueryBasedReindexTaskConfiguration();
        LoggerFactory.getLogger(this.getClass()).debug(String.format("requested reindex of classes: %s", "Organization"));
        organizationConfig.setIndexType(OrganizationIndex.class.getName());
        organizationConfig.getCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.sabreProfilesLastSyncDate.name(), null));
        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(QueryBasedReindexLongRunningTask.class, null, organizationConfig);
    }
}

