/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fiscal.model.FiscalSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RemoteFiscalServiceProviderSettingsMigrationHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        boolean disableWorklog;
        Logger log = LoggerFactory.getLogger(this.getClass());
        log.debug("remote fiscal service provider settings migration started");
        EntityContainer settingsCtr = EntityStorage.get().load(FiscalSettings.class, "fiscal-settings");
        if (settingsCtr == null) {
            log.debug("fiscal settings migration interrupted - settings not found");
            return;
        }
        FiscalSettings settings = (FiscalSettings)settingsCtr.getEntity();
        ExtendedProperties props = ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration();
        String enabledProperty = props.getProperty("fiscal.RemoteFiscalServiceProvider.enabled");
        boolean enabled = enabledProperty != null && enabledProperty.toUpperCase().equals("TRUE");
        String serverAddress = props.getProperty("fiscal.RemoteFiscalServiceProvider.serverAddress");
        String disableWorklogProperty = props.getProperty("fiscal.RemoteFiscalServiceProvider.disableWorklog");
        boolean bl = disableWorklog = disableWorklogProperty != null && enabledProperty.toUpperCase().equals("TRUE");
        if (enabled) {
            if (serverAddress == null || serverAddress.isEmpty()) {
                log.error("No server address specified");
            } else {
                log.info("Fiscal manager initialized with server address: " + serverAddress);
            }
        }
        EntityStorage.get().save(settingsCtr, true);
        Path path = Paths.get(Environment.getConfigurationFolder() + File.separator + "boot.properties", new String[0]);
        try {
            List<String> lines = Files.readAllLines(path);
        }
        catch (Exception e) {
            List<String> lines = Files.readAllLines(path, Charset.forName("windows-1251"));
        }
        List result = Files.readAllLines(path).stream().filter(entry -> {
            boolean isToBeExcluded = entry.contains("fiscal.RemoteFiscalServiceProvider.enabled") || entry.contains("fiscal.RemoteFiscalServiceProvider.serverAddress") || entry.contains("#Fiscal") || entry.contains("fiscal.RemoteFiscalServiceProvider.disableWorklog");
            return !isToBeExcluded;
        }).collect(Collectors.toList());
        Files.write(path, result, StandardOpenOption.TRUNCATE_EXISTING);
        log.debug("fiscal settings migration finished");
    }
}

