/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.tasks.ManagerPublisher;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SabreProfilesConnectionSettingsUpdateHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        new ManagerPublisher().publish();
        Logger log = LoggerFactory.getLogger(this.getClass());
        log.debug("sabre profiles connection settings update");
        EntityContainer setCont = ProfileSynchronizationUtil.getSabreProfilesConnectionSettingsContainer();
        if (setCont == null) {
            log.debug("sabre profiles connection settings container is null. Task is stopped");
            return;
        }
        SabreProfilesConnectionSettings connectionSettings = (SabreProfilesConnectionSettings)setCont.getEntity();
        if (connectionSettings == null) {
            log.error("sabre profiles connection settings is null. Task is stopped");
            return;
        }
        String pcc = connectionSettings.getPcc();
        String password = connectionSettings.getPassword();
        if (TextUtil.isBlank((String)pcc) && TextUtil.isBlank((String)password)) {
            log.debug("pcc and password are empty. Task is stopped");
            return;
        }
        if (connectionSettings.getPccSettings().stream().filter(pccSettings -> pccSettings != null && TextUtil.isSame((String)pccSettings.getPcc(), (String)pcc) && TextUtil.isSame((String)pccSettings.getPassword(), (String)password)).count() > 0L) {
            log.debug(String.format("pcc settings with pcc %s and password %s already exist. Task is stopped", pcc, password));
            return;
        }
        log.debug(String.format("pcc: %s, password: %s", pcc, password));
        SabreProfilesPccSettings pccSettings2 = new SabreProfilesPccSettings();
        pccSettings2.setPcc(pcc);
        pccSettings2.setPassword(password);
        connectionSettings.getPccSettings().add(pccSettings2);
        EntityStorage.get().save(setCont, true);
        log.debug("sabre profiles connection settings update finished");
    }
}

