/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.java.plugin.util.ExtendedProperties;
import org.w3c.dom.Element;

public class ScheduledTasksConfigurationMigrationHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        final ExtendedProperties config = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        EntityStorage storage = EntityStorage.get();
        ArrayList<TaskConfig> configs = new ArrayList<TaskConfig>();
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_updateCurrency);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.model.ukrain.NBURateTask";
            }

            @Override
            protected String getCron() {
                return config.getProperty("update.currencyrate.nbu.cron");
            }

            @Override
            protected Long getPeriod() {
                return null;
            }

            @Override
            protected Long getDelay() {
                return null;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return !TextUtil.isBlank((String)this.getCron());
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return 1.trimParams(config, "update.currencyrate.nbu.url", "update.currencyrate.nbu.currencies");
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_synchCurrency);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.model.synchronization.standard.CurrencyRateSynchronizationTask";
            }

            @Override
            protected String getCron() {
                return config.getProperty("currency-rate-synchronization-service.cron");
            }

            @Override
            protected Long getPeriod() {
                return null;
            }

            @Override
            protected Long getDelay() {
                return null;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return !TextUtil.isBlank((String)this.getCron());
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return 2.trimParams(config, "currency-rate-synchronization-service.currencyCodes", "currency-rate-synchronization-service.baseCurrencyCodes", "currency-rate-synchronization-service.rateTypes");
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_sendNotification);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.model.notification.service.EmailEventNotificationTask";
            }

            @Override
            protected String getCron() {
                return null;
            }

            @Override
            protected Long getPeriod() {
                return 60000L;
            }

            @Override
            protected Long getDelay() {
                return 60000L;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                if (TextUtil.isBlank((String)config.getProperty("event.notification.service.enabled"))) {
                    return true;
                }
                return config.getProperty("event.notification.service.enabled").equalsIgnoreCase("true");
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return Collections.emptySet();
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_updateBalance);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.model.index.UpdatePersonBalanceTask";
            }

            @Override
            protected String getCron() {
                return config.getProperty("updatePersonBalance.cron");
            }

            @Override
            protected Long getPeriod() {
                return null;
            }

            @Override
            protected Long getDelay() {
                return 600000L;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return !TextUtil.isBlank((String)this.getCron());
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return Collections.emptySet();
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_updateBalancePrivate);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.model.index.UpdateOrganizationBalanceTask";
            }

            @Override
            protected String getCron() {
                return config.getProperty("updateOrganizationBalance.cron");
            }

            @Override
            protected Long getPeriod() {
                return null;
            }

            @Override
            protected Long getDelay() {
                return 600000L;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return !TextUtil.isBlank((String)this.getCron());
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return Collections.emptySet();
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_processingExpDoc);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.model.export.service.ProcessExportDocumentsTask";
            }

            @Override
            protected String getCron() {
                return config.getProperty("process-export-documents-service.cron");
            }

            @Override
            protected Long getPeriod() {
                return null;
            }

            @Override
            protected Long getDelay() {
                return null;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return !TextUtil.isBlank((String)this.getCron());
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return 6.trimParams(config, "process-export-documents-service.threadsCount", "process-export-documents-service.useFileStorage", "process-export-documents-service.fileStorageDir");
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_deleteExpDoc);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.model.export.service.DeleteExportDocumentTask";
            }

            @Override
            protected String getCron() {
                return config.getProperty("delete-export-document-service.cron");
            }

            @Override
            protected Long getPeriod() {
                return null;
            }

            @Override
            protected Long getDelay() {
                return null;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return !TextUtil.isBlank((String)this.getCron());
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return 7.trimParams(config, "delete-export-document-service.retainPeriodInHours");
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_deleteTempObject);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.model.TemporalObjectsTask";
            }

            @Override
            protected String getCron() {
                return null;
            }

            @Override
            protected Long getPeriod() {
                return 600000L;
            }

            @Override
            protected Long getDelay() {
                return 600000L;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return true;
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return Collections.emptySet();
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_processingExchangeFile);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.parsers.ExchangeProcessingTask";
            }

            @Override
            protected String getCron() {
                return config.getProperty("exchangeProcessing.cron");
            }

            @Override
            protected Long getPeriod() {
                return null;
            }

            @Override
            protected Long getDelay() {
                return null;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.AUTO_EXCHANGE_PROCESSING_ENABLED, (boolean)false);
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return Collections.emptySet();
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_bdCopy);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.backup.BackupTask";
            }

            @Override
            protected String getCron() {
                return config.getProperty("backup.cron");
            }

            @Override
            protected Long getPeriod() {
                return null;
            }

            @Override
            protected Long getDelay() {
                return null;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return !TextUtil.isBlank((String)this.getCron());
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return 10.trimParams(config, "backup.copy_command", "backup.vacuum_command", "backup.cleanup_command", "backup.compress_command", "backup.server_stop_command", "backup.server_start_command");
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_updateLicenses);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.licence.service.LicenceCheckerTask";
            }

            @Override
            protected String getCron() {
                return null;
            }

            @Override
            protected Long getPeriod() {
                return 3600000L;
            }

            @Override
            protected Long getDelay() {
                return 600000L;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return true;
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return Collections.emptySet();
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_sentMetaInstal);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.licence.service.MetadataSenderTask";
            }

            @Override
            protected String getCron() {
                return null;
            }

            @Override
            protected Long getPeriod() {
                return 18000000L;
            }

            @Override
            protected Long getDelay() {
                return 2400000L;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return true;
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return Collections.emptySet();
            }
        });
        configs.add(new TaskConfig(){

            @Override
            protected String getName() {
                return L10n.get((String)Messages.ScheduledTasksConfigurationMigrationHandler_clearOldBlock);
            }

            @Override
            protected String getJobClass() {
                return "com.gridnine.xtrip.server.ExpiredLockCleanerTask";
            }

            @Override
            protected String getCron() {
                return null;
            }

            @Override
            protected Long getPeriod() {
                return 10000L;
            }

            @Override
            protected Long getDelay() {
                return 0L;
            }

            @Override
            protected boolean isLocal() {
                return false;
            }

            @Override
            protected boolean isEnabled() {
                return true;
            }

            @Override
            protected Collection<NamedValue> getParameters() {
                return Collections.emptySet();
            }
        });
        for (TaskConfig taskConfig : configs) {
            storage.save(taskConfig.toContainer(), true);
        }
    }

    static abstract class TaskConfig {
        TaskConfig() {
        }

        protected abstract String getName();

        protected abstract String getJobClass();

        protected abstract String getCron();

        protected abstract Long getPeriod();

        protected abstract Long getDelay();

        protected abstract boolean isLocal();

        protected abstract boolean isEnabled();

        protected abstract Collection<NamedValue> getParameters();

        protected static Collection<NamedValue> trimParams(ExtendedProperties config, String ... params) {
            ArrayList<NamedValue> result = new ArrayList<NamedValue>(params.length);
            for (String param : params) {
                result.add(NamedValueHelper.namedValue((String)param.substring(param.lastIndexOf(46) + 1), (String)config.getProperty(param)));
            }
            return result;
        }

        EntityContainer<ScheduledTaskSettings> toContainer() {
            EntityContainer ctr = new EntityContainer(ScheduledTaskSettings.class);
            ((ScheduledTaskSettings)ctr.getEntity()).setCron(this.getCron());
            ((ScheduledTaskSettings)ctr.getEntity()).setPeriod(this.getPeriod());
            ((ScheduledTaskSettings)ctr.getEntity()).setDelay(this.getDelay());
            ((ScheduledTaskSettings)ctr.getEntity()).setLocal(this.isLocal());
            ((ScheduledTaskSettings)ctr.getEntity()).getDataMap().addAll(this.getParameters());
            ((ScheduledTaskSettings)ctr.getEntity()).setJobClass(this.getJobClass());
            ((ScheduledTaskSettings)ctr.getEntity()).setName(this.getName());
            ((ScheduledTaskSettings)ctr.getEntity()).setEnabled(this.isEnabled());
            ((ScheduledTaskSettings)ctr.getEntity()).setType(SystemSettingsType.SCHEDULED_TASK_SETTINGS);
            return ctr;
        }
    }
}

