/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.TchXmlCommissionsImportHelper;
import com.gridnine.xtrip.common.parsers.model.TchXmlCommissionsImportSettings;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TchRulesConditionsMigrationHandler
implements SetupUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(TchRulesConditionsMigrationHandler.class);

    public void execute(Element command) throws Exception {
        try {
            EntityContainer<? extends BaseRulesContainer> ctr = this.findRulesContainer();
            if (ctr != null) {
                RuleSet ruleSet = ProfileHelper.getRuleSet(ctr);
                TchRulesConditionsMigrationHandler.migrate(ruleSet, ctr);
            }
        }
        catch (Exception e) {
            log.error("failed to migrate conditions in Tch rules", (Throwable)e);
        }
    }

    private EntityContainer<? extends BaseRulesContainer> findRulesContainer() {
        EntityContainer settingsCtr = EntityStorage.get().resolve(TchXmlCommissionsImportHelper.settingsRef);
        if (settingsCtr != null) {
            if (((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getModelContract() != null) {
                return EntityStorage.get().resolve(((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getModelContract());
            }
            EntityContainer contractCtr = EntityStorage.get().resolve(((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getContract());
            if (contractCtr != null && !((Contract)contractCtr.getEntity()).isNewModel()) {
                return contractCtr;
            }
        }
        return null;
    }

    private static void migrate(RuleSet ruleSet, EntityContainer<?> ctr) {
        if (ruleSet == null || ruleSet.getRules() == null) {
            return;
        }
        boolean modified = false;
        for (RuleSettings rs : ruleSet.getRules()) {
            for (RuleRestriction restriction : rs.getRestrictions()) {
                if (restriction.getCondition() != Conditions.TCH_SERVICE_TYPE_AIR_AND_EXCESS_BAGGAGE) continue;
                restriction.setCondition((RuleCondition)Conditions.TCH_SERVICE_TYPE_AIR_TICKETS);
                modified = true;
            }
        }
        if (modified) {
            try {
                ctr.getVersionInfo().setDataSource("server");
                ctr.getVersionInfo().setVersionNotes("TchRulesConditionsMigrationHandler");
                EntityStorage.get().save(ctr, true);
            }
            catch (Exception e) {
                log.error(String.format("failed to save rules, %s", ctr), (Throwable)e);
            }
        }
    }
}

