/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.HashSet;
import org.w3c.dom.Element;

public class UpdateBillingItemsTravellerCaptionsHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        EntityStorageContext context = new EntityStorageContext();
        HashSet<String> processedBillingItemsListUids = new HashSet<String>();
        for (ShipmentIndex shipmentIndex : EntityStorage.get().search(ShipmentIndex.class, new SearchQuery()).getData()) {
            EntityContainer shipment = EntityStorage.get().resolve(shipmentIndex.getSource());
            if (EntityStorageHelper.isEmpty((EntityContainer)shipment)) continue;
            for (NestedEntityReference billingItemReference : ((Shipment)shipment.getEntity()).getBillingItems()) {
                EntityContainer billingItemList;
                if (processedBillingItemsListUids.contains(billingItemReference.getUid()) || EntityStorageHelper.isEmpty((EntityContainer)(billingItemList = EntityStorage.get().resolve((EntityReference)billingItemReference)))) continue;
                boolean changed = false;
                for (BillingItem billingItem : ((BillingItemsList)billingItemList.getEntity()).getData()) {
                    Traveller traveller = (Traveller)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getTraveller(), (EntityStorageContext)context);
                    if (traveller == null) continue;
                    billingItem.getTraveller().setCaption(traveller.getName());
                    changed = true;
                }
                if (changed) {
                    billingItemList.getVersionInfo().setDataSource("update billing items traveller names");
                    EntityStorage.get().save(billingItemList, true);
                }
                processedBillingItemsListUids.add(billingItemReference.getUid());
            }
        }
    }
}

