/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.net.UpdateServerSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class UpdateServerSettingsMigrationHandler
implements SetupUpdateHandler {
    private final String CONTAINER_UID = UniqueSettingsRegistry.get().getUidByClassName(UpdateServerSettings.class.getName());

    public void execute(Element command) throws Exception {
        boolean settingsAlreadyPresent;
        Logger log = LoggerFactory.getLogger(this.getClass());
        String displayName = ((EntityType)MetaRegistry.get().getEntities().get(UpdateServerSettings.class.getName())).getDisplayName();
        if ("true".equals(System.getProperty("use-update-params-from-boot.properties"))) {
            log.info("skipping migration of UpdateServerSettings due to system property use-update-params-from-boot.properties=true");
            return;
        }
        log.debug("update server settings migration started");
        boolean bl = settingsAlreadyPresent = EntityStorage.get().load(UpdateServerSettings.class, this.CONTAINER_UID) != null;
        if (settingsAlreadyPresent) {
            log.debug("update server settings migration interrupted - settings already present");
            return;
        }
        ExtendedProperties configuration = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        UpdateServerSettings settings = new UpdateServerSettings();
        settings.setUpdateUrl(configuration.getProperty("update.url"));
        settings.setUserName(configuration.getProperty("update.username"));
        settings.setPassword(configuration.getProperty("update.password"));
        settings.setName(displayName);
        settings.setType(SystemSettingsType.OTHER);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)settings, (String)this.CONTAINER_UID), true);
        Path path = Paths.get(Environment.getConfigurationFolder() + File.separator + "boot.properties", new String[0]);
        List result = Files.readAllLines(path).stream().filter(entry -> {
            boolean isToBeExcluded = entry.contains("com.gridnine.xtrip.server.update.url") || entry.contains("com.gridnine.xtrip.server.update.username") || entry.contains("com.gridnine.xtrip.server.update.password");
            return !isToBeExcluded || entry.startsWith("#");
        }).collect(Collectors.toList());
        Files.write(path, result, StandardOpenOption.TRUNCATE_EXISTING);
        log.debug("url connection info settings migration finished");
    }
}

