/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.Workspace;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class UpdateWorkspaceHandler
implements SetupUpdateHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Element elm) throws Exception {
        Element root;
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        if (TextUtil.isBlank((String)fileName)) {
            this.log.warn("fileName is null, workspace update will be skipped");
            return;
        }
        String uids = XHelper.readString((Element)elm, (String)"@uids");
        ArrayList<String> workspaceUids = new ArrayList<String>();
        if (!TextUtil.isBlank((String)uids)) {
            for (String uid : uids.split(",")) {
                if (TextUtil.isBlank((String)uid)) continue;
                workspaceUids.add(uid.trim());
                this.log.debug(String.format("adding uid \"%s\" to uids list", uid.trim()));
            }
        } else {
            this.log.debug("attribute \"uids\" is undefined");
        }
        URL url = new URL(String.format("file:///%s/setup/assets/%s", Environment.getConfigurationFolder().getCanonicalPath(), fileName));
        if (!IoUtil.isResourceExists((URL)url)) {
            this.log.warn(String.format("resource with URL \"%s\" does not exist", url));
            return;
        }
        try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
            root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
        }
        root.getOwnerDocument().setDocumentURI(url.toExternalForm());
        this.log.debug("start listing all Workspace elements from file " + url.getFile());
        for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            String uid = XmlUtil.getValue((Element)objElm, (String)"uid");
            this.log.debug("analizing object with uid " + uid);
            if (!Workspace.class.getName().equals(XmlUtil.getValue((Element)objElm, (String)"@class"))) {
                this.log.debug(String.format("object with uid \"%s\"is not a Workspace, skipping", uid));
                continue;
            }
            if (!(workspaceUids.isEmpty() || uid != null && workspaceUids.contains(uid))) {
                this.log.debug(String.format("uid \"%s\" is not present in uids list, skipping", uid));
                continue;
            }
            Workspace workspace = null;
            if (!TextUtil.isBlank((String)uid)) {
                this.log.debug(String.format("searching existing workspace with uid %s", uid));
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"uid", (Object)uid));
                List data = AssetsStorage.get().search(Workspace.class, query).getData();
                if (!data.isEmpty()) {
                    this.log.debug(String.format("workspace with uid \"%s\" found in DB", uid));
                    workspace = (Workspace)data.get(0);
                }
            }
            if (workspace == null) {
                this.log.debug(String.format("workspace with uid \"%s\" was not found in DB, creating new workspace", uid));
                workspace = new Workspace();
            }
            workspace.fromXML(objElm);
            if (TextUtil.isBlank((String)workspace.getUid())) {
                workspace.setUid(UUIDGenerator.generate((boolean)false).toString());
                this.log.debug(String.format("generating new uid workspace: \"%s\"", workspace.getUid()));
            }
            AssetsStorage.get().save(workspace);
            this.log.debug(String.format("workspace with uid \"%s\" was updated", workspace.getUid()));
        }
    }
}

