/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.UrlConnectionInfoSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class UrlConnectionInfoSettingsMigrationHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        boolean settingsAlreadyPresent;
        Logger log = LoggerFactory.getLogger(this.getClass());
        String displayName = ((EntityType)MetaRegistry.get().getEntities().get(UrlConnectionInfoSettings.class.getName())).getDisplayName();
        log.debug("url connection info settings migration started");
        boolean bl = settingsAlreadyPresent = EntityStorage.get().load(UrlConnectionInfoSettings.class, UniqueSettingsRegistry.get().getUidByClassName(UrlConnectionInfoSettings.class.getName())) != null;
        if (settingsAlreadyPresent) {
            log.debug("url connection info settings migration interrupted - settings already present");
            return;
        }
        ExtendedProperties configuration = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        UrlConnectionInfoSettings settings = new UrlConnectionInfoSettings();
        settings.setProxyHost(configuration.getProperty("update.proxy.host"));
        settings.setProxyPort(configuration.getProperty("update.proxy.port"));
        settings.setProxyUserName(configuration.getProperty("update.proxy.username"));
        settings.setProxyPassword(configuration.getProperty("update.proxy.password"));
        settings.setName(displayName);
        settings.setType(SystemSettingsType.OTHER);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)settings, (String)UniqueSettingsRegistry.get().getUidByClassName(UrlConnectionInfoSettings.class.getName())), true);
        Path path = Paths.get(Environment.getConfigurationFolder() + File.separator + "boot.properties", new String[0]);
        List result = Files.readAllLines(path).stream().filter(entry -> {
            boolean isToBeExcluded = entry.contains("com.gridnine.xtrip.server.update.proxy.host") || entry.contains("com.gridnine.xtrip.server.update.proxy.port") || entry.contains("com.gridnine.xtrip.server.update.proxy.username") || entry.contains("com.gridnine.xtrip.server.update.proxy.password");
            return !isToBeExcluded || entry.startsWith("#");
        }).collect(Collectors.toList());
        Files.write(path, result, StandardOpenOption.TRUNCATE_EXISTING);
        log.debug("url connection info settings migration finished");
    }
}

