/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dict;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.util.LogUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationStartedInterceptor;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoLocationInterceptor
implements DictionaryStorageOperationStartedInterceptor {
    private static void checkParentCycle(GeoLocation geoLocation) {
        LinkedHashSet<Object> visited = new LinkedHashSet<Object>();
        visited.add(geoLocation.toReference());
        DictionaryReference parent = geoLocation.getParent();
        while (parent != null) {
            if (!visited.add(parent)) {
                throw Xeption.forEndUser((String)"\u041d\u0430\u0439\u0434\u0435\u043d \u0446\u0438\u043a\u043b \u0432 \u0446\u0435\u043f\u043e\u0447\u043a\u0435 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u0435\u0439 {0}", (Object[])new Object[]{((Object)visited).toString()});
            }
            GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(parent);
            parent = loc == null ? null : loc.getParent();
        }
    }

    public double getPriority() {
        return 0.0;
    }

    public void beforeSave(SessionCallback ss, BaseDictionary data) {
        if (!(data instanceof GeoLocation)) {
            return;
        }
        GeoLocation geoLocation = (GeoLocation)data;
        GeoLocationInterceptor.checkParentCycle(geoLocation);
        this.checkChanges(geoLocation);
    }

    private void checkChanges(GeoLocation newData) {
        GeoLocation oldData = (GeoLocation)DictionaryCache.get().findByCode(GeoLocation.class, newData.getCode());
        if (oldData == null) {
            return;
        }
        if (!Objects.equals(newData.getParent(), oldData.getParent())) {
            this.getLog().info(LogUtil.getStackTrace((String)String.format("changing parent of %s (code=%s) from %s to %s", GeoLocation.class.getSimpleName(), newData.getCode(), oldData.getParent(), newData.getParent())));
        }
        String codeSystem = "IATA";
        if (!oldData.getCodeVariants().containsKey(codeSystem) && newData.getCodeVariants().containsKey(codeSystem)) {
            this.getLog().info(LogUtil.getStackTrace((String)String.format("adding %s code (%s) to %s (code=%s)", codeSystem, newData.getCodeVariants().get(codeSystem), GeoLocation.class.getSimpleName(), newData.getCode())));
        }
    }

    private Logger getLog() {
        return LoggerFactory.getLogger(DictionaryCache.class);
    }

    public void beforeDelete(SessionCallback ss, BaseDictionary data) {
    }
}

