/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dict;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategoryValue;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationStartedInterceptor;

public class PassengerTypeCategoryDictionaryInterceptor
implements DictionaryStorageOperationStartedInterceptor {
    public double getPriority() {
        return 0.0;
    }

    public void beforeSave(SessionCallback ss, BaseDictionary data) throws Exception {
        if (!(data instanceof PassengerTypeCategory)) {
            return;
        }
        String uidCode = this.getCodeByUid(data.getUid());
        PassengerTypeCategoryValue ptValue = (PassengerTypeCategoryValue)CollectionUtil.findEnumConstant(PassengerTypeCategoryValue.class, (String)uidCode);
        if (ptValue != null && !uidCode.equals(data.getCode())) {
            throw new Exception("unable to modify code of predefined dict value");
        }
    }

    public void beforeDelete(SessionCallback ss, BaseDictionary data) throws Exception {
        if (!(data instanceof PassengerType)) {
            return;
        }
        PassengerTypeCategoryValue ptValue = (PassengerTypeCategoryValue)CollectionUtil.findEnumConstant(PassengerTypeCategoryValue.class, (String)this.getCodeByUid(data.getUid()));
        if (ptValue != null) {
            throw new Exception("unable to delete predefined dict value");
        }
    }

    private String getCodeByUid(String dictUid) {
        return dictUid.replaceAll("_CATEGORY$", "");
    }
}

