/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dict;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.DictRequest;
import com.gridnine.xtrip.common.model.dict.DictResponse;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.dict.RemoteDictionaryResolver;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ServerDictionaryResolver
extends RemoteDictionaryResolver {
    private static final String CONST = "eriuhgjdsnf98743qhr*%&*jhgjkwh4ykhjfjhsdh";

    public List<Hotel> getHotel(String hotelId) {
        return this.getHotel(hotelId, "", "", "", "", 50);
    }

    public List<Hotel> getHotel(String hotelId, String countryCode, String cityCode, String chainCode, String partOfName, int limit) {
        DictResponse dr;
        DictRequest data = new DictRequest();
        data.setHotelId(hotelId);
        data.setCountryCode(countryCode);
        data.setCityCode(cityCode);
        data.setChainCode(chainCode);
        data.setPartOfName(partOfName);
        data.setLimit(limit);
        SynchronizationResponse<DictResponse> response = this.processRequest(data);
        ArrayList<Hotel> result = new ArrayList<Hotel>();
        if (response != null && (dr = response.getData()) != null && dr.getHotels() != null) {
            for (String hotelStr : dr.getHotels()) {
                if (TextUtil.isBlank((String)hotelStr)) continue;
                Hotel hotel = new Hotel();
                try {
                    XUtil.fromString((String)DesUtil.decrypt((char[])CONST.toCharArray(), (String)hotelStr), (XSerializable)hotel);
                }
                catch (Exception e) {
                    log.error("Broken xml for dictionary", (Throwable)e);
                }
                result.add(hotel);
            }
        }
        return result;
    }

    private SynchronizationResponse<DictResponse> processRequest(DictRequest data) {
        SynchronizationRequest<DictRequest> request = new SynchronizationRequest<DictRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        request.setOperationId("dict-processing");
        request.setUser("hotelRequestUser");
        ValueHolder trace = new ValueHolder();
        return SynchronizationHelper.execute(request, Address.getSync(), (int)TimeUnit.MINUTES.toMillis(1L), null, (ValueHolder<String>)trace);
    }
}

