/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dict;

import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.GeoRegionProvider;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.Serializable;
import java.util.Map;

public class ServerGeoRegionProvider
extends GeoRegionProvider {
    public void saveGeoRegion(String value) {
        AsyncExecutor.get().execute(((Object)((Object)this)).getClass().getName(), (AsyncCommand & Serializable)() -> {
            try {
                GeoRegion existRegion;
                LogicalStorage.get().authorizeAsSystem();
                Map translations = DictHelper.getTranslationsFromL10nString((String)value);
                String code = DictHelper.getGeoRegionCode((Map)translations);
                if (TextUtil.isBlank((String)code)) {
                    code = value;
                }
                if ((existRegion = (GeoRegion)DictionaryStorage.get().load(GeoRegion.class, code)) == null) {
                    GeoRegion region = new GeoRegion();
                    region.setCode(code);
                    region.setUid(UUIDGenerator.generate().toString());
                    region.getTranslations().putAll(translations);
                    region.setDataSource("ServerGeoRegionProvider");
                    LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)region);
                }
            }
            catch (Exception e) {
                log.error(String.format("failed to save GeoRegion from value %s", value), (Throwable)e);
            }
        }, new AsyncCommandOption[]{AsyncCommandOption.LOCAL});
    }
}

