/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dicts.merge;

import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.server.model.dicts.merge.Exporters;
import com.gridnine.xtrip.server.model.dicts.merge.Indicators;
import com.gridnine.xtrip.server.model.dicts.merge.MergeHelper;
import com.gridnine.xtrip.server.model.dicts.merge.Parsers;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.Ignore;
import org.junit.Test;

public class AircraftDictionariesMergeTest {
    @Ignore
    @Test
    public void mergeAircrafts() throws Exception {
        Parsers.AircraftParserResult newAircrafts = Parsers.newAircraftCsvParser(Paths.get("/home/badanin/\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b/XTR-6073/ACT.txt", new String[0]), "\\t", Charset.forName("cp1251")).parse();
        Parsers.AircraftParserResult newAircraftsMods = Parsers.newAircraftCsvParser(Paths.get("/home/badanin/\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b/XTR-6073/ACTmod.txt", new String[0]), "\\t", Charset.forName("cp1251")).parse();
        Parsers.AircraftParserResult originalAircrafts = Parsers.newAircraftXmlParser(Paths.get("/home/badanin/\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b/XTR-6073/Aircraft.xml", new String[0])).parse();
        ArrayList<Parsers.AircraftParserResult> candidateAircraftsBatches = new ArrayList<Parsers.AircraftParserResult>();
        candidateAircraftsBatches.add(newAircrafts);
        candidateAircraftsBatches.add(newAircraftsMods);
        AircraftDictionariesMergeTest.merge(originalAircrafts, candidateAircraftsBatches);
    }

    private static void merge(Parsers.AircraftParserResult initialAircraftsResult, List<Parsers.AircraftParserResult> candidateAircraftResults) throws Exception {
        Collection<Aircraft> initialAircrafts = initialAircraftsResult.getAircrafts();
        HashSet<Aircraft> aircrafts = new HashSet<Aircraft>();
        aircrafts.addAll(initialAircrafts);
        int batch = 0;
        for (Parsers.AircraftParserResult candidateAircraftResult : candidateAircraftResults) {
            Collection<Aircraft> candidateAircrafts = candidateAircraftResult.getAircrafts();
            HashMap<String, Aircraft> aircraftMapping = new HashMap<String, Aircraft>();
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("merging aircrafts batch %s", String.valueOf(batch + 1)), candidateAircrafts.size());
            int count = 0;
            for (Aircraft candidateAircraft : candidateAircrafts) {
                indicator.update(count);
                Aircraft aircraft = MergeHelper.match(candidateAircraft, aircrafts);
                if (aircraft != null) {
                    MergeHelper.merge(aircraft, candidateAircraft);
                    aircraftMapping.put(candidateAircraft.getCode(), aircraft);
                } else {
                    aircrafts.add(candidateAircraft);
                    aircraftMapping.put(candidateAircraft.getCode(), candidateAircraft);
                }
                ++count;
            }
            ++batch;
        }
        Exporters.newAircraftsXmlExporter(Paths.get("/home/badanin/\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b/XTR-6073/result.xml", new String[0])).export(aircrafts);
    }
}

