/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dicts.merge;

import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.server.model.dicts.merge.Exporters;
import com.gridnine.xtrip.server.model.dicts.merge.Fields;
import com.gridnine.xtrip.server.model.dicts.merge.Indicators;
import com.gridnine.xtrip.server.model.dicts.merge.MergeHelper;
import com.gridnine.xtrip.server.model.dicts.merge.Parsers;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Ignore;
import org.junit.Test;

public class CountryDictionariesMergeTest
extends TestBase {
    @Ignore
    @Test
    public void mergeCountries() throws Exception {
        Parsers.GeoRegionsParserResult regionsParserResult = Parsers.newGeoRegionsXmlParser(Paths.get("c:/geolocations2/xtrip/regions.xml", new String[0])).parse();
        Parsers.CountriesParserResult countryParserResult = Parsers.newCountriesXmlParser(Paths.get("c:/geolocations2/xtrip/countries-output.xml", new String[0])).parse();
        ArrayList<Parsers.CountriesParserResult> candidateCountryParserResults = new ArrayList<Parsers.CountriesParserResult>();
        candidateCountryParserResults.add(Parsers.newCountriesCsvParser(Paths.get("c:/geolocations2/tch/countries.txt", new String[0]), "\\t", Charset.forName("cp1251")).parse());
        CountryDictionariesMergeTest.merge(regionsParserResult, countryParserResult, candidateCountryParserResults);
    }

    private static void merge(Parsers.GeoRegionsParserResult regionsParserResult, Parsers.CountriesParserResult countryParserResult, List<Parsers.CountriesParserResult> candidateCountryParserResults) throws Exception {
        Collection<GeoRegion> regions = regionsParserResult.getRegions();
        Collection<Country> countries = countryParserResult.getCountries();
        int batch = 0;
        int count = 0;
        for (Parsers.CountriesParserResult candidateCountryResult : candidateCountryParserResults) {
            Collection<Country> candidateCountries = candidateCountryResult.getCountries();
            HashMap<String, Country> countryMapping = new HashMap<String, Country>();
            ArrayList<Country> notFoundCountries = new ArrayList<Country>();
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("merging countries batch %s", String.valueOf(batch + 1)), candidateCountries.size());
            count = 0;
            for (Country candidateCountry : candidateCountries) {
                indicator.update(count);
                Country country = MergeHelper.match(candidateCountry, countries);
                if (country != null) {
                    MergeHelper.merge(country, candidateCountry);
                    countryMapping.put(candidateCountry.getCode(), country);
                } else {
                    countries.add(candidateCountry);
                    countryMapping.put(candidateCountry.getCode(), candidateCountry);
                    notFoundCountries.add(candidateCountry);
                }
                ++count;
            }
            Exporters.newCountriesXlsxExporter(Paths.get(String.format("c:/geolocations2/countries-not-found-%s.xlsx", String.valueOf(batch)), new String[0])).export(notFoundCountries, Arrays.asList(Fields.CountryField.values()));
            ++batch;
        }
        ArrayList<Country> invalidatedCountries = new ArrayList<Country>();
        Map<String, GeoRegion> regionCodes = regions.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator("validating countries", countries.size());
        count = 0;
        for (Country country : countries) {
            indicator.update(count);
            if (country.getRegions().stream().anyMatch(item -> item == null || regionCodes.get(item.getCode()) == null)) {
                invalidatedCountries.add(country);
            }
            ++count;
        }
        indicator = Indicators.newDescreteProgressIndicator("fining countries", countries.size());
        count = 0;
        for (Country country : countries) {
            indicator.update(count);
            List collect = country.getRegions().stream().map(item -> (GeoRegion)regionCodes.get(item.getCode())).filter(item -> item != null).map(item -> item.toReference()).collect(Collectors.toList());
            country.getRegions().clear();
            country.getRegions().addAll(collect);
            ++count;
        }
        Exporters.newCountriesXlsxExporter(Paths.get("c:/geolocations2/countries-invalidated.xlsx", new String[0])).export(invalidatedCountries, Arrays.asList(Fields.CountryField.values()));
        Exporters.newCountriesXmlExporter(Paths.get("c:/geolocations2/countries-output.xml", new String[0])).export(countries, null);
    }
}

