/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dicts.merge;

import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.dicts.merge.Fields;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class Exporters {
    Exporters() {
    }

    public static CountriesExporter newCountriesXmlExporter(Path path) {
        return new CountriesXmlExporter(path);
    }

    public static CountriesExporter newCountriesXlsxExporter(Path path) {
        return new CountriesXlsxExporter(path);
    }

    public static GeoLocationsExporter newGeoLocationsXmlExporter(Path path) {
        return new GeoLocationsXmlExporter(path);
    }

    public static GeoLocationsExporter newGeoLocationsCsvExporter(Path path, String separator, Charset charset) {
        return new GeoLocationsCsvExporter(path, separator, charset);
    }

    public static GeoLocationsExporter newGeoLocationsXlsxExporter(Path path) {
        return new GeoLocationsXlsxExporter(path);
    }

    public static AircraftsExporter newAircraftsXmlExporter(Path path) {
        return new AircraftsXmlExporter(path);
    }

    private static class GeoLocationsXlsxExporter
    implements GeoLocationsExporter {
        final Path path;

        GeoLocationsXlsxExporter(Path path) {
            this.path = path;
        }

        @Override
        public void export(Collection<GeoLocation> locations, Collection<Country> countriesRegistry, Collection<GeoLocation> locationsRegistry, Collection<Fields.GeoLocationField> fields) throws Exception {
            try (XSSFWorkbook book = new XSSFWorkbook();){
                Sheet sheet = book.createSheet("locations");
                Map<String, GeoLocation> locationCodes = locationsRegistry.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
                Map<String, Country> countryCodes = countriesRegistry.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
                int rowIndex = 0;
                int columnIndex = 0;
                Row headerRow = sheet.createRow(0);
                for (Fields.GeoLocationField field : fields) {
                    Cell headerCell = headerRow.createCell(columnIndex);
                    headerCell.setCellValue(field.name());
                    ++columnIndex;
                }
                ++rowIndex;
                for (GeoLocation location : locations) {
                    List values = fields.stream().map(item -> {
                        if (item == Fields.GeoLocationField.TYPE) {
                            return location.getType() != null ? location.getType().name() : "";
                        }
                        if (item == Fields.GeoLocationField.CODE) {
                            return location.getCode() != null ? location.getCode() : "";
                        }
                        if (item == Fields.GeoLocationField.CODE_IATA) {
                            return location.getCodeVariants().get(CodeSystem.IATA.name()) != null ? (String)location.getCodeVariants().get(CodeSystem.IATA.name()) : "";
                        }
                        if (item == Fields.GeoLocationField.CODE_CRT) {
                            return location.getCodeVariants().get(CodeSystem.CRT.name()) != null ? (String)location.getCodeVariants().get(CodeSystem.CRT.name()) : "";
                        }
                        if (item == Fields.GeoLocationField.NAME_EN) {
                            return location.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_EN)).map(value -> (String)value.getValue()).findFirst().orElse("");
                        }
                        if (item == Fields.GeoLocationField.NAME_RU) {
                            return location.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_RU)).map(value -> (String)value.getValue()).findFirst().orElse("");
                        }
                        if (item == Fields.GeoLocationField.CITY_CODE_IATA || item == Fields.GeoLocationField.CITY_CODE_CRT || item == Fields.GeoLocationField.CITY_NAME_EN || item == Fields.GeoLocationField.CITY_NAME_RU) {
                            GeoLocation city = Optional.ofNullable(location.getParent()).map(value -> (GeoLocation)locationCodes.get(value.getCode())).filter(value -> value.getType() == LocationType.CITY).orElse(null);
                            if (city != null) {
                                if (item == Fields.GeoLocationField.CITY_CODE_IATA) {
                                    return city.getCodeVariants().get(CodeSystem.IATA.name()) != null ? (String)city.getCodeVariants().get(CodeSystem.IATA.name()) : "";
                                }
                                if (item == Fields.GeoLocationField.CITY_CODE_CRT) {
                                    return city.getCodeVariants().get(CodeSystem.CRT.name()) != null ? (String)city.getCodeVariants().get(CodeSystem.CRT.name()) : "";
                                }
                                if (item == Fields.GeoLocationField.CITY_NAME_EN) {
                                    return city.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_EN)).map(value -> (String)value.getValue()).findFirst().orElse("");
                                }
                                if (item == Fields.GeoLocationField.CITY_NAME_RU) {
                                    return city.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_RU)).map(value -> (String)value.getValue()).findFirst().orElse("");
                                }
                            } else {
                                return "";
                            }
                        }
                        if (item == Fields.GeoLocationField.COUNTRY_CODE_IATA || item == Fields.GeoLocationField.COUNTRY_CODE_CRT || item == Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_2 || item == Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_3) {
                            Country country = Optional.ofNullable(location.getCountry()).map(value -> (Country)countryCodes.get(value.getCode())).orElse(null);
                            if (country != null) {
                                if (item == Fields.GeoLocationField.COUNTRY_CODE_IATA) {
                                    return country.getCodeVariants().get(CodeSystem.IATA.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.IATA.name()) : "";
                                }
                                if (item == Fields.GeoLocationField.COUNTRY_CODE_CRT) {
                                    return country.getCodeVariants().get(CodeSystem.CRT.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.CRT.name()) : "";
                                }
                                if (item == Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_2) {
                                    return country.getCodeVariants().get(CodeSystem.ISO.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.ISO.name()) : "";
                                }
                                if (item == Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_3) {
                                    return country.getCodeVariants().get(CodeSystem.ISO_ALPHA3.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.ISO_ALPHA3.name()) : "";
                                }
                            } else {
                                return "";
                            }
                        }
                        return "";
                    }).collect(Collectors.toList());
                    Row row = sheet.createRow(rowIndex);
                    columnIndex = 0;
                    for (String value : values) {
                        Cell cell = row.createCell(columnIndex);
                        cell.setCellValue(value);
                        ++columnIndex;
                    }
                    ++rowIndex;
                }
                try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);){
                    book.write(os);
                }
            }
        }
    }

    private static class GeoLocationsCsvExporter
    implements GeoLocationsExporter {
        final Path path;
        final String separator;
        final Charset charset;

        GeoLocationsCsvExporter(Path path, String separator, Charset charset) {
            this.path = path;
            this.separator = separator;
            this.charset = charset;
        }

        @Override
        public void export(Collection<GeoLocation> locations, Collection<Country> countriesRegistry, Collection<GeoLocation> locationsRegistry, Collection<Fields.GeoLocationField> fields) throws Exception {
            Map<String, Country> countryCodes = countriesRegistry.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
            Map<String, GeoLocation> locationCodes = locationsRegistry.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
            ArrayList<String> lines = new ArrayList<String>();
            for (GeoLocation location : locations) {
                String line = fields.stream().map(item -> {
                    if (item == Fields.GeoLocationField.TYPE) {
                        return location.getType() != null ? location.getType().name() : "";
                    }
                    if (item == Fields.GeoLocationField.CODE) {
                        return location.getCode() != null ? location.getCode() : "";
                    }
                    if (item == Fields.GeoLocationField.CODE_IATA) {
                        return location.getCodeVariants().get(CodeSystem.IATA.name()) != null ? (String)location.getCodeVariants().get(CodeSystem.IATA.name()) : "";
                    }
                    if (item == Fields.GeoLocationField.CODE_CRT) {
                        return location.getCodeVariants().get(CodeSystem.CRT.name()) != null ? (String)location.getCodeVariants().get(CodeSystem.CRT.name()) : "";
                    }
                    if (item == Fields.GeoLocationField.NAME_EN) {
                        return location.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_EN)).map(value -> (String)value.getValue()).findFirst().orElse("");
                    }
                    if (item == Fields.GeoLocationField.NAME_RU) {
                        return location.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_RU)).map(value -> (String)value.getValue()).findFirst().orElse("");
                    }
                    if (item == Fields.GeoLocationField.CITY_CODE_IATA || item == Fields.GeoLocationField.CITY_CODE_CRT || item == Fields.GeoLocationField.CITY_NAME_EN || item == Fields.GeoLocationField.CITY_NAME_RU) {
                        GeoLocation city = Optional.ofNullable(location.getParent()).map(value -> (GeoLocation)locationCodes.get(value.getCode())).filter(value -> value.getType() == LocationType.CITY).orElse(null);
                        if (city != null) {
                            if (item == Fields.GeoLocationField.CITY_CODE_IATA) {
                                return city.getCodeVariants().get(CodeSystem.IATA.name()) != null ? (String)city.getCodeVariants().get(CodeSystem.IATA.name()) : "";
                            }
                            if (item == Fields.GeoLocationField.CITY_CODE_CRT) {
                                return city.getCodeVariants().get(CodeSystem.CRT.name()) != null ? (String)city.getCodeVariants().get(CodeSystem.CRT.name()) : "";
                            }
                            if (item == Fields.GeoLocationField.CITY_NAME_EN) {
                                return city.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_EN)).map(value -> (String)value.getValue()).findFirst().orElse("");
                            }
                            if (item == Fields.GeoLocationField.CITY_NAME_RU) {
                                return city.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_RU)).map(value -> (String)value.getValue()).findFirst().orElse("");
                            }
                        } else {
                            return "";
                        }
                    }
                    if (item == Fields.GeoLocationField.COUNTRY_CODE_IATA || item == Fields.GeoLocationField.COUNTRY_CODE_CRT || item == Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_2 || item == Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_3) {
                        Country country = Optional.ofNullable(location.getCountry()).map(value -> (Country)countryCodes.get(value.getCode())).orElse(null);
                        if (country != null) {
                            if (item == Fields.GeoLocationField.COUNTRY_CODE_IATA) {
                                return country.getCodeVariants().get(CodeSystem.IATA.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.IATA.name()) : "";
                            }
                            if (item == Fields.GeoLocationField.COUNTRY_CODE_CRT) {
                                return country.getCodeVariants().get(CodeSystem.CRT.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.CRT.name()) : "";
                            }
                            if (item == Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_2) {
                                return country.getCodeVariants().get(CodeSystem.ISO.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.ISO.name()) : "";
                            }
                            if (item == Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_3) {
                                return country.getCodeVariants().get(CodeSystem.ISO_ALPHA3.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.ISO_ALPHA3.name()) : "";
                            }
                        } else {
                            return "";
                        }
                    }
                    return "";
                }).collect(Collectors.joining(this.separator));
                lines.add(line);
            }
            Files.write(this.path, lines, this.charset, new OpenOption[0]);
        }
    }

    private static class GeoLocationsXmlExporter
    implements GeoLocationsExporter {
        final Path path;

        GeoLocationsXmlExporter(Path path) {
            this.path = path;
        }

        @Override
        public void export(Collection<GeoLocation> locations, Collection<Country> countriesRegistry, Collection<GeoLocation> locationsRegistry, Collection<Fields.GeoLocationField> fields) throws Exception {
            try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);){
                Document document = DocumentBuilderHelper.newDocument();
                document.appendChild(document.createElement("objects"));
                document.getDocumentElement().setAttribute("totalCount", Integer.toString(locations.size()));
                for (GeoLocation location : locations) {
                    Element element = document.createElement("object");
                    element.setAttribute("class", location.getClass().getName());
                    document.getDocumentElement().appendChild(element);
                    location.toXML(element);
                    XmlUtil.deleteChild((Element)element, (String)"created");
                    XmlUtil.deleteChild((Element)element, (String)"modified");
                    XmlUtil.deleteChild((Element)element, (String)"createdBy");
                    XmlUtil.deleteChild((Element)element, (String)"modifiedBy");
                }
                XUtil.newTransformer().transform(new DOMSource(document), new StreamResult(os));
            }
        }
    }

    static interface GeoLocationsExporter {
        public void export(Collection<GeoLocation> var1, Collection<Country> var2, Collection<GeoLocation> var3, Collection<Fields.GeoLocationField> var4) throws Exception;
    }

    private static class CountriesXlsxExporter
    implements CountriesExporter {
        final Path path;

        CountriesXlsxExporter(Path path) {
            this.path = path;
        }

        @Override
        public void export(Collection<Country> countries, Collection<Fields.CountryField> fields) throws Exception {
            try (XSSFWorkbook book = new XSSFWorkbook();){
                Sheet sheet = book.createSheet("countries");
                int rowIndex = 0;
                int columnIndex = 0;
                Row headerRow = sheet.createRow(0);
                for (Fields.CountryField field : fields) {
                    Cell headerCell = headerRow.createCell(columnIndex);
                    headerCell.setCellValue(field.name());
                    ++columnIndex;
                }
                ++rowIndex;
                for (Country country : countries) {
                    List values = fields.stream().map(item -> {
                        if (item == Fields.CountryField.CODE) {
                            return country.getCode() != null ? country.getCode() : "";
                        }
                        if (item == Fields.CountryField.CODE_IATA) {
                            return country.getCodeVariants().get(CodeSystem.IATA.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.IATA.name()) : "";
                        }
                        if (item == Fields.CountryField.CODE_CRT) {
                            return country.getCodeVariants().get(CodeSystem.CRT.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.CRT.name()) : "";
                        }
                        if (item == Fields.CountryField.CODE_ISO_ALPHA_2) {
                            return country.getCodeVariants().get(CodeSystem.ISO.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.ISO.name()) : "";
                        }
                        if (item == Fields.CountryField.CODE_ISO_ALPHA_3) {
                            return country.getCodeVariants().get(CodeSystem.ISO_ALPHA3.name()) != null ? (String)country.getCodeVariants().get(CodeSystem.ISO_ALPHA3.name()) : "";
                        }
                        if (item == Fields.CountryField.NAME_EN) {
                            return country.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_EN)).map(value -> (String)value.getValue()).findFirst().orElse("");
                        }
                        if (item == Fields.CountryField.NAME_RU) {
                            return country.getTranslations().entrySet().stream().filter(value -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)value.getKey())), (Object)LocaleUtil.LOCALE_RU)).map(value -> (String)value.getValue()).findFirst().orElse("");
                        }
                        return "";
                    }).collect(Collectors.toList());
                    Row row = sheet.createRow(rowIndex);
                    columnIndex = 0;
                    for (String value : values) {
                        Cell cell = row.createCell(columnIndex);
                        cell.setCellValue(value);
                        ++columnIndex;
                    }
                    ++rowIndex;
                }
                try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);){
                    book.write(os);
                }
            }
        }
    }

    private static class AircraftsXmlExporter
    implements AircraftsExporter {
        final Path path;

        AircraftsXmlExporter(Path path) {
            this.path = path;
        }

        @Override
        public void export(Collection<Aircraft> aircrafts) throws Exception {
            try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);){
                Document document = DocumentBuilderHelper.newDocument();
                document.appendChild(document.createElement("objects"));
                document.getDocumentElement().setAttribute("totalCount", Integer.toString(aircrafts.size()));
                for (Aircraft aircraft : aircrafts) {
                    Element element = document.createElement("object");
                    element.setAttribute("class", aircraft.getClass().getName());
                    document.getDocumentElement().appendChild(element);
                    aircraft.toXML(element);
                    if (aircraft.getSeats() == 0) {
                        XmlUtil.deleteChild((Element)element, (String)"seats");
                    }
                    if (aircraft.getMaxSeats() == 0) {
                        XmlUtil.deleteChild((Element)element, (String)"maxSeats");
                    }
                    XmlUtil.deleteChild((Element)element, (String)"created");
                    XmlUtil.deleteChild((Element)element, (String)"modified");
                    XmlUtil.deleteChild((Element)element, (String)"createdBy");
                    XmlUtil.deleteChild((Element)element, (String)"modifiedBy");
                    XmlUtil.deleteChild((Element)element, (String)"uid");
                }
                XUtil.newTransformer().transform(new DOMSource(document), new StreamResult(os));
            }
        }
    }

    private static class CountriesXmlExporter
    implements CountriesExporter {
        final Path path;

        CountriesXmlExporter(Path path) {
            this.path = path;
        }

        @Override
        public void export(Collection<Country> countries, Collection<Fields.CountryField> fields) throws Exception {
            try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);){
                Document document = DocumentBuilderHelper.newDocument();
                document.appendChild(document.createElement("objects"));
                document.getDocumentElement().setAttribute("totalCount", Integer.toString(countries.size()));
                for (Country country : countries) {
                    Element element = document.createElement("object");
                    element.setAttribute("class", country.getClass().getName());
                    document.getDocumentElement().appendChild(element);
                    country.toXML(element);
                    XmlUtil.deleteChild((Element)element, (String)"created");
                    XmlUtil.deleteChild((Element)element, (String)"modified");
                    XmlUtil.deleteChild((Element)element, (String)"createdBy");
                    XmlUtil.deleteChild((Element)element, (String)"modifiedBy");
                }
                XUtil.newTransformer().transform(new DOMSource(document), new StreamResult(os));
            }
        }
    }

    static interface AircraftsExporter {
        public void export(Collection<Aircraft> var1) throws Exception;
    }

    static interface CountriesExporter {
        public void export(Collection<Country> var1, Collection<Fields.CountryField> var2) throws Exception;
    }
}

