/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dicts.merge;

import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.model.dicts.merge.Exporters;
import com.gridnine.xtrip.server.model.dicts.merge.Fields;
import com.gridnine.xtrip.server.model.dicts.merge.Indicators;
import com.gridnine.xtrip.server.model.dicts.merge.MergeHelper;
import com.gridnine.xtrip.server.model.dicts.merge.Parsers;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Ignore;
import org.junit.Test;

public class GeoLocationDictionariesMergeTest
extends TestBase {
    @Ignore
    @Test
    public void mergeGeoLocations() throws Exception {
        Parsers.CountriesParserResult countryParserResult = Parsers.newCountriesXmlParser(Paths.get("c:/geolocations2/xtrip/countries-output.xml", new String[0])).parse();
        Parsers.GeoLocationsParserResult geoLocationParserResult = Parsers.newGeoLocationsXmlParser(Paths.get("c:/geolocations2/xtrip/locations-output.xml", new String[0])).parse();
        ArrayList<Parsers.GeoLocationsParserResult> candidateLocationsBatches = new ArrayList<Parsers.GeoLocationsParserResult>();
        candidateLocationsBatches.add(Parsers.newGeoLocationsCsvParser(Paths.get("c:/geolocations2/tch/cities.txt", new String[0]), () -> LocationType.CITY, "\\t", Charset.forName("cp1251")).parse());
        candidateLocationsBatches.add(Parsers.newGeoLocationsCsvParser(Paths.get("c:/geolocations2/tch/airports.txt", new String[0]), () -> LocationType.AIRPORT, "\\t", Charset.forName("cp1251")).parse());
        candidateLocationsBatches.add(Parsers.newGeoLocationsCsvParser(Paths.get("c:/geolocations2/iata/iata-converted.csv", new String[0]), () -> LocationType.AIRPORT, ";", Charset.forName("cp1251")).parse());
        GeoLocationDictionariesMergeTest.merge(countryParserResult, geoLocationParserResult, candidateLocationsBatches);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void merge(Parsers.CountriesParserResult initialCountriesResult, Parsers.GeoLocationsParserResult initialLocationsResult, List<Parsers.GeoLocationsParserResult> candidateLocationsResults) throws Exception {
        Collection<Country> initialCountries = initialCountriesResult.getCountries();
        Collection<GeoLocation> initialLocations = initialLocationsResult.getLocations();
        ArrayList<Country> countries = new ArrayList<Country>();
        ArrayList<GeoLocation> locations = new ArrayList<GeoLocation>();
        countries.clear();
        countries.addAll(initialCountries);
        ArrayList<GeoLocation> skippedLocations = new ArrayList<GeoLocation>();
        Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator("skiping locations", initialLocations.size());
        int batch = 0;
        int count = 0;
        for (GeoLocation initialLocation : initialLocations) {
            indicator.update(count);
            if (initialLocation.getType() == null) {
                skippedLocations.add(initialLocation);
            } else {
                locations.add(initialLocation);
            }
            ++count;
        }
        Exporters.newGeoLocationsXlsxExporter(Paths.get("c:/geolocations2/locations-skipped.xlsx", new String[0])).export(skippedLocations, countries, locations, Arrays.asList(Fields.GeoLocationField.values()));
        batch = 0;
        for (Parsers.GeoLocationsParserResult candidateLocationResult : candidateLocationsResults) {
            Country country;
            Collection<Country> candidateCountries = candidateLocationResult.getCountries();
            Collection<GeoLocation> candidateLocations = candidateLocationResult.getLocations();
            HashMap<String, Country> countryMapping = new HashMap<String, Country>();
            HashMap<String, GeoLocation> locationMapping = new HashMap<String, GeoLocation>();
            ArrayList<Country> notFoundCountries = new ArrayList<Country>();
            ArrayList<GeoLocation> notFoundLocations = new ArrayList<GeoLocation>();
            indicator = Indicators.newDescreteProgressIndicator(String.format("merging countries batch %s", String.valueOf(batch + 1)), candidateCountries.size());
            count = 0;
            for (Country candidateCountry : candidateCountries) {
                indicator.update(count);
                country = MergeHelper.match(candidateCountry, countries);
                if (country != null) {
                    MergeHelper.merge(country, candidateCountry);
                    countryMapping.put(candidateCountry.getCode(), country);
                } else {
                    countries.add(candidateCountry);
                    countryMapping.put(candidateCountry.getCode(), candidateCountry);
                    notFoundCountries.add(candidateCountry);
                }
                ++count;
            }
            indicator = Indicators.newDescreteProgressIndicator(String.format("merging locations batch %s", String.valueOf(batch + 1)), candidateLocations.size());
            count = 0;
            for (GeoLocation candidateLocation : candidateLocations) {
                indicator.update(count);
                GeoLocation location = MergeHelper.match(candidateLocation, locations);
                if (location != null) {
                    MergeHelper.merge(location, candidateLocation);
                    locationMapping.put(candidateLocation.getCode(), location);
                } else {
                    locations.add(candidateLocation);
                    locationMapping.put(candidateLocation.getCode(), candidateLocation);
                    notFoundLocations.add(candidateLocation);
                }
                ++count;
            }
            indicator = Indicators.newDescreteProgressIndicator(String.format("checking location batch %s", String.valueOf(batch + 1)), candidateLocations.size());
            count = 0;
            for (GeoLocation candidateLocation : candidateLocations) {
                indicator.update(count);
                if (candidateLocation.getType() == null) {
                    throw new IllegalStateException("no type defined -> " + candidateLocation.getCode());
                }
                if (candidateLocation.getType() == LocationType.AIRPORT) {
                    if (candidateLocation.getParent() == null) throw new IllegalStateException("no parent defined -> " + candidateLocation.getCode());
                    GeoLocation parent = (GeoLocation)locationMapping.get(candidateLocation.getParent().getCode());
                    if (parent == null) throw new IllegalStateException("no parent matched -> " + candidateLocation.getCode());
                    candidateLocation.setParent((DictionaryReference)parent.toReference());
                }
                if (candidateLocation.getCountry() != null) {
                    country = (Country)countryMapping.get(candidateLocation.getCountry().getCode());
                    if (country == null) throw new IllegalStateException("no country matched -> " + candidateLocation.getCode());
                    candidateLocation.setCountry((DictionaryReference)country.toReference());
                }
                ++count;
            }
            Exporters.newCountriesXlsxExporter(Paths.get(String.format("c:/geolocations2/countries-not-found-%s.xlsx", String.valueOf(batch)), new String[0])).export(notFoundCountries, Arrays.asList(Fields.CountryField.values()));
            Exporters.newGeoLocationsXlsxExporter(Paths.get(String.format("c:/geolocations2/locations-not-found-%s.xlsx", String.valueOf(batch)), new String[0])).export(notFoundLocations, countries, locations, Arrays.asList(Fields.GeoLocationField.values()));
            ++batch;
        }
        ArrayList<GeoLocation> invalidatedLocations = new ArrayList<GeoLocation>();
        Map<String, GeoLocation> locationCodes = locations.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        Map<String, Country> countryCodes = countries.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        indicator = Indicators.newDescreteProgressIndicator("validating locations", locations.size());
        count = 0;
        for (GeoLocation location : locations) {
            indicator.update(count);
            if (location.getType() == null || location.getType() == LocationType.AIRPORT && (location.getParent() == null || locationCodes.get(location.getParent().getCode()) == null) || location.getCountry() == null || countryCodes.get(location.getCountry().getCode()) == null) {
                invalidatedLocations.add(location);
            }
            ++count;
        }
        indicator = Indicators.newDescreteProgressIndicator("fining locations", locations.size());
        count = 0;
        for (GeoLocation location : locations) {
            indicator.update(count);
            Optional.ofNullable(location.getParent()).map(item -> (GeoLocation)locationCodes.get(item.getCode())).ifPresent(item -> location.setParent((DictionaryReference)item.toReference()));
            Optional.ofNullable(location.getCountry()).map(item -> (Country)countryCodes.get(item.getCode())).ifPresent(item -> location.setCountry((DictionaryReference)item.toReference()));
            ++count;
        }
        Exporters.newGeoLocationsXlsxExporter(Paths.get("c:/geolocations2/locations-invalidated.xlsx", new String[0])).export(invalidatedLocations, countries, locations, Arrays.asList(Fields.GeoLocationField.values()));
        Exporters.newGeoLocationsXlsxExporter(Paths.get("c:/geolocations2/locations-output.xlsx", new String[0])).export(locations, countries, locations, Arrays.asList(Fields.GeoLocationField.values()));
        Exporters.newCountriesXmlExporter(Paths.get("c:/geolocations2/countries-output.xml", new String[0])).export(countries, null);
        Exporters.newGeoLocationsXmlExporter(Paths.get("c:/geolocations2/locations-output.xml", new String[0])).export(locations, null, null, null);
    }

    @Ignore
    @Test
    public void convertIataLocations() throws Exception {
        List<String> lines = Files.readAllLines(Paths.get("c:/geolocations2/iata/iata.csv", new String[0]), Charset.forName("cp1251"));
        System.out.println("before -> " + lines.size());
        lines = lines.stream().distinct().filter(item -> {
            String[] entries = item.split(";");
            if (entries.length != 4) {
                throw new IllegalStateException("corrupted record -> " + item);
            }
            return !entries[1].equals(entries[3]) || !entries[2].equals("Metropolitan Area");
        }).collect(Collectors.toList());
        System.out.println("after filter -> " + lines.size());
        ArrayList duplicates = new ArrayList();
        lines.stream().collect(Collectors.groupingBy(item -> {
            String[] entries = item.split(";");
            if (entries.length != 4) {
                throw new IllegalStateException("corrupted record -> " + item);
            }
            return entries[3];
        })).entrySet().stream().filter(item -> ((List)item.getValue()).size() > 1).map(item -> (List)item.getValue()).forEach(items -> {
            duplicates.addAll(items.subList(1, items.size()));
            ArrayList<String> texts = new ArrayList<String>();
            for (String item : items) {
                String[] entries = item.split(";");
                if (entries.length != 4) {
                    throw new IllegalStateException("corrupted record -> " + item);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("iata code -> " + entries[3]);
                stringBuilder.append("\n");
                stringBuilder.append("name -> " + entries[2]);
                stringBuilder.append("\n");
                stringBuilder.append("city iata code -> " + entries[1]);
                stringBuilder.append("\n");
                stringBuilder.append("city name -> " + entries[0]);
                texts.add(stringBuilder.toString());
            }
            System.out.println(DebugUtil.decorate(texts, null, null, (boolean)true));
        });
        System.out.println("duplicates -> " + duplicates.size());
        lines = lines.stream().filter(item -> !duplicates.contains(item)).collect(Collectors.toList());
        System.out.println("after duplicates -> " + lines.size());
        long citiesCount = lines.stream().map(item -> {
            String[] entries = item.split(";");
            if (entries.length != 4) {
                throw new IllegalStateException("corrupted record -> " + item);
            }
            return entries[1];
        }).distinct().count();
        System.out.println("cities count -> " + citiesCount);
        long airportsCount = lines.stream().map(item -> {
            String[] entries = item.split(";");
            if (entries.length != 4) {
                throw new IllegalStateException("corrupted record -> " + item);
            }
            return entries[3];
        }).distinct().count();
        System.out.println("airports count -> " + airportsCount);
        lines.add(0, String.format("%s;%s;%s;%s", new Object[]{Fields.GeoLocationField.CITY_NAME_EN, Fields.GeoLocationField.CITY_CODE_IATA, Fields.GeoLocationField.NAME_EN, Fields.GeoLocationField.CODE_IATA}));
        Files.write(Paths.get("c:/geolocations2/iata/iata-converted.csv", new String[0]), lines, Charset.forName("cp1251"), new OpenOption[0]);
    }
}

