/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dicts.merge;

import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

class MergeHelper {
    MergeHelper() {
    }

    static void merge(Country country, Country candidateCountry) {
        for (CodeSystem codeSystem : CodeSystem.values()) {
            String code;
            if (!TextUtil.isBlank((String)((String)country.getCodeVariants().get(codeSystem.name()))) || TextUtil.isBlank((String)(code = (String)candidateCountry.getCodeVariants().get(codeSystem.name())))) continue;
            country.getCodeVariants().put(codeSystem.name(), code.trim());
        }
        for (Locale locale : LocaleUtil.getAvailableLocales()) {
            String candidateLocationTranslation;
            String locationTranslation = country.getTranslations().entrySet().stream().filter(item -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)item.getKey())), (Object)locale)).map(item -> (String)item.getValue()).findFirst().orElse(null);
            if (!TextUtil.isBlank((String)locationTranslation) || TextUtil.isBlank((String)(candidateLocationTranslation = (String)candidateCountry.getTranslations().entrySet().stream().filter(item -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)item.getKey())), (Object)locale)).map(item -> (String)item.getValue()).findFirst().orElse(null)))) continue;
            country.getTranslations().put(locale, candidateLocationTranslation.trim());
        }
    }

    static void merge(Aircraft aircraft, Aircraft candidateAircraft) {
        for (CodeSystem codeSystem : CodeSystem.values()) {
            String code;
            if (!TextUtil.isBlank((String)((String)aircraft.getCodeVariants().get(codeSystem.name()))) || TextUtil.isBlank((String)(code = (String)candidateAircraft.getCodeVariants().get(codeSystem.name())))) continue;
            aircraft.getCodeVariants().put(codeSystem.name(), code.trim());
        }
        for (Locale locale : LocaleUtil.getAvailableLocales()) {
            String candidateLocationTranslation;
            String locationTranslation = aircraft.getTranslations().entrySet().stream().filter(item -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)item.getKey())), (Object)locale)).map(item -> (String)item.getValue()).findFirst().orElse(null);
            if (!TextUtil.isBlank((String)locationTranslation) || TextUtil.isBlank((String)(candidateLocationTranslation = (String)candidateAircraft.getTranslations().entrySet().stream().filter(item -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)item.getKey())), (Object)locale)).map(item -> (String)item.getValue()).findFirst().orElse(null)))) continue;
            aircraft.getTranslations().put(locale, candidateLocationTranslation.trim());
        }
    }

    static Country match(Country candidateCountry, Collection<Country> countries) {
        for (Country country : countries) {
            boolean found = false;
            if (!found) {
                for (CodeSystem codeSystem : CodeSystem.values()) {
                    if (TextUtil.isBlank((String)((String)country.getCodeVariants().get(codeSystem.name()))) || TextUtil.isBlank((String)((String)candidateCountry.getCodeVariants().get(codeSystem.name()))) || !TextUtil.isSame((String)((String)country.getCodeVariants().get(codeSystem.name())), (String)((String)candidateCountry.getCodeVariants().get(codeSystem.name())), (boolean)true, (boolean)true)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            return country;
        }
        return null;
    }

    static Aircraft match(Aircraft candidateAircraft, Collection<Aircraft> aircrafts) {
        for (Aircraft aircraft : aircrafts) {
            if (!aircraft.getCode().equals(candidateAircraft.getCode())) continue;
            return aircraft;
        }
        return null;
    }

    static void merge(GeoLocation location, GeoLocation candidateLocation) {
        for (CodeSystem codeSystem : CodeSystem.values()) {
            String code;
            if (!TextUtil.isBlank((String)((String)location.getCodeVariants().get(codeSystem.name()))) || TextUtil.isBlank((String)(code = (String)candidateLocation.getCodeVariants().get(codeSystem.name())))) continue;
            location.getCodeVariants().put(codeSystem.name(), code.trim());
        }
        for (Locale locale : LocaleUtil.getAvailableLocales()) {
            String candidateLocationTranslation;
            String locationTranslation = location.getTranslations().entrySet().stream().filter(item -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)item.getKey())), (Object)locale)).map(item -> (String)item.getValue()).findFirst().orElse(null);
            if (!TextUtil.isBlank((String)locationTranslation) || TextUtil.isBlank((String)(candidateLocationTranslation = (String)candidateLocation.getTranslations().entrySet().stream().filter(item -> MiscUtil.equals((Object)LocaleUtil.createNormalizedLocale((Locale)((Locale)item.getKey())), (Object)locale)).map(item -> (String)item.getValue()).findFirst().orElse(null)))) continue;
            location.getTranslations().put(locale, candidateLocationTranslation.trim());
        }
    }

    static GeoLocation match(GeoLocation candidateLocation, Collection<GeoLocation> locations) {
        for (GeoLocation location : locations) {
            boolean found = false;
            if (!found && location.getType() != candidateLocation.getType()) continue;
            if (!found) {
                for (CodeSystem codeSystem : CodeSystem.values()) {
                    if (TextUtil.isBlank((String)((String)location.getCodeVariants().get(codeSystem.name()))) || TextUtil.isBlank((String)((String)candidateLocation.getCodeVariants().get(codeSystem.name()))) || !TextUtil.isSame((String)((String)location.getCodeVariants().get(codeSystem.name())), (String)((String)candidateLocation.getCodeVariants().get(codeSystem.name())), (boolean)true, (boolean)true)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            return location;
        }
        return null;
    }

    static String toString(String codeSystem, String code) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("codeSystem -> " + codeSystem);
        stringBuilder.append("\n");
        stringBuilder.append("code -> " + code);
        return stringBuilder.toString();
    }

    static String toString(Locale locale, String name) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("locale -> " + locale);
        stringBuilder.append("\n");
        stringBuilder.append("name -> " + name);
        return stringBuilder.toString();
    }

    static String toString(Country country) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("code -> " + country.getCode());
        stringBuilder.append("\n");
        stringBuilder.append(DebugUtil.decorate((Iterable)country.getCodeVariants().entrySet().stream().map(value -> MergeHelper.toString((String)value.getKey(), (String)value.getValue())).collect(Collectors.toList()), null, (String)"codeVariants", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((Iterable)country.getTranslations().entrySet().stream().map(value -> MergeHelper.toString((Locale)value.getKey(), (String)value.getValue())).collect(Collectors.toList()), null, (String)"translations", (boolean)true));
        return stringBuilder.toString();
    }

    static String toString(GeoLocation location) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("code -> " + location.getCode());
        stringBuilder.append("\n");
        stringBuilder.append("country -> " + location.getCountry());
        stringBuilder.append("\n");
        stringBuilder.append(DebugUtil.decorate((Iterable)location.getCodeVariants().entrySet().stream().map(value -> MergeHelper.toString((String)value.getKey(), (String)value.getValue())).collect(Collectors.toList()), null, (String)"codeVariants", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((Iterable)location.getTranslations().entrySet().stream().map(value -> MergeHelper.toString((Locale)value.getKey(), (String)value.getValue())).collect(Collectors.toList()), null, (String)"translations", (boolean)true));
        return stringBuilder.toString();
    }
}

