/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.dicts.merge;

import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.model.dicts.merge.Fields;
import com.gridnine.xtrip.server.model.dicts.merge.Indicators;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class Parsers {
    Parsers() {
    }

    static GeoRegionsParser newGeoRegionsXmlParser(Path path) {
        return new GeoRegionsXmlParser(path);
    }

    static CountriesParser newCountriesXmlParser(Path path) {
        return new CountriesXmlParser(path);
    }

    static CountriesParser newCountriesCsvParser(Path path, String separator, Charset charset) {
        return new CountriesCsvParser(path, separator, charset);
    }

    static GeoLocationsParser newGeoLocationsXmlParser(Path path) throws Exception {
        return new GeoLocationsXmlParser(path);
    }

    static GeoLocationsParser newGeoLocationsCsvParser(Path path, Supplier<LocationType> typer, String separator, Charset charset) {
        return new GeoLocationsCsvParser(path, typer, separator, charset);
    }

    static AircraftParser newAircraftCsvParser(Path path, String separator, Charset charset) {
        return new AircraftCsvParser(path, separator, charset);
    }

    static AircraftParser newAircraftXmlParser(Path path) {
        return new AircraftXmlParser(path);
    }

    private static class AircraftXmlParser
    implements AircraftParser {
        private final Path path;

        AircraftXmlParser(Path path) {
            this.path = path;
        }

        @Override
        public AircraftParserResult parse() throws Exception {
            ArrayList<Aircraft> aircrafts = new ArrayList<Aircraft>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.path.toFile());
            NodeList objectList = document.getElementsByTagName("object");
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("parsing %s", this.path.toString()), objectList.getLength());
            for (int i = 0; i < objectList.getLength(); ++i) {
                indicator.update(i);
                Element objectElement = (Element)objectList.item(i);
                String type = XmlUtil.getValue((Element)objectElement, (String)"@class");
                if (!TextUtil.isSame((String)type, (String)Aircraft.class.getName())) continue;
                Aircraft aircraft = new Aircraft();
                aircraft.fromXML(objectElement);
                aircrafts.add(aircraft);
            }
            AircraftParserResult result = new AircraftParserResult();
            result.getAircrafts().clear();
            result.getAircrafts().addAll(aircrafts);
            return result;
        }
    }

    private static class AircraftCsvParser
    implements AircraftParser {
        private final Path path;
        private final String separator;
        private final Charset charset;

        AircraftCsvParser(Path path, String separator, Charset charset) {
            this.path = path;
            this.separator = separator;
            this.charset = charset;
        }

        private String getValue(Fields.AircraftField field, Map<Fields.AircraftField, Integer> codes, String[] entries) {
            return codes.get((Object)field) != null ? entries[codes.get((Object)field)].trim() : null;
        }

        @Override
        public AircraftParserResult parse() throws Exception {
            LinkedHashMap<String, Aircraft> aircrafts = new LinkedHashMap<String, Aircraft>();
            List<String> lines = Files.readAllLines(this.path, this.charset);
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("parsing %s", this.path.toString()), lines.size());
            int count = 0;
            HashMap<Fields.AircraftField, Integer> codes = new HashMap<Fields.AircraftField, Integer>();
            for (int i = 0; i < lines.size(); ++i) {
                indicator.update(i);
                String line = lines.get(i);
                String[] entries = line.split(this.separator, -1);
                if (i == 0) {
                    count = entries.length;
                    int index = 0;
                    for (String entry : entries) {
                        Fields.AircraftField field = null;
                        try {
                            field = Fields.AircraftField.valueOf(entry.trim().toUpperCase());
                            if (field != null && !codes.containsKey((Object)field)) {
                                codes.put(field, index);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++index;
                    }
                    continue;
                }
                if (entries.length != count) {
                    throw new IllegalStateException("corrupted record -> " + line);
                }
                String shtCrt = this.getValue(Fields.AircraftField.SHT_CODE, codes, entries);
                String codeIcaoR = this.getValue(Fields.AircraftField.CODE_ICAO_R, codes, entries);
                String codeIcao = this.getValue(Fields.AircraftField.CODE_ICAO, codes, entries);
                String codeIata = this.getValue(Fields.AircraftField.CODE_IATA, codes, entries);
                String name = this.getValue(Fields.AircraftField.NAME, codes, entries);
                String nameE = this.getValue(Fields.AircraftField.NAME_E, codes, entries);
                String shtmCode = this.getValue(Fields.AircraftField.SHTM_CODE, codes, entries);
                String codeIataMod = this.getValue(Fields.AircraftField.CODE_IATA_MOD, codes, entries);
                String code = null;
                if (!TextUtil.isBlank((String)shtmCode)) {
                    code = shtmCode;
                } else if (!TextUtil.isBlank((String)codeIataMod)) {
                    code = codeIataMod;
                } else if (!TextUtil.isBlank((String)shtCrt)) {
                    code = shtCrt;
                } else if (!TextUtil.isBlank((String)codeIata)) {
                    code = codeIata;
                }
                if (TextUtil.isBlank((String)code)) {
                    throw new IllegalStateException("no code defined -> " + line);
                }
                Aircraft aircraft = aircrafts.get(code) != null ? (Aircraft)aircrafts.get(code) : new Aircraft();
                aircraft.setCode(code);
                if (!TextUtil.isBlank((String)codeIataMod)) {
                    aircraft.getCodeVariants().put(CodeSystem.IATA.name(), codeIataMod);
                } else if (!TextUtil.isBlank((String)codeIata)) {
                    aircraft.getCodeVariants().put(CodeSystem.IATA.name(), codeIata);
                }
                if (!TextUtil.isBlank((String)shtmCode)) {
                    aircraft.getCodeVariants().put(CodeSystem.CRT.name(), shtmCode);
                } else if (!TextUtil.isBlank((String)shtCrt)) {
                    aircraft.getCodeVariants().put(CodeSystem.CRT.name(), shtCrt);
                }
                if (!TextUtil.isBlank((String)nameE)) {
                    aircraft.getTranslations().put(LocaleUtil.LOCALE_EN, nameE);
                }
                if (!TextUtil.isBlank((String)name)) {
                    aircraft.getTranslations().put(LocaleUtil.LOCALE_RU, name);
                }
                aircrafts.put(aircraft.getCode(), aircraft);
            }
            AircraftParserResult result = new AircraftParserResult();
            result.getAircrafts().addAll(aircrafts.values());
            return result;
        }
    }

    static class AircraftParserResult {
        private Collection<Aircraft> aircrafts = new ArrayList<Aircraft>();

        AircraftParserResult() {
        }

        public Collection<Aircraft> getAircrafts() {
            return this.aircrafts;
        }

        public void setAircrafts(Collection<Aircraft> aircrafts) {
            this.aircrafts = aircrafts;
        }
    }

    static interface AircraftParser {
        public AircraftParserResult parse() throws Exception;
    }

    private static class GeoLocationsCsvParser
    implements GeoLocationsParser {
        private final Path path;
        private final Supplier<LocationType> typer;
        private final String separator;
        private final Charset charset;

        GeoLocationsCsvParser(Path path, Supplier<LocationType> typer, String separator, Charset charset) {
            this.path = path;
            this.typer = typer;
            this.separator = separator;
            this.charset = charset;
        }

        private String getValue(Fields.GeoLocationField field, Map<Fields.GeoLocationField, Integer> codes, String[] entries) {
            return codes.get((Object)field) != null ? entries[codes.get((Object)field)].trim() : null;
        }

        private String getCode(String code, LocationType type) {
            if (!TextUtil.isBlank((String)code)) {
                if (type == LocationType.AIRPORT) {
                    return String.format("airport %s", code);
                }
                if (type == LocationType.CITY) {
                    return code;
                }
            }
            return null;
        }

        @Override
        public GeoLocationsParserResult parse() throws Exception {
            LinkedHashMap<String, Country> countries = new LinkedHashMap<String, Country>();
            LinkedHashMap<String, GeoLocation> locations = new LinkedHashMap<String, GeoLocation>();
            int count = 0;
            HashMap<Fields.GeoLocationField, Integer> codes = new HashMap<Fields.GeoLocationField, Integer>();
            List<String> lines = Files.readAllLines(this.path, this.charset);
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("parsing %s", this.path.toString()), lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                LocationType type;
                indicator.update(i);
                String line = lines.get(i);
                String[] entries = line.split(this.separator, -1);
                if (i == 0) {
                    count = entries.length;
                    int index = 0;
                    for (String entry : entries) {
                        Fields.GeoLocationField field = null;
                        try {
                            field = Fields.GeoLocationField.valueOf(entry.trim());
                            if (!codes.containsKey((Object)field)) {
                                codes.put(field, index);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++index;
                    }
                    continue;
                }
                if (entries.length != count) {
                    throw new IllegalStateException("corrupted record -> " + line);
                }
                LocationType locationType = codes.get((Object)Fields.GeoLocationField.TYPE) != null ? LocationType.valueOf((String)entries[(Integer)codes.get((Object)Fields.GeoLocationField.TYPE)]) : (type = this.typer != null ? this.typer.get() : null);
                if (type == null) {
                    throw new IllegalStateException("no type defined -> " + line);
                }
                String codeIata = this.getValue(Fields.GeoLocationField.CODE_IATA, codes, entries);
                String codeCrt = this.getValue(Fields.GeoLocationField.CODE_CRT, codes, entries);
                String nameEn = this.getValue(Fields.GeoLocationField.NAME_EN, codes, entries);
                String nameRu = this.getValue(Fields.GeoLocationField.NAME_RU, codes, entries);
                String cityCodeIata = this.getValue(Fields.GeoLocationField.CITY_CODE_IATA, codes, entries);
                String cityCodeCrt = this.getValue(Fields.GeoLocationField.CITY_CODE_CRT, codes, entries);
                String cityNameEn = this.getValue(Fields.GeoLocationField.CITY_NAME_EN, codes, entries);
                String cityNameRu = this.getValue(Fields.GeoLocationField.CITY_NAME_RU, codes, entries);
                String countryCodeIata = this.getValue(Fields.GeoLocationField.COUNTRY_CODE_IATA, codes, entries);
                String countryCodeCrt = this.getValue(Fields.GeoLocationField.COUNTRY_CODE_CRT, codes, entries);
                String countryCodeIsoAlpha2 = this.getValue(Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_2, codes, entries);
                String countryCodeIsoAlpha3 = this.getValue(Fields.GeoLocationField.COUNTRY_CODE_ISO_ALPHA_3, codes, entries);
                String code = this.getCode(!TextUtil.isBlank((String)codeIata) ? codeIata : codeCrt, type);
                if (TextUtil.isBlank((String)code)) {
                    throw new IllegalStateException("no code defined -> " + line);
                }
                GeoLocation location = locations.get(code) != null ? (GeoLocation)locations.get(code) : new GeoLocation();
                location.setType(type);
                location.setCode(code);
                if (!TextUtil.isBlank((String)codeIata)) {
                    location.getCodeVariants().put(CodeSystem.IATA.name(), codeIata);
                }
                if (!TextUtil.isBlank((String)codeCrt)) {
                    location.getCodeVariants().put(CodeSystem.CRT.name(), codeCrt);
                }
                if (!TextUtil.isBlank((String)nameEn)) {
                    location.getTranslations().put(LocaleUtil.LOCALE_EN, nameEn);
                }
                if (!TextUtil.isBlank((String)nameRu)) {
                    location.getTranslations().put(LocaleUtil.LOCALE_RU, nameRu);
                }
                if (!(type != LocationType.AIRPORT || TextUtil.isBlank((String)cityCodeIata) && TextUtil.isBlank((String)cityCodeCrt))) {
                    LocationType cityType = LocationType.CITY;
                    String cityCode = this.getCode(!TextUtil.isBlank((String)cityCodeIata) ? cityCodeIata : cityCodeCrt, cityType);
                    if (TextUtil.isBlank((String)cityCode)) {
                        throw new IllegalStateException("no city code defined -> " + line);
                    }
                    GeoLocation city = (GeoLocation)locations.get(cityCode);
                    if (city == null) {
                        city = new GeoLocation();
                        city.setType(cityType);
                        city.setCode(cityCode);
                        if (!TextUtil.isBlank((String)cityCodeIata)) {
                            city.getCodeVariants().put(CodeSystem.IATA.name(), cityCodeIata);
                        }
                        if (!TextUtil.isBlank((String)cityCodeCrt)) {
                            city.getCodeVariants().put(CodeSystem.CRT.name(), cityCodeCrt);
                        }
                        if (!TextUtil.isBlank((String)cityNameEn)) {
                            city.getTranslations().put(LocaleUtil.LOCALE_EN, cityNameEn);
                        }
                        if (!TextUtil.isBlank((String)cityNameRu)) {
                            city.getTranslations().put(LocaleUtil.LOCALE_RU, cityNameRu);
                        }
                        locations.put(city.getCode(), city);
                    }
                    location.setParent((DictionaryReference)city.toReference());
                }
                if (!(TextUtil.isBlank((String)countryCodeIata) && TextUtil.isBlank((String)countryCodeCrt) && TextUtil.isBlank((String)countryCodeIsoAlpha2) && TextUtil.isBlank((String)countryCodeIsoAlpha3))) {
                    String countryCode;
                    String string = !TextUtil.isBlank((String)countryCodeIata) ? countryCodeIata : (!TextUtil.isBlank((String)countryCodeCrt) ? countryCodeCrt : (countryCode = !TextUtil.isBlank((String)countryCodeIsoAlpha2) ? countryCodeIsoAlpha2 : countryCodeIsoAlpha3));
                    if (TextUtil.isBlank((String)countryCode)) {
                        throw new IllegalStateException("no country code defined -> " + line);
                    }
                    Country country = (Country)countries.get(countryCode);
                    if (country == null) {
                        country = new Country();
                        country.setCode(countryCode);
                        if (!TextUtil.isBlank((String)countryCodeIata)) {
                            country.getCodeVariants().put(CodeSystem.IATA.name(), countryCodeIata);
                        }
                        if (!TextUtil.isBlank((String)countryCodeCrt)) {
                            country.getCodeVariants().put(CodeSystem.CRT.name(), countryCodeCrt);
                        }
                        if (!TextUtil.isBlank((String)countryCodeIsoAlpha2)) {
                            country.getCodeVariants().put(CodeSystem.ISO.name(), countryCodeIsoAlpha2);
                        }
                        if (!TextUtil.isBlank((String)countryCodeIsoAlpha3)) {
                            country.getCodeVariants().put(CodeSystem.ISO_ALPHA3.name(), countryCodeIsoAlpha3);
                        }
                        countries.put(country.getCode(), country);
                    }
                    location.setCountry((DictionaryReference)country.toReference());
                    if (type == LocationType.AIRPORT) {
                        ((GeoLocation)locations.get(location.getParent().getCode())).setCountry((DictionaryReference)country.toReference());
                    }
                }
                locations.put(location.getCode(), location);
            }
            GeoLocationsParserResult result = new GeoLocationsParserResult();
            result.getCountries().clear();
            result.getCountries().addAll(countries.values());
            result.getLocations().clear();
            result.getLocations().addAll(locations.values());
            return result;
        }
    }

    private static class GeoLocationsXmlParser
    implements GeoLocationsParser {
        private final Path path;

        GeoLocationsXmlParser(Path path) {
            this.path = path;
        }

        @Override
        public GeoLocationsParserResult parse() throws Exception {
            ArrayList<GeoLocation> locations = new ArrayList<GeoLocation>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.path.toFile());
            NodeList objectList = document.getElementsByTagName("object");
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("parsing %s", this.path.toString()), objectList.getLength());
            for (int i = 0; i < objectList.getLength(); ++i) {
                indicator.update(i);
                Element objectElement = (Element)objectList.item(i);
                String type = XmlUtil.getValue((Element)objectElement, (String)"@class");
                if (!TextUtil.isSame((String)type, (String)GeoLocation.class.getName())) continue;
                GeoLocation location = new GeoLocation();
                location.fromXML(objectElement);
                locations.add(location);
            }
            GeoLocationsParserResult result = new GeoLocationsParserResult();
            result.getLocations().clear();
            result.getLocations().addAll(locations);
            return result;
        }
    }

    static interface GeoLocationsParser {
        public GeoLocationsParserResult parse() throws Exception;
    }

    static class GeoLocationsParserResult {
        private final Collection<Country> countries = new ArrayList<Country>();
        private final Collection<GeoLocation> locations = new ArrayList<GeoLocation>();

        GeoLocationsParserResult() {
        }

        public Collection<Country> getCountries() {
            return this.countries;
        }

        public Collection<GeoLocation> getLocations() {
            return this.locations;
        }
    }

    private static class CountriesCsvParser
    implements CountriesParser {
        private final Path path;
        private final String separator;
        private final Charset charset;

        CountriesCsvParser(Path path, String separator, Charset charset) {
            this.path = path;
            this.separator = separator;
            this.charset = charset;
        }

        private String getValue(Fields.CountryField field, Map<Fields.CountryField, Integer> codes, String[] entries) {
            return codes.get((Object)field) != null ? entries[codes.get((Object)field)].trim() : null;
        }

        @Override
        public CountriesParserResult parse() throws Exception {
            LinkedHashMap<String, Country> countries = new LinkedHashMap<String, Country>();
            int count = 0;
            HashMap<Fields.CountryField, Integer> codes = new HashMap<Fields.CountryField, Integer>();
            List<String> lines = Files.readAllLines(this.path, this.charset);
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("parsing %s", this.path.toString()), lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                String code;
                indicator.update(i);
                String line = lines.get(i);
                String[] entries = line.split(this.separator, -1);
                if (i == 0) {
                    count = entries.length;
                    int index = 0;
                    for (String entry : entries) {
                        Fields.CountryField field = null;
                        try {
                            field = Fields.CountryField.valueOf(entry.trim());
                            if (!codes.containsKey((Object)field)) {
                                codes.put(field, index);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++index;
                    }
                    continue;
                }
                if (entries.length != count) {
                    throw new IllegalStateException("corrupted record -> " + line);
                }
                String codeIata = this.getValue(Fields.CountryField.CODE_IATA, codes, entries);
                String codeCrt = this.getValue(Fields.CountryField.CODE_CRT, codes, entries);
                String codeIsoAlpha2 = this.getValue(Fields.CountryField.CODE_ISO_ALPHA_2, codes, entries);
                String codeIsoAlpha3 = this.getValue(Fields.CountryField.CODE_ISO_ALPHA_3, codes, entries);
                String nameEn = this.getValue(Fields.CountryField.NAME_EN, codes, entries);
                String nameRu = this.getValue(Fields.CountryField.NAME_RU, codes, entries);
                String string = !TextUtil.isBlank((String)codeIata) ? codeIata : (!TextUtil.isBlank((String)codeCrt) ? codeCrt : (code = !TextUtil.isBlank((String)codeIsoAlpha2) ? codeIsoAlpha2 : codeIsoAlpha3));
                if (TextUtil.isBlank((String)code)) {
                    throw new IllegalStateException("no code defined -> " + line);
                }
                Country country = countries.get(code) != null ? (Country)countries.get(code) : new Country();
                country.setCode(code);
                if (!TextUtil.isBlank((String)codeIata)) {
                    country.getCodeVariants().put(CodeSystem.IATA.name(), codeIata);
                }
                if (!TextUtil.isBlank((String)codeCrt)) {
                    country.getCodeVariants().put(CodeSystem.CRT.name(), codeCrt);
                }
                if (!TextUtil.isBlank((String)codeIsoAlpha2)) {
                    country.getCodeVariants().put(CodeSystem.ISO.name(), codeIsoAlpha2);
                }
                if (!TextUtil.isBlank((String)codeIsoAlpha3)) {
                    country.getCodeVariants().put(CodeSystem.ISO_ALPHA3.name(), codeIsoAlpha3);
                }
                if (!TextUtil.isBlank((String)nameEn)) {
                    country.getTranslations().put(LocaleUtil.LOCALE_EN, nameEn);
                }
                if (!TextUtil.isBlank((String)nameRu)) {
                    country.getTranslations().put(LocaleUtil.LOCALE_RU, nameRu);
                }
                countries.put(country.getCode(), country);
            }
            CountriesParserResult result = new CountriesParserResult();
            result.getCountries().clear();
            result.getCountries().addAll(countries.values());
            return result;
        }
    }

    private static class CountriesXmlParser
    implements CountriesParser {
        private final Path path;

        CountriesXmlParser(Path path) {
            this.path = path;
        }

        @Override
        public CountriesParserResult parse() throws Exception {
            ArrayList<Country> countries = new ArrayList<Country>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.path.toFile());
            NodeList objectList = document.getElementsByTagName("object");
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("parsing %s", this.path.toString()), objectList.getLength());
            for (int i = 0; i < objectList.getLength(); ++i) {
                Element objectElement = (Element)objectList.item(i);
                String type = XmlUtil.getValue((Element)objectElement, (String)"@class");
                if (!TextUtil.isSame((String)type, (String)Country.class.getName())) continue;
                indicator.update(i);
                Country country = new Country();
                country.fromXML(objectElement);
                countries.add(country);
            }
            CountriesParserResult result = new CountriesParserResult();
            result.getCountries().clear();
            result.getCountries().addAll(countries);
            return result;
        }
    }

    static interface CountriesParser {
        public CountriesParserResult parse() throws Exception;
    }

    static class CountriesParserResult {
        private final Collection<Country> countries = new ArrayList<Country>();

        CountriesParserResult() {
        }

        public Collection<Country> getCountries() {
            return this.countries;
        }
    }

    private static class GeoRegionsXmlParser
    implements GeoRegionsParser {
        private final Path path;

        GeoRegionsXmlParser(Path path) {
            this.path = path;
        }

        @Override
        public GeoRegionsParserResult parse() throws Exception {
            ArrayList<GeoRegion> regions = new ArrayList<GeoRegion>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.path.toFile());
            NodeList objectList = document.getElementsByTagName("object");
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("parsing %s", this.path.toString()), objectList.getLength());
            for (int i = 0; i < objectList.getLength(); ++i) {
                Element objectElement = (Element)objectList.item(i);
                String type = XmlUtil.getValue((Element)objectElement, (String)"@class");
                if (!TextUtil.isSame((String)type, (String)GeoRegion.class.getName())) continue;
                indicator.update(i);
                GeoRegion region = new GeoRegion();
                region.fromXML(objectElement);
                regions.add(region);
            }
            GeoRegionsParserResult result = new GeoRegionsParserResult();
            result.getRegions().clear();
            result.getRegions().addAll(regions);
            return result;
        }
    }

    static interface GeoRegionsParser {
        public GeoRegionsParserResult parse() throws Exception;
    }

    static class GeoRegionsParserResult {
        private final Collection<GeoRegion> regions = new ArrayList<GeoRegion>();

        GeoRegionsParserResult() {
        }

        public Collection<GeoRegion> getRegions() {
            return this.regions;
        }
    }
}

