/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.export.BaseCommonExportSettings;
import com.gridnine.xtrip.common.model.export.BaseExportSettingsWithCommonSettings;
import com.gridnine.xtrip.common.model.export.DictionaryCompressedData;
import com.gridnine.xtrip.common.model.export.EntityCompressedData;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.model.export.RootEntityExportHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExportSettingsWithCommonSettingsRootEntityExportHandler<E extends BaseEntity, S extends BaseExportSettingsWithCommonSettings, C extends BaseCommonExportSettings>
implements RootEntityExportHandler<E, S> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean accept(E entity, S settings) throws Exception {
        EntityContainer commonSettingsCtr = EntityStorage.get().resolve(settings.getCommonSettings());
        if (commonSettingsCtr == null) {
            this.log.warn("unable to load common export settings for " + settings);
            return false;
        }
        if (!commonSettingsCtr.getEntityType().equals(this.getCommonSettingsClass())) {
            this.log.warn(String.format("wrong common settings class %s for settings %s ", commonSettingsCtr.getEntityType(), settings));
            return false;
        }
        return this.accept(entity, settings, (BaseCommonExportSettings)commonSettingsCtr.getEntity());
    }

    @Override
    public byte[] export(EntityCompressedData object, EntityCompressedData previousVersion, List<EntityCompressedData> referencedEntities, List<DictionaryCompressedData> referencedDictionaries, EntityContainer<S> settings, List<Message> messages) throws Exception {
        EntityContainer commonExportSettings = EntityStorage.get().resolve(((BaseExportSettingsWithCommonSettings)settings.getEntity()).getCommonSettings());
        if (commonExportSettings == null) {
            if (messages != null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseExportSettingsWithCommonSettingsRootEntityExportHandler_errorHandlingInExportSettings, (Object[])new Object[0]));
            }
            return null;
        }
        return this.export(object, previousVersion, referencedEntities, referencedDictionaries, (BaseExportSettingsWithCommonSettings)settings.getEntity(), (BaseCommonExportSettings)commonExportSettings.getEntity(), messages);
    }

    @Override
    public byte[] createContent(EntityContainer<E> objectCtr, EntityContainer<E> oldObjectCtr, boolean deleted, EntityContainer<S> settings, List<Message> messages, EntityStorageContext storageContext) throws Exception {
        EntityContainer commonExportSettings = EntityStorage.get().resolve(((BaseExportSettingsWithCommonSettings)settings.getEntity()).getCommonSettings());
        if (commonExportSettings == null) {
            if (messages != null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseExportSettingsWithCommonSettingsRootEntityExportHandler_errorHandlingInExportSettings, (Object[])new Object[0]));
            }
            return null;
        }
        return this.export(objectCtr, (BaseExportSettingsWithCommonSettings)settings.getEntity(), (BaseCommonExportSettings)commonExportSettings.getEntity(), messages);
    }

    protected abstract byte[] export(EntityContainer<E> var1, S var2, C var3, List<Message> var4) throws Exception;

    protected abstract boolean accept(E var1, S var2, C var3);

    public abstract Class<C> getCommonSettingsClass();

    @Deprecated
    protected abstract byte[] export(EntityCompressedData var1, EntityCompressedData var2, List<EntityCompressedData> var3, List<DictionaryCompressedData> var4, S var5, C var6, List<Message> var7) throws Exception;
}

