/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.FileCommonConnectionSettings;
import com.gridnine.xtrip.common.model.export.FileConnectionSettings;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.export.ConnectionHandler;
import com.gridnine.xtrip.server.model.export.ExportHandler;
import com.gridnine.xtrip.server.model.export.RootEntityExportHandler;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FilenameUtils;

public class FileConnectionHandler
implements ConnectionHandler<FileConnectionSettings, FileCommonConnectionSettings> {
    private static final Random stamp = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sendData(byte[] request, FileConnectionSettings info, FileCommonConnectionSettings commonSettings, ExportHandler<? extends BaseExportSettings> exportHandler, List<Message> messages, EntityContainer<ExportDocument> document) throws Exception {
        try {
            String recordName = FilenameUtils.getName((String)((ExportDocument)document.getEntity()).getFileName());
            String originalName = null;
            if (exportHandler instanceof RootEntityExportHandler) {
                originalName = ((RootEntityExportHandler)exportHandler).getOriginalName(document);
            }
            if (originalName != null) {
                recordName = originalName;
            } else if (TextUtil.isBlank((String)FilenameUtils.getExtension((String)((ExportDocument)document.getEntity()).getFileName()))) {
                String ext;
                String string = ext = TextUtil.isBlank((String)commonSettings.getFileExtension()) ? "xml" : commonSettings.getFileExtension();
                if (!TextUtil.isBlank((String)recordName)) {
                    if (TextUtil.isBlank((String)FilenameUtils.getExtension((String)recordName))) {
                        recordName = recordName + "." + ext;
                    }
                } else {
                    String prefix = TextUtil.isBlank((String)commonSettings.getFilePrefix()) ? "gridnine" : commonSettings.getFilePrefix();
                    String description = ((ExportDocument)document.getEntity()).getDescription() != null ? ((ExportDocument)document.getEntity()).getDescription().replace(" ", "_") : "";
                    prefix = prefix.replace("${description}", description);
                    if (exportHandler instanceof RootEntityExportHandler) {
                        prefix = ((RootEntityExportHandler)exportHandler).updateFileNamePrefix(prefix, document);
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(TextUtil.isBlank((String)commonSettings.getDateFormatterPattern()) ? "yyyy-MM-dd-HH-mm-ss-SSS" : commonSettings.getDateFormatterPattern());
                    String postfix = commonSettings.isStamp() ? "-" + TextUtil.fillLeft((String)Long.toString(stamp.nextInt(10000)), (char)'0', (int)4) : "";
                    recordName = String.format("%s-%s%s.%s", prefix, sdf.format(new Date()), postfix, ext);
                }
            }
            File file = new File(IoUtil.url2file((URL)info.getUrl()), recordName);
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw Xeption.forEndUser((String)Messages.FileConnectionHandler_cantCreateDirectory, (Object[])new Object[]{file.getParentFile()});
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                IoUtil.copyStream((InputStream)new ByteArrayInputStream(request), (OutputStream)fos, (int)256);
            }
            this.labelIt(document, info.getUrl(), recordName, messages);
            return null;
        }
        catch (Throwable t) {
            this.labelItError(document, t, messages);
            throw t;
        }
    }

    private void labelIt(EntityContainer<ExportDocument> document, URL url, String recordName, List<Message> messages) {
        String settings;
        EntityReference relatedObject = ((ExportDocument)document.getEntity()).getObject() != null ? ((ExportDocument)document.getEntity()).getObject().getReference() : null;
        EntityContainer settingsCtr = EntityStorage.get().resolve(((ExportDocument)document.getEntity()).getExportSettings());
        String string = settings = settingsCtr != null ? ((BaseExportSettings)settingsCtr.getEntity()).getName() : "(\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e)";
        if (TextUtil.isBlank((String)settings)) {
            settings = "(\u0431\u0435\u0437 \u0438\u043c\u0435\u043d\u0438)";
        }
        String details = String.format("settings: %s,\nurl: %s,\nfile: %s", settings, url.toString(), recordName);
        SysLogHelper.audit(relatedObject, "export-file", MessageHelper.createMessage((String)Messages.ExportConnectionHandler_successfulExport, (String)details, (Object[])new Object[0]));
        messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)details, (Object[])new Object[0]));
    }

    private void labelItError(EntityContainer<ExportDocument> document, Throwable t, List<Message> messages) {
        EntityReference relatedObject = ((ExportDocument)document.getEntity()).getObject() != null ? ((ExportDocument)document.getEntity()).getObject().getReference() : null;
        String errorMessage = t instanceof Xeption && TextUtil.nonBlank((String)((Xeption)t).toMessageString()) ? ((Xeption)t).toMessageString() : t.toString();
        SysLogHelper.audit(relatedObject, "export-file", MessageHelper.createExceptonMessage((String)Messages.ExportConnectionHandler_exportFailWithMessage, (Throwable)t, (Object[])new Object[]{errorMessage}));
        messages.add(MessageHelper.createExceptonMessage((String)Messages.ExportConnectionHandler_exportFailWithMessage, (Throwable)t, (Object[])new Object[]{errorMessage}));
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.FILE;
    }

    @Override
    public Class<FileConnectionSettings> getSettingsClass() {
        return FileConnectionSettings.class;
    }

    @Override
    public Class<FileCommonConnectionSettings> getCommonSettingsClass() {
        return FileCommonConnectionSettings.class;
    }
}

