/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.FtpCommonConnectionSettings;
import com.gridnine.xtrip.common.model.export.FtpConnectionSettings;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.export.ConnectionHandler;
import com.gridnine.xtrip.server.model.export.ExportHandler;
import com.gridnine.xtrip.server.model.export.RootEntityExportHandler;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnectionHandler
implements ConnectionHandler<FtpConnectionSettings, FtpCommonConnectionSettings> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int DEFAULT_TIMEOUT = 30000;
    private static final Random stamp = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sendData(byte[] request, FtpConnectionSettings info, FtpCommonConnectionSettings commonSettings, ExportHandler<? extends BaseExportSettings> exportHandler, List<Message> messages, EntityContainer<ExportDocument> document) throws Exception {
        try {
            String recordName = FilenameUtils.getName((String)((ExportDocument)document.getEntity()).getFileName());
            String originalName = null;
            if (exportHandler instanceof RootEntityExportHandler) {
                originalName = ((RootEntityExportHandler)exportHandler).getOriginalName(document);
            }
            if (originalName != null) {
                recordName = originalName;
            } else if (TextUtil.isBlank((String)FilenameUtils.getExtension((String)((ExportDocument)document.getEntity()).getFileName()))) {
                String ext;
                String string = ext = TextUtil.isBlank((String)commonSettings.getFileExtension()) ? "xml" : commonSettings.getFileExtension();
                if (!TextUtil.isBlank((String)recordName)) {
                    if (TextUtil.isBlank((String)FilenameUtils.getExtension((String)recordName))) {
                        recordName = recordName + "." + ext;
                    }
                } else {
                    String prefix = TextUtil.isBlank((String)commonSettings.getFilePrefix()) ? "gridnine" : commonSettings.getFilePrefix();
                    String description = ((ExportDocument)document.getEntity()).getDescription() != null ? ((ExportDocument)document.getEntity()).getDescription().replace(" ", "_") : "";
                    prefix = prefix.replace("${description}", description);
                    if (exportHandler instanceof RootEntityExportHandler) {
                        prefix = ((RootEntityExportHandler)exportHandler).updateFileNamePrefix(prefix, document);
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(TextUtil.isBlank((String)commonSettings.getDateFormatterPattern()) ? "yyyy-MM-dd-HH-mm-ss-SSS" : commonSettings.getDateFormatterPattern());
                    String postfix = commonSettings.isStamp() ? "-" + TextUtil.fillLeft((String)Long.toString(stamp.nextInt(10000)), (char)'0', (int)4) : "";
                    recordName = String.format("%s-%s%s.%s", prefix, sdf.format(new Date()), postfix, ext);
                }
            }
            if (info.getUrl() == null) {
                EntityContainer exportSettings = EntityStorage.get().resolve(((ExportDocument)document.getEntity()).getExportSettings());
                throw Xeption.forEndUser((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d url \u0434\u043b\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 {0}", (Object[])new Object[]{exportSettings != null ? ((BaseExportSettings)exportSettings.getEntity()).getName() : ((ExportDocument)document.getEntity()).getExportSettings().toString()});
            }
            String host = info.getUrl().getHost();
            String path = info.getUrl().getPath();
            boolean isTlsEnabled = info.isTlsEnabled();
            boolean isPassiveModeEnabled = info.isPassiveModeEnabled();
            int port = info.getUrl().getPort();
            this.log.debug(String.format("trying to send data to %s", info.getUrl()));
            FTPSClient ftpClient = isTlsEnabled ? new FTPSClient() : new FTPClient();
            Integer commonTimeout = commonSettings.getTimeout();
            int timeout = commonTimeout != null ? commonTimeout : 30000;
            ftpClient.setConnectTimeout(timeout);
            ftpClient.setDefaultTimeout(timeout);
            ftpClient.setDataTimeout(timeout);
            CharsetEncoder ce = Charset.forName("ISO-8859-1").newEncoder();
            ftpClient.setAutodetectUTF8((MiscUtil.guarded((String)path) + recordName).chars().anyMatch(c -> !ce.canEncode((char)c)));
            if (port != -1) {
                ftpClient.connect(host, port);
            } else {
                ftpClient.connect(host);
            }
            if ("UTF-8".equals(ftpClient.getControlEncoding()) && !FTPReply.isPositiveCompletion((int)ftpClient.sendCommand("OPTS UTF8 ON"))) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"OPTS UTF8 ON", (Object[])new Object[0]));
                this.labelItError((FTPClient)ftpClient, messages);
            }
            try {
                boolean logged = false;
                if (!TextUtil.isBlank((String)info.getLogin()) && !(logged = ftpClient.login(info.getLogin(), info.getPassword()))) {
                    this.labelItError((FTPClient)ftpClient, messages);
                    EntityContainer exportSettings = EntityStorage.get().resolve(((ExportDocument)document.getEntity()).getExportSettings());
                    throw Xeption.forEndUser((String)Messages.FtpConnectionHandler_cantLogin, (Object[])new Object[]{exportSettings != null ? ((BaseExportSettings)exportSettings.getEntity()).getName() : ((ExportDocument)document.getEntity()).getExportSettings().toString()});
                }
                try {
                    ftpClient.setFileType(2);
                    if (path != null && path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if (ftpClient instanceof FTPSClient && isTlsEnabled) {
                        ftpClient.execPBSZ(0L);
                        ftpClient.execPROT("P");
                    }
                    if (isPassiveModeEnabled) {
                        ftpClient.enterLocalPassiveMode();
                    }
                    if (ftpClient.storeFile(TextUtil.isBlank((String)path) ? recordName : String.format("%s/%s", path, recordName), (InputStream)new ByteArrayInputStream(request))) {
                        this.labelIt(document, info.getUrl(), recordName, messages);
                    }
                    this.labelItError((FTPClient)ftpClient, messages);
                    throw Xeption.forEndUser((String)Messages.FtpConnectionHandler_savingFileError, (Object[])new Object[0]);
                }
                finally {
                    if (logged && !ftpClient.logout()) {
                        this.labelItError((FTPClient)ftpClient, messages);
                        throw Xeption.forEndUser((String)Messages.FtpConnectionHandler_cantLogout, (Object[])new Object[0]);
                    }
                }
            }
            finally {
                ftpClient.disconnect();
            }
            return null;
        }
        catch (Throwable t) {
            this.labelItError(document, t);
            throw t;
        }
    }

    private void labelItError(FTPClient ftpClient, List<Message> messages) {
        messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)("reply code: " + ftpClient.getReplyCode()), (Object[])new Object[0]));
        Arrays.stream(ftpClient.getReplyStrings()).forEach(s -> messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)s, (Object[])new Object[0])));
    }

    private void labelIt(EntityContainer<ExportDocument> document, URL url, String recordName, List<Message> messages) {
        String settings;
        EntityReference relatedObject = ((ExportDocument)document.getEntity()).getObject() != null ? ((ExportDocument)document.getEntity()).getObject().getReference() : null;
        EntityContainer settingsCtr = EntityStorage.get().resolve(((ExportDocument)document.getEntity()).getExportSettings());
        String string = settings = settingsCtr != null ? ((BaseExportSettings)settingsCtr.getEntity()).getName() : "(\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e)";
        if (TextUtil.isBlank((String)settings)) {
            settings = "(\u0431\u0435\u0437 \u0438\u043c\u0435\u043d\u0438)";
        }
        String details = String.format("settings: %s,\nurl: %s,\nfile: %s", settings, url.toString(), recordName);
        SysLogHelper.audit(relatedObject, "export-ftp", MessageHelper.createMessage((String)Messages.ExportConnectionHandler_successfulExport, (String)details, (Object[])new Object[0]));
        messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)details, (Object[])new Object[0]));
    }

    private void labelItError(EntityContainer<ExportDocument> document, Throwable t) {
        Throwable error = t;
        if (t instanceof SocketTimeoutException) {
            error = Xeption.forEndUser((String)"\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430", (Throwable)t, (Object[])new Object[0]);
        }
        EntityReference relatedObject = ((ExportDocument)document.getEntity()).getObject() != null ? ((ExportDocument)document.getEntity()).getObject().getReference() : null;
        String errorMessage = t instanceof Xeption && TextUtil.nonBlank((String)((Xeption)t).toMessageString()) ? ((Xeption)t).toMessageString() : t.toString();
        SysLogHelper.audit(relatedObject, "export-ftp", MessageHelper.createExceptonMessage((String)Messages.ExportConnectionHandler_exportFailWithMessage, (Throwable)error, (Object[])new Object[]{errorMessage}));
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.FTP;
    }

    @Override
    public Class<FtpConnectionSettings> getSettingsClass() {
        return FtpConnectionSettings.class;
    }

    @Override
    public Class<FtpCommonConnectionSettings> getCommonSettingsClass() {
        return FtpCommonConnectionSettings.class;
    }
}

