/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.HttpCommonConnectionSettings;
import com.gridnine.xtrip.common.model.export.HttpConnectionSettings;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.export.ConnectionHandler;
import com.gridnine.xtrip.server.model.export.ExportHandler;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionHandler
implements ConnectionHandler<HttpConnectionSettings, HttpCommonConnectionSettings> {
    private static final int DEFAULT_TIMEOUT = 30000;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static final X509TrustManager trustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    private static final HostnameVerifier verifier = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sslSession) {
            return true;
        }
    };

    @Override
    public byte[] sendData(byte[] request, HttpConnectionSettings info, HttpCommonConnectionSettings commonSettings, ExportHandler<? extends BaseExportSettings> exportHandler, List<Message> messages, EntityContainer<ExportDocument> document) throws Exception {
        try {
            this.log.debug(String.format("trying to send data to %s", info.getUrl()));
            switch (commonSettings.getRequestType()) {
                case GET: {
                    return this.getData(request, info, commonSettings, messages, document);
                }
            }
            return this.postData(request, info, commonSettings, messages, document);
        }
        catch (Throwable t) {
            this.labelItError(document, t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] postData(byte[] request, HttpConnectionSettings info, HttpCommonConnectionSettings params, List<Message> messages, EntityContainer<ExportDocument> document) throws Exception {
        URL url = info.getUrl();
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        Integer commontTimeout = params.getTimeout();
        urlConnection.setConnectTimeout(commontTimeout != null ? commontTimeout : 30000);
        if (!TextUtil.isBlank((String)info.getLogin())) {
            urlConnection.setRequestProperty("login", info.getLogin());
            urlConnection.setRequestProperty("password", info.getPassword());
        }
        this.updateConnectionParams(urlConnection, params);
        urlConnection.setUseCaches(false);
        try (OutputStream os = urlConnection.getOutputStream();){
            IoUtil.copyStream((InputStream)new ByteArrayInputStream(request), (OutputStream)os, (int)256);
        }
        return this.analizeResponse(urlConnection, messages, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getData(byte[] request, HttpConnectionSettings info, HttpCommonConnectionSettings params, List<Message> messages, EntityContainer<ExportDocument> document) throws Exception {
        StringBuilder urlStr = new StringBuilder(String.format("%s?%s=%s", "content", info.getUrl().toExternalForm(), URLEncoder.encode(new String(request, params.getDataCharset()), params.getDataCharset())));
        if (!TextUtil.isBlank((String)info.getLogin())) {
            urlStr.append(String.format("&login=%s&password=%s", URLEncoder.encode(info.getLogin(), params.getDataCharset()), URLEncoder.encode(info.getPassword(), params.getDataCharset())));
        }
        URL url = new URL(urlStr.toString());
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        this.updateConnectionParams(urlConnection, params);
        urlConnection.connect();
        try {
            byte[] byArray = this.analizeResponse(urlConnection, messages, document);
            return byArray;
        }
        finally {
            urlConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] analizeResponse(HttpURLConnection urlConnection, List<Message> messages, EntityContainer<ExportDocument> document) throws Exception {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            block16: {
                int statusCode = -1;
                try {
                    try {
                        statusCode = urlConnection.getResponseCode();
                    }
                    catch (Throwable t) {
                        if ("Read timed out".equals(t.getMessage())) {
                            throw Xeption.forEndUser((String)Messages.HttpConnectionHandler_readTimedOut, (Throwable)t, (Object[])new Object[0]);
                        }
                        throw t;
                    }
                }
                catch (Throwable t) {
                    this.log.warn("unable to connect", t);
                    throw Xeption.forEndUser((String)Messages.HttpConnectionHandler_onConnectionError, (Throwable)t, (Object[])new Object[0]);
                }
                if (200 == statusCode) {
                    this.labelIt(document, urlConnection.getURL(), statusCode, messages);
                } else {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.HttpConnectionHandler_receivedInvalidResponse, (Object[])new Object[]{Integer.toString(statusCode)}));
                    this.labelItError(document, Messages.HttpConnectionHandler_receivedInvalidResponse, Integer.toString(statusCode));
                }
                try {
                    InputStream is;
                    InputStream inputStream = is = statusCode != 200 ? urlConnection.getErrorStream() : urlConnection.getInputStream();
                    if (is == null) break block16;
                    try {
                        IoUtil.copyStream((InputStream)is, (OutputStream)byteArrayOutputStream, (int)256);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (Throwable t) {
                    this.log.warn("unable to get response trace", t);
                    throw Xeption.forEndUser((String)Messages.HttpConnectionHandler_onLogingResponse, (Throwable)t, (Object[])new Object[0]);
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private void updateConnectionParams(HttpURLConnection urlConnection, HttpCommonConnectionSettings params) throws Exception {
        urlConnection.setUseCaches(false);
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty("Accept-Charset", params.getDataCharset());
        urlConnection.setRequestProperty("Content-Type", String.format("%s; charset=%s", params.getContentType(), params.getDataCharset()));
        if (params.isVerifyHostname()) {
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(verifier);
        }
        if (params.isVerifyCertificat()) {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslContext.getSocketFactory());
        }
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.HTTP;
    }

    @Override
    public Class<HttpConnectionSettings> getSettingsClass() {
        return HttpConnectionSettings.class;
    }

    @Override
    public Class<HttpCommonConnectionSettings> getCommonSettingsClass() {
        return HttpCommonConnectionSettings.class;
    }

    private void labelIt(EntityContainer<ExportDocument> document, URL url, int status, List<Message> messages) {
        String settings;
        EntityReference relatedObject = ((ExportDocument)document.getEntity()).getObject() != null ? ((ExportDocument)document.getEntity()).getObject().getReference() : null;
        EntityContainer settingsCtr = EntityStorage.get().resolve(((ExportDocument)document.getEntity()).getExportSettings());
        String string = settings = settingsCtr != null ? ((BaseExportSettings)settingsCtr.getEntity()).getName() : "(\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e)";
        if (TextUtil.isBlank((String)settings)) {
            settings = "(\u0431\u0435\u0437 \u0438\u043c\u0435\u043d\u0438)";
        }
        String details = String.format("settings: %s,\nurl: %s,\nstatus: %d", settings, url.toString(), status);
        SysLogHelper.audit(relatedObject, "export-http", MessageHelper.createMessage((String)Messages.ExportConnectionHandler_successfulExport, (String)details, (Object[])new Object[0]));
        messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)details, (Object[])new Object[0]));
    }

    private void labelItError(EntityContainer<ExportDocument> document, String key, Object ... parameters) {
        EntityReference relatedObject = ((ExportDocument)document.getEntity()).getObject() != null ? ((ExportDocument)document.getEntity()).getObject().getReference() : null;
        SysLogHelper.audit(relatedObject, "export-http", MessageHelper.createErrorMessage((String)key, (Object[])parameters));
    }

    private void labelItError(EntityContainer<ExportDocument> document, Throwable t) {
        EntityReference relatedObject = ((ExportDocument)document.getEntity()).getObject() != null ? ((ExportDocument)document.getEntity()).getObject().getReference() : null;
        String errorMessage = t instanceof Xeption && TextUtil.nonBlank((String)((Xeption)t).toMessageString()) ? ((Xeption)t).toMessageString() : t.toString();
        SysLogHelper.audit(relatedObject, "export-http", MessageHelper.createExceptonMessage((String)Messages.ExportConnectionHandler_exportFailWithMessage, (Throwable)t, (Object[])new Object[]{errorMessage}));
    }
}

