/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TaxesFopComponent;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AFSExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AmountWithVatExport;
import com.gridnine.xtrip.common.model.export.booking.v2.CommissionExport;
import com.gridnine.xtrip.common.model.export.booking.v2.CostCodeExport;
import com.gridnine.xtrip.common.model.export.booking.v2.DecimalItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ExternalSystemCodeExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.L10nStringItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.MoneyExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ProductAmountExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RateMoneyExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReasonCodeExport;
import com.gridnine.xtrip.common.model.export.booking.v2.StatisticalDataExport;
import com.gridnine.xtrip.common.model.export.booking.v2.StringItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.SupplierExport;
import com.gridnine.xtrip.common.model.export.booking.v2.TravellerExport;
import com.gridnine.xtrip.common.model.export.booking.v2.UDIDExport;
import com.gridnine.xtrip.common.model.export.booking.v2.VatAmountExport;
import com.gridnine.xtrip.common.model.export.finance.v2.BasicOrganizationExport;
import com.gridnine.xtrip.common.model.export.finance.v2.BasicPersonExport;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceFopExport;
import com.gridnine.xtrip.common.model.export.profile.v2.CostCodePropertiesExport;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class MetadataBasedExportHelper {
    private MetadataBasedExportHelper() {
    }

    public static void convertStringCollection(Collection<StringItemExport> collection, Collection<String> values) {
        collection.clear();
        if (null == values) {
            return;
        }
        for (String value : values) {
            StringItemExport item = new StringItemExport();
            item.setValue(value);
            collection.add(item);
        }
    }

    public static void convertL10nStringCollection(Collection<L10nStringItemExport> collection, L10nString values) {
        collection.clear();
        if (values == null) {
            return;
        }
        for (Map.Entry entry : values.getValues().entrySet()) {
            L10nStringItemExport item = new L10nStringItemExport();
            item.setLocale(entry.getKey() != null ? ((Locale)entry.getKey()).toString() : null);
            item.setValue((String)entry.getValue());
            collection.add(item);
        }
    }

    public static void convertGeoRegion(Collection<L10nStringItemExport> collection, DictionaryReference<GeoRegion> regionRef) {
        if (regionRef == null) {
            return;
        }
        collection.clear();
        GeoRegion region = (GeoRegion)DictionaryCache.get().resolveReference(regionRef);
        if (region != null) {
            for (Map.Entry entry : region.getTranslations().entrySet()) {
                L10nStringItemExport item = new L10nStringItemExport();
                item.setLocale(entry.getKey() != null ? ((Locale)entry.getKey()).toString() : null);
                item.setValue((String)entry.getValue());
                collection.add(item);
            }
        }
    }

    public static void convertDecimalCollection(Collection<DecimalItemExport> collection, Collection<BigDecimal> values) {
        collection.clear();
        if (null == values) {
            return;
        }
        for (BigDecimal value : values) {
            DecimalItemExport item = new DecimalItemExport();
            item.setValue(value);
            collection.add(item);
        }
    }

    public static ProductAmountExport convertProductAmount(Money money, BigDecimal vat, BigDecimal addCollect, boolean negate) {
        if (null == money) {
            return null;
        }
        ProductAmountExport export = new ProductAmountExport();
        export.setAmount(MetadataBasedExportHelper.convertSum(money.getValue(), negate));
        export.setCurrency(MetadataBasedExportHelper.convertCurrency(money.getCurrency()));
        export.setVat(MetadataBasedExportHelper.convertSum(vat, negate));
        export.setAddCollect(!BigDecimal.ZERO.equals(addCollect) ? MetadataBasedExportHelper.convertSum(addCollect, negate) : null);
        return export;
    }

    public static VatAmountExport convertVatAmount(BigDecimal value, String currency, BigDecimal vat) {
        if (null == value) {
            return null;
        }
        VatAmountExport export = new VatAmountExport();
        export.setAmount(MetadataBasedExportHelper.convertSum(value));
        export.setCurrency(MetadataBasedExportHelper.convertCurrency(currency));
        export.setVat(MetadataBasedExportHelper.convertSum(vat));
        return export;
    }

    public static AmountWithVatExport convertVatAmount(VatAmount value) {
        if (value == null) {
            return null;
        }
        AmountWithVatExport export = new AmountWithVatExport();
        export.setAmount(MetadataBasedExportHelper.convertSum(value.getValue()));
        if (value.getVat() != null) {
            export.setVatRate(BigDecimal.valueOf(value.getVat()).setScale(2, RoundingMode.HALF_UP));
        }
        export.setVat(MetadataBasedExportHelper.convertSum(value.getVatAmount()));
        export.setTotal(MetadataBasedExportHelper.convertSum(value.getTotal()));
        return export;
    }

    public static AmountWithVatExport convertVatAmount(VatAmount value, BigDecimal baseAmount, ExchangeRateData exchangeRateData, List<BigDecimal> supplierVatRates, String baseCurrency) {
        if (value == null) {
            return null;
        }
        AmountWithVatExport export = new AmountWithVatExport();
        export.setAmount(MetadataBasedExportHelper.convertSum(value.getValue()));
        if (value.getVat() != null) {
            export.setVatRate(BigDecimal.valueOf(value.getVat()).setScale(2, RoundingMode.HALF_UP));
        }
        MetadataBasedExportHelper.convertDecimalCollection(export.getSupplierVatRates(), supplierVatRates);
        export.setVat(MetadataBasedExportHelper.convertSum(value.getVatAmount()));
        export.setTotal(MetadataBasedExportHelper.convertSum(value.getTotal()));
        export.setBaseAmount(MetadataBasedExportHelper.convertSum(baseAmount));
        if (exchangeRateData != null) {
            export.setCurrency((String)Optional.ofNullable(exchangeRateData.getCurrency()).map(DictionaryReference::getCode).orElse(null));
        }
        if (exchangeRateData != null && baseAmount != null) {
            export.setRate(BigDecimal.valueOf(exchangeRateData.getRateWithCoefficient()));
            export.setBaseCurrency(baseCurrency);
        }
        return export;
    }

    public static ProductAmountExport convertProductAmount(BigDecimal amount, String currency, BigDecimal vat, BigDecimal addCollect, boolean negate) {
        if (null == amount) {
            return null;
        }
        ProductAmountExport export = new ProductAmountExport();
        export.setAmount(MetadataBasedExportHelper.convertSum(amount, negate));
        export.setCurrency(MetadataBasedExportHelper.convertCurrency(currency));
        export.setVat(MetadataBasedExportHelper.convertSum(vat, negate));
        export.setAddCollect(!BigDecimal.ZERO.equals(addCollect) ? MetadataBasedExportHelper.convertSum(addCollect, negate) : null);
        return export;
    }

    public static BigDecimal convertSum(BigDecimal value) {
        return value != null ? value.setScale(2, RoundingMode.HALF_UP) : null;
    }

    public static BigDecimal convertSum(BigDecimal value, boolean negate) {
        return value != null ? MetadataBasedExportHelper.negate(value.setScale(2, RoundingMode.HALF_UP), negate) : null;
    }

    private static BigDecimal negate(BigDecimal value, boolean negate) {
        return negate && value != null ? value.negate() : value;
    }

    public static ObjectReferenceExport createReference(String code, String caption) {
        if (null == code && null == caption) {
            return null;
        }
        ObjectReferenceExport result = new ObjectReferenceExport();
        result.setCode(code);
        result.setCaption(caption);
        return result;
    }

    public static <E extends BaseEntity> ObjectReferenceExport convertReference(EntityReference<E> ref) {
        if (null == ref) {
            return null;
        }
        ObjectReferenceExport result = new ObjectReferenceExport();
        result.setCode(ref.getUid());
        result.setCaption(ref.getCaption());
        return result;
    }

    public static <E extends Enum<E>> ObjectReferenceExport convertEnum(E value) {
        if (null == value) {
            return null;
        }
        ObjectReferenceExport result = new ObjectReferenceExport();
        result.setCode(value.name());
        result.setCaption(value.toString());
        return result;
    }

    public static <E extends BaseDictionary> ObjectReferenceExport convertDictionary(DictionaryReference<E> ref) {
        if (null == ref) {
            return null;
        }
        ObjectReferenceExport result = new ObjectReferenceExport();
        BaseDictionary item = DictionaryCache.get().resolveReference(ref);
        if (null == item) {
            return null;
        }
        String code = ref.getCode();
        if (TextUtil.isBlank((String)code)) {
            code = item.getUid();
        }
        result.setCode(code);
        String caption = (String)MiscUtil.findByLocale((Map)item.getTranslations(), (Locale)LocaleHelper.getCurrentLocale());
        if (TextUtil.isBlank((String)caption)) {
            caption = item.toString();
        }
        result.setCaption(caption);
        return result;
    }

    public static ObjectReferenceExport convertOrganization(EntityReference<Organization> ref) {
        if (null == ref) {
            return null;
        }
        EntityContainer ctr = EntityStorage.get().resolve(ref);
        if (null == ctr) {
            return MetadataBasedExportHelper.createReference(ref.getUid(), ref.getCaption());
        }
        return MetadataBasedExportHelper.createReference(MetadataBasedExportHelper.getOrganizationCode((EntityContainer<Organization>)ctr), ((Organization)ctr.getEntity()).toString());
    }

    public static SupplierExport convertSupplier(EntityReference<Organization> ref) {
        if (ref == null) {
            return null;
        }
        EntityContainer ctr = EntityStorage.get().resolve(ref);
        SupplierExport supplierExport = new SupplierExport();
        supplierExport.setCode(ctr == null ? ref.getUid() : MetadataBasedExportHelper.getOrganizationCode((EntityContainer<Organization>)ctr));
        supplierExport.setCaption(ctr == null ? ref.getCaption() : ((Organization)ctr.getEntity()).toString());
        if (ctr != null) {
            supplierExport.setInn(((Organization)ctr.getEntity()).getRegistrationId());
            supplierExport.setKpp(((Organization)ctr.getEntity()).getKpp());
        }
        return supplierExport;
    }

    public static ObjectReferenceExport convertSalesPoint(EntityReference<SalesPoint> ref) {
        if (null == ref) {
            return null;
        }
        EntityContainer ctr = EntityStorage.get().resolve(ref);
        if (null == ctr) {
            return MetadataBasedExportHelper.createReference(ref.getUid(), ref.getCaption());
        }
        return MetadataBasedExportHelper.createReference(MetadataBasedExportHelper.getSalesPointCode((EntityContainer<SalesPoint>)ctr), ((SalesPoint)ctr.getEntity()).toString());
    }

    public static ObjectReferenceExport convertPerson(EntityReference<Person> ref) {
        if (null == ref) {
            return null;
        }
        EntityContainer ctr = EntityStorage.get().resolve(ref);
        if (null == ctr) {
            return MetadataBasedExportHelper.createReference(ref.getUid(), ref.getCaption());
        }
        return MetadataBasedExportHelper.createReference(MetadataBasedExportHelper.getPersonCode((EntityContainer<Person>)ctr), ((Person)ctr.getEntity()).toString());
    }

    public static TravellerExport convertTraveller(Traveller traveller) {
        if (traveller == null) {
            return null;
        }
        TravellerExport result = new TravellerExport();
        result.setName(traveller.getName());
        result.setNameInGds(traveller.getNameInGds());
        result.setNameInCyrillic(traveller.getCyrillicName());
        result.setPassengerUid(traveller.getPassenger() != null ? traveller.getPassenger().getUid() : null);
        return result;
    }

    public static CostCodePropertiesExport convertCostCodeProperties(CostCodeProperties properties) {
        CostCodePropertiesExport propertiesExport = new CostCodePropertiesExport();
        if (properties != null) {
            propertiesExport.setCategory(MetadataBasedExportHelper.convertDictionary(properties.getCategory()));
            if (properties.getConstraintsSet() != null) {
                propertiesExport.setConstraintsSetUID(properties.getConstraintsSet().getUid());
            }
            propertiesExport.setDisplayType(MetadataBasedExportHelper.convertEnum(properties.getDisplayType()));
            propertiesExport.setDontSyncToSabre(Boolean.valueOf(properties.isDontSyncToSabre()));
            propertiesExport.setIncludeToInvoice(Boolean.valueOf(properties.isIncludeToInvoice()));
            propertiesExport.setLocalSabreValue(properties.getLocalSabreValue());
            propertiesExport.setMask(properties.getMask());
            propertiesExport.setName(properties.getName());
            propertiesExport.setCommon(Boolean.valueOf(properties.isCommon()));
            propertiesExport.setPassengerUdid(Boolean.valueOf(properties.isPassengerUdid()));
            propertiesExport.setRemarks(properties.getRemarks());
            propertiesExport.setSabreDropList(Boolean.valueOf(properties.isSabreDropList()));
            propertiesExport.setSabreRemarks(properties.getSabreRemarks());
            propertiesExport.setSabreValue(properties.getSabreValue());
            propertiesExport.setType(MetadataBasedExportHelper.convertEnum(properties.getType()));
            propertiesExport.setDependant(Boolean.valueOf(properties.isDependant()));
            propertiesExport.setStartDate(properties.getStartDate());
            propertiesExport.setEndDate(properties.getEndDate());
        }
        return propertiesExport;
    }

    private static String getOrganizationCode(EntityContainer<Organization> ctr) {
        String code = ((Organization)ctr.getEntity()).getCode();
        if (!TextUtil.isBlank((String)code)) {
            return code;
        }
        return ctr.getUid();
    }

    private static String getSalesPointCode(EntityContainer<SalesPoint> ctr) {
        String code = ((SalesPoint)ctr.getEntity()).getCode();
        if (!TextUtil.isBlank((String)code)) {
            return code;
        }
        return ctr.getUid();
    }

    private static String getPersonCode(EntityContainer<Person> ctr) {
        String code = ((Person)ctr.getEntity()).getCode();
        if (!TextUtil.isBlank((String)code)) {
            return code;
        }
        return ctr.getUid();
    }

    public static String convertCurrency(String currency) {
        return currency;
    }

    public static Date convertDateTime(LocalDateTime value) {
        return value != null ? Date.from(value.atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static MoneyExport convertMoney(Money money) {
        return MetadataBasedExportHelper.convertMoney(money, false);
    }

    public static MoneyExport convertMoney(Money money, boolean negate) {
        if (null == money) {
            return null;
        }
        return MetadataBasedExportHelper.convertMoney(money.getValue(), money.getCurrency(), negate);
    }

    public static MoneyExport convertMoney(BigDecimal amount, String currency, boolean negate) {
        if (null == amount) {
            return null;
        }
        MoneyExport export = new MoneyExport();
        export.setAmount(MetadataBasedExportHelper.convertSum(amount, negate));
        export.setCurrency(MetadataBasedExportHelper.convertCurrency(currency));
        return export;
    }

    public static RateMoneyExport convertRateMoney(Money money, Double rate) {
        return MetadataBasedExportHelper.convertRateMoney(money, rate, false);
    }

    public static RateMoneyExport convertRateMoney(Money money, Double rate, boolean negate) {
        if (null == money && null == rate) {
            return null;
        }
        RateMoneyExport rateMoneyExport = new RateMoneyExport();
        if (money != null) {
            rateMoneyExport.setAmount(MetadataBasedExportHelper.convertSum(money.getValue(), negate));
            rateMoneyExport.setCurrency(MetadataBasedExportHelper.convertCurrency(money.getCurrency()));
        }
        if (rate != null) {
            rateMoneyExport.setRate(new BigDecimal(rate));
        }
        return rateMoneyExport;
    }

    public static MoneyExport calculateCommissions(BaseProduct product, ContractType contractType, Set<Class<? extends BaseCommissionProperties>> filter, Collection<CommissionExport> commissions, String equivalentCurrency, boolean negate) {
        return MetadataBasedExportHelper.calculateCommissions(GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)contractType), filter, null, null), commissions, equivalentCurrency, negate);
    }

    public static <E extends BaseCommission> MoneyExport calculateCommissions(Collection<E> commissions, Collection<CommissionExport> export, String equivalentCurrency, boolean negate) {
        BigDecimal result = BigDecimal.ZERO;
        for (BaseCommission commission : commissions) {
            CommissionExport commissionExport = new CommissionExport();
            commissionExport.setName(MetadataBasedExportHelper.convertReference(commission.getCommissionProperties()));
            commissionExport.setRate(MetadataBasedExportHelper.convertRateMoney(commission.getAmount(), commission.getRate(), negate));
            commissionExport.setEquivalentAmount(MetadataBasedExportHelper.convertMoney(commission.getEquivalentAmount(), equivalentCurrency, negate));
            export.add(commissionExport);
            if (commission.getEquivalentAmount() == null) continue;
            result = result.add(commission.getEquivalentAmount());
        }
        return MetadataBasedExportHelper.convertMoney(result, equivalentCurrency, negate);
    }

    public static StatisticalDataExport convertStatisticalData(BaseProduct product) {
        EntityReference customerProfile = product.getReservation().getBookingFile().getCustomerProfile();
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        StatisticalData statisticalData = handler.getStatisticalData(product);
        if (null == statisticalData) {
            return null;
        }
        StatisticalDataExport statisticalDataExport = new StatisticalDataExport();
        statisticalDataExport.setOverallDestination(MetadataBasedExportHelper.convertDictionary(statisticalData.getOverallDestination()));
        statisticalDataExport.setValidatingCarrier(MetadataBasedExportHelper.convertDictionary(statisticalData.getValidatingCarrier()));
        statisticalDataExport.setOverallClassService(statisticalData.getOverallClassService());
        statisticalDataExport.setHbf1(MetadataBasedExportHelper.getAFS(statisticalData.getHbf1Bkg(), statisticalData.getHbf1Tkt()));
        statisticalDataExport.setHbf2(MetadataBasedExportHelper.getAFS(statisticalData.getHbf2Bkg(), statisticalData.getHbf2Tkt()));
        statisticalDataExport.setLaf1(MetadataBasedExportHelper.getAFS(statisticalData.getLaf1Bkg(), statisticalData.getLaf1Tkt()));
        statisticalDataExport.setLaf2(MetadataBasedExportHelper.getAFS(statisticalData.getLaf2Bkg(), statisticalData.getLaf2Tkt()));
        statisticalDataExport.setLaf3(MetadataBasedExportHelper.getAFS(statisticalData.getLaf3Bkg(), statisticalData.getLaf3Tkt()));
        statisticalDataExport.setAtf1(MetadataBasedExportHelper.getAFS(statisticalData.getAtf1Bkg(), statisticalData.getAtf1Tkt()));
        statisticalDataExport.setAtf2(MetadataBasedExportHelper.getAFS(statisticalData.getAtf2Bkg(), statisticalData.getAtf2Tkt()));
        statisticalDataExport.setLpf1(MetadataBasedExportHelper.getAFS(statisticalData.getLpf1Bkg(), statisticalData.getLpf1Tkt()));
        statisticalDataExport.setLpf2(MetadataBasedExportHelper.getAFS(statisticalData.getLpf2Bkg(), statisticalData.getLpf2Tkt()));
        statisticalDataExport.setLpf3(MetadataBasedExportHelper.getAFS(statisticalData.getLpf3Bkg(), statisticalData.getLpf3Tkt()));
        statisticalDataExport.setP3d(MetadataBasedExportHelper.getAFS(statisticalData.getP3dBkg(), statisticalData.getP3dTkt()));
        statisticalDataExport.setCtf(MetadataBasedExportHelper.getAFS(statisticalData.getCtfBkg(), statisticalData.getCtfTkt()));
        for (ReasonCode reasonCode : statisticalData.getReasonCodes()) {
            ReasonCodeExport reasonCodeExport = new ReasonCodeExport();
            reasonCodeExport.setName(reasonCode.getName());
            if (!ReasonCodeType.REASON_CODE_DECLINED.equals((Object)reasonCode.getType())) {
                String remark = L10nStringHelper.getValue((L10nString)reasonCode.getRemarks(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
                reasonCodeExport.setValue(!TextUtil.isBlank((String)remark) ? remark : "?");
            }
            statisticalDataExport.getReasonCodes().add(reasonCodeExport);
        }
        MetadataBasedExportHelper.addUdids(statisticalDataExport, statisticalData, (EntityReference<Organization>)customerProfile);
        MetadataBasedExportHelper.addCostCodes(statisticalDataExport, statisticalData, (EntityReference<Organization>)customerProfile, (ProductHandler<BaseProduct>)handler, product);
        return statisticalDataExport;
    }

    private static CostCodeProperties getProperties(CostCode costCode, EntityReference<Organization> customerRef) {
        CostCodeProperties properties = costCode.getCostCodeProperties();
        if (properties != null) {
            CostCodeProperties orgProperties;
            EntityContainer customer = customerRef != null ? EntityStorage.get().resolve(customerRef) : null;
            CostCodeProperties finalProperties = properties;
            CostCodeProperties costCodeProperties = orgProperties = customer != null ? (CostCodeProperties)((Organization)customer.getEntity()).getCostCodeProperties().stream().filter(ccp -> MiscUtil.equals((Object)ccp.getCategory(), (Object)finalProperties.getCategory())).findFirst().orElse(null) : null;
            if (orgProperties != null) {
                properties = orgProperties;
            }
        }
        return properties;
    }

    private static void addCostCodes(StatisticalDataExport statisticalDataExport, StatisticalData statisticalData, EntityReference<Organization> customerProfile, ProductHandler<BaseProduct> handler, BaseProduct product) {
        EntityContainer organization = EntityStorage.get().resolve(customerProfile);
        List mandatoryAfs = organization != null ? MetadataBasedExportHelper.getAFSTypeList(((Organization)organization.getEntity()).getAfsSettings()) : Collections.emptyList();
        List costCodes = statisticalDataExport.getCostCodes();
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.HBF1, statisticalData.getHbf1Tkt() != null ? statisticalData.getHbf1Tkt() : statisticalData.getHigherBenchmarkFare(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.HBF2, statisticalData.getHbf2Tkt(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.LAF1, statisticalData.getLaf1Tkt() != null ? statisticalData.getLaf1Tkt() : statisticalData.getLowestAvailableFare(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.LAF2, statisticalData.getLaf2Tkt(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.LAF3, statisticalData.getLaf3Tkt(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.ATF1, statisticalData.getAtf1Tkt() != null ? statisticalData.getAtf1Tkt() : statisticalData.getActualTicketFare(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.ATF2, statisticalData.getAtf2Tkt(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.LPF1, statisticalData.getLpf1Tkt(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.LPF2, statisticalData.getLpf2Tkt(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.LPF3, statisticalData.getLpf3Tkt(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.P3D, statisticalData.getP3dTkt(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.CTF, statisticalData.getCtfTkt(), mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.DEST, statisticalData.getOverallDestination() != null ? DictHelper.getCodeVariant((DictionaryReference)statisticalData.getOverallDestination(), (CodeSystem[])new CodeSystem[]{CodeSystem.IATA}) : null, mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.VALC, statisticalData.getValidatingCarrier() != null ? DictHelper.getCodeVariant((DictionaryReference)statisticalData.getValidatingCarrier(), (CodeSystem[])new CodeSystem[]{CodeSystem.IATA}) : null, mandatoryAfs);
        MetadataBasedExportHelper.addCostCode((List<CostCodeExport>)costCodes, AFSType.OCCL, statisticalData.getOverallClassService(), mandatoryAfs);
        if (!statisticalData.getReasonCodes().isEmpty()) {
            for (ReasonCode code : statisticalData.getReasonCodes()) {
                MetadataBasedExportHelper.addCostCode(costCodes, "REASON_CODE", code.getName());
            }
        } else if (organization != null && !((Organization)organization.getEntity()).getReasonCodes().isEmpty()) {
            MetadataBasedExportHelper.addCostCode(costCodes, "REASON_CODE", "\u043d\u0435\u0442");
        }
        MetadataBasedExportHelper.addTravellerCostCodes(costCodes, statisticalData, customerProfile);
    }

    public static void addTravellerCostCodes(List<CostCodeExport> costCodes, StatisticalData statisticalData, EntityReference<Organization> customerProfile) {
        for (TravellerCostCodes travellerCostCode : statisticalData.getTravellerCostCodes()) {
            for (CostCode costCode : travellerCostCode.getCostCodes()) {
                CostCodeProperties props = MetadataBasedExportHelper.getProperties(costCode, customerProfile);
                if (null == props) continue;
                CostCodeCategory category = (CostCodeCategory)DictionaryCache.get().resolveReference(props.getCategory());
                if (null == category) {
                    throw Xeption.forEndUser((String)("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f " + (props.getCategory() != null ? props.getCategory().getCode() + ", " + props.getCategory().getCaption() : "(\u043d\u0435\u0442)") + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435"), (Object[])new Object[0]);
                }
                String name = category.getName();
                if (TextUtil.isBlank((String)name)) continue;
                MetadataBasedExportHelper.addCostCode(costCodes, name, costCode.getValue(), costCode.getLocalValue(), costCode.getEnglishValue(), travellerCostCode.getTraveller() != null ? travellerCostCode.getTraveller().getName() : null, props.isCommon());
            }
        }
    }

    public static void addUdids(StatisticalDataExport statisticalDataExport, StatisticalData statisticalData, EntityReference<Organization> customerProfile) {
        for (TravellerCostCodes travellerData : statisticalData.getTravellerCostCodes()) {
            for (CostCode costCode : travellerData.getCostCodes()) {
                UDIDExport costCodeExport = new UDIDExport();
                CostCodeProperties properties = MetadataBasedExportHelper.getProperties(costCode, customerProfile);
                costCodeExport.setCode(!TextUtil.isBlank((String)costCode.getLocalValue()) ? costCode.getLocalValue() : costCode.getValue());
                costCodeExport.setType(properties != null ? properties.getName() : null);
                costCodeExport.setValue(costCode.getValue());
                costCodeExport.setLocalValue(costCode.getLocalValue());
                costCodeExport.setEnglishValue(costCode.getEnglishValue());
                costCodeExport.setTraveller(travellerData.getTraveller() != null ? travellerData.getTraveller().getName() : null);
                costCodeExport.setPassengerUid(travellerData.getTraveller() != null && travellerData.getTraveller().getPassenger() != null ? travellerData.getTraveller().getPassenger().getUid() : null);
                costCodeExport.setCommon(properties != null ? Boolean.valueOf(properties.isCommon()) : null);
                statisticalDataExport.getUdids().add(costCodeExport);
            }
        }
    }

    public static AFSExport getAFS(Double bkg, Double tkt) {
        if (null == bkg && null == tkt) {
            return null;
        }
        AFSExport result = new AFSExport();
        if (bkg != null) {
            result.setBkg(new BigDecimal(bkg));
        }
        if (tkt != null) {
            result.setTkt(new BigDecimal(tkt));
        }
        return result;
    }

    private static boolean addCostCode(List<CostCodeExport> costCodes, String code, String value, String localValue, String englishValue, String traveller, boolean common) {
        if (TextUtil.isBlank((String)value)) {
            return false;
        }
        CostCodeExport costCodeExport = new CostCodeExport();
        costCodeExport.setCode(code);
        costCodeExport.setValue(value);
        costCodeExport.setLocalValue(localValue);
        costCodeExport.setEnglishValue(englishValue);
        costCodeExport.setTraveller(traveller);
        costCodeExport.setCommon(Boolean.valueOf(common));
        costCodes.add(costCodeExport);
        return true;
    }

    private static <E extends Enum<E>> boolean addCostCode(List<CostCodeExport> costCodes, E type, String value, String defaultValue, List<E> mandatoryAfs) {
        String rightValue = value;
        if (null == rightValue && mandatoryAfs.contains(type)) {
            rightValue = defaultValue != null ? defaultValue : "\u043d\u0435\u0442";
        }
        return MetadataBasedExportHelper.addCostCode(costCodes, type.name(), rightValue);
    }

    private static <E extends Enum<E>> boolean addCostCode(List<CostCodeExport> costCodes, E type, String value, List<E> mandatoryAfs) {
        return MetadataBasedExportHelper.addCostCode(costCodes, type, value, null, mandatoryAfs);
    }

    private static <E extends Enum<E>> boolean addCostCode(List<CostCodeExport> costCodes, E type, Double value, List<E> mandatoryAfs) {
        return MetadataBasedExportHelper.addCostCode(costCodes, type, value != null ? value.toString() : null, null, mandatoryAfs);
    }

    private static <E extends Enum<E>> boolean addCostCode(List<CostCodeExport> costCodes, E type, Integer value, List<E> mandatoryAfs) {
        return MetadataBasedExportHelper.addCostCode(costCodes, type, value != null ? value.toString() : null, null, mandatoryAfs);
    }

    private static <E extends Enum<E>> boolean addCostCode(List<CostCodeExport> costCodes, E type, BigDecimal value, String defaultValue, List<E> mandatoryAfs) {
        return MetadataBasedExportHelper.addCostCode(costCodes, type, value != null ? value.toPlainString() : null, defaultValue, mandatoryAfs);
    }

    private static <E extends Enum<E>> boolean addCostCode(List<CostCodeExport> costCodes, E type, Date value, List<E> mandatoryAfs) {
        return MetadataBasedExportHelper.addCostCode(costCodes, type, value != null ? new SimpleDateFormat("dd.MM.yyyy").format(value) : null, null, mandatoryAfs);
    }

    private static boolean addCostCode(List<CostCodeExport> costCodes, String code, String value) {
        if (TextUtil.isBlank((String)value)) {
            return false;
        }
        CostCodeExport costCodeExport = new CostCodeExport();
        costCodeExport.setCode(code);
        costCodeExport.setValue(value);
        costCodes.add(costCodeExport);
        return true;
    }

    private static List<AFSType> getAFSTypeList(String afsSettings) {
        ArrayList<AFSType> afsTypes = new ArrayList<AFSType>();
        if (!TextUtil.isBlank((String)afsSettings)) {
            String[] settings;
            for (String str : settings = afsSettings.split("\\|")) {
                if (TextUtil.isBlank((String)str)) continue;
                afsTypes.add(AFSType.valueOf((String)str));
            }
        }
        return afsTypes;
    }

    public static ObjectReferenceExport convertCommission(BaseCommission commission) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        result.setCode(commission.getUid());
        result.setCaption(commission.getCommissionProperties() != null ? commission.getCommissionProperties().toString() : null);
        return result;
    }

    public static BasicOrganizationExport convertBasicOrganization(EntityReference<Organization> organization, EntityStorageContext context) {
        if (organization == null) {
            return null;
        }
        BasicOrganizationExport result = new BasicOrganizationExport();
        EntityContainer ctr = EntityStorageHelper.resolve(organization, (EntityStorageContext)context);
        if (EntityStorageHelper.isEmpty((EntityContainer)ctr)) {
            result.setUid(organization.getUid());
            return result;
        }
        result.setUid(ctr.getUid());
        result.setCode(((Organization)ctr.getEntity()).getCode());
        result.setRegistrationId(((Organization)ctr.getEntity()).getRegistrationId());
        result.setKpp(((Organization)ctr.getEntity()).getKpp());
        result.setForeign(Boolean.valueOf(((Organization)ctr.getEntity()).isForeign()));
        result.setBin(((Organization)ctr.getEntity()).getBin());
        result.setVatSeriesNumber(((Organization)ctr.getEntity()).getVatSeriesNumber());
        result.setVatSeriesDate(((Organization)ctr.getEntity()).getVatSeriesDate());
        result.setBeneficiaryCode(((Organization)ctr.getEntity()).getBeneficiaryCode() != null ? ((Organization)ctr.getEntity()).getBeneficiaryCode().toString() : null);
        MetadataBasedExportHelper.convertL10nStringCollection(result.getShortName(), ((Organization)ctr.getEntity()).getShortName());
        MetadataBasedExportHelper.convertL10nStringCollection(result.getFullName(), ((Organization)ctr.getEntity()).getFullName());
        return result;
    }

    public static BasicPersonExport convertBasicPerson(EntityReference<Person> person, EntityStorageContext context) {
        if (person == null) {
            return null;
        }
        BasicPersonExport result = new BasicPersonExport();
        EntityContainer ctr = EntityStorageHelper.resolve(person, (EntityStorageContext)context);
        if (EntityStorageHelper.isEmpty((EntityContainer)ctr)) {
            result.setUid(person.getUid());
            return result;
        }
        result.setUid(ctr.getUid());
        result.setCode(((Person)ctr.getEntity()).getCode());
        result.setGender(MetadataBasedExportHelper.convertEnum(((Person)ctr.getEntity()).getGender()));
        MetadataBasedExportHelper.convertL10nStringCollection(result.getLastName(), ((Person)ctr.getEntity()).getLastName());
        MetadataBasedExportHelper.convertL10nStringCollection(result.getFirstName(), ((Person)ctr.getEntity()).getFirstName());
        MetadataBasedExportHelper.convertL10nStringCollection(result.getSecondName(), ((Person)ctr.getEntity()).getSecondName());
        MetadataBasedExportHelper.convertL10nStringCollection(result.getMiddleName(), ((Person)ctr.getEntity()).getMiddleName());
        return result;
    }

    public static FinanceFopExport convertFop(NestedEntityReference<BookingFile, Fop> reference, EntityStorageContext context, Logger log) {
        Fop fop = MetadataBasedExportHelper.resolve(reference, context, log);
        if (fop == null) {
            return null;
        }
        FinanceFopExport result = new FinanceFopExport();
        result.setUid(fop.getUid());
        result.setType(MetadataBasedExportHelper.convertEnum(fop.getType()));
        return result;
    }

    public static FopComponentExport convertFopComponent(FopComponent component, boolean negate) {
        FopComponentExport result = new FopComponentExport();
        result.setTraveller(MetadataBasedExportHelper.convertTraveller(component.getTraveller()));
        result.setAmount(MetadataBasedExportHelper.convertSum(component.getAmount(), negate));
        result.setVatAmount(MetadataBasedExportHelper.convertSum(component.getVatAmount(), negate));
        result.setVatRate(component.getVatRate() != null ? BigDecimal.valueOf(component.getVatRate()) : null);
        result.setType(MetadataBasedExportHelper.convertEnum(component.getType()));
        result.setNomenclature(MetadataBasedExportHelper.convertDictionary(component.getNomenclature()));
        result.setHidden(Boolean.valueOf(component.isHidden()));
        result.setShipment(MetadataBasedExportHelper.convertReference(component.getShipment()));
        result.setCorrectionShipment(MetadataBasedExportHelper.convertReference(component.getCorrectionShipment()));
        result.setReceipt(MetadataBasedExportHelper.convertReference(component.getReceipt()));
        if (component instanceof TaxesFopComponent) {
            result.setTaxCode(((TaxesFopComponent)component).getTaxes());
        }
        return result;
    }

    public static List<GeneralProductFop> getSortedFops(List<GeneralProductFop> fops) {
        return fops.stream().sorted((o1, o2) -> {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            int result = MiscUtil.compare((Comparable)o1.getEquivalentAmount(), (Comparable)o2.getEquivalentAmount());
            if (result == 0) {
                return MiscUtil.compare((Comparable)((Object)o1.getUid()), (Comparable)((Object)o1.getUid()));
            }
            return result;
        }).collect(Collectors.toList());
    }

    public static List<FopComponent> getSortedFopComponents(List<FopComponent> components) {
        return components.stream().sorted(FinanceDocumentsHelper.fopComponentComparator).collect(Collectors.toList());
    }

    public static ObjectReferenceExport getFopCategory(GeneralProductFop fop) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
            boolean payment = false;
            boolean discount = false;
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    payment = true;
                    break;
                }
                if (commission.getCommissionProperties() == null || !GeneralProductHelper.discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                discount = true;
                break;
            }
            if (payment) {
                result.setCode("PAYMENT_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            } else if (discount) {
                result.setCode("DISCOUNT");
                result.setCaption("\u0421\u043a\u0438\u0434\u043a\u0430");
            } else {
                result.setCode("SERVICE_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440");
            }
        } else {
            result.setCode("PRODUCT");
            result.setCaption("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        }
        return result;
    }

    public static <Root extends BaseEntity, Nested extends BaseEntity> Nested resolve(NestedEntityReference<Root, Nested> ref, EntityStorageContext context, Logger log) {
        BaseEntity result = EntityStorageHelper.resolve(ref, (EntityStorageContext)context);
        if (ref != null && result == null && log != null) {
            log.error(String.format("Unable to resolve nested entity reference with root %s (%s) and nested %s (%s)", ref.getType(), ref.getUid(), ref.getNestedEntityType(), ref.getNestedEntityUid()));
        }
        return (Nested)result;
    }

    public static ExternalSystemCodeExport convertExternalSystemCode(ExternalSystemCodeV2 externalCode) {
        if (externalCode != null) {
            ExternalSystemCodeExport result = new ExternalSystemCodeExport();
            result.setSystem((String)Optional.ofNullable(externalCode.getSystem()).map(DictionaryReference::getCode).orElse(null));
            result.setCode(externalCode.getCode());
            return result;
        }
        return null;
    }

    public static ObjectReferenceExport convertLocation(DictionaryReference<GeoLocation> location) {
        Country country;
        GeoLocation parent;
        DictionaryCache dictionaryCache = DictionaryCache.get();
        GeoLocation value = (GeoLocation)dictionaryCache.resolveReference(location);
        if (value == null) {
            return MetadataBasedExportHelper.convertDictionary(location);
        }
        String code = MetadataBasedExportHelper.getCaption((BaseDictionary)value);
        if (code == null) {
            return MetadataBasedExportHelper.convertDictionary(location);
        }
        StringBuilder sb = new StringBuilder();
        if (value.getType() == LocationType.AIRPORT && (parent = (GeoLocation)dictionaryCache.resolveReference(value.getParent())) != null) {
            sb.append(MetadataBasedExportHelper.getCaption((BaseDictionary)parent)).append(',');
        }
        if ((country = (Country)dictionaryCache.resolveReference(value.getCountry())) != null) {
            sb.append(MetadataBasedExportHelper.getCaption((BaseDictionary)country));
        }
        return MetadataBasedExportHelper.createReference(code, sb.toString());
    }

    public static ObjectReferenceExport convertAirline(DictionaryReference<Airline> airline, CodeSystem[] codeSystems) {
        if (airline == null) {
            return null;
        }
        DictionaryCache dictionaryCache = DictionaryCache.get();
        Airline value = (Airline)dictionaryCache.resolveReference(airline);
        if (value == null) {
            return MetadataBasedExportHelper.convertDictionary(airline);
        }
        String code = MetadataBasedExportHelper.getCode((BaseDictionary)value, codeSystems);
        if (TextUtil.isBlank((String)code)) {
            code = value.getCode();
        }
        if (TextUtil.isBlank((String)code)) {
            code = value.getUid();
        }
        String caption = String.join((CharSequence)",", value.getCodeVariants().values());
        return MetadataBasedExportHelper.createReference(code, caption);
    }

    public static String getLocationCode(DictionaryReference<GeoLocation> location, CodeSystem[] codeSystems) {
        if (location == null) {
            return null;
        }
        DictionaryCache dictionaryCache = DictionaryCache.get();
        GeoLocation value = (GeoLocation)dictionaryCache.resolveReference(location);
        if (value == null) {
            return location.getCode();
        }
        return MetadataBasedExportHelper.getCode((BaseDictionary)value, codeSystems);
    }

    private static String getCaption(BaseDictionary value) {
        String caption = (String)MiscUtil.findByLocale((Map)value.getTranslations(), (Locale)LocaleHelper.getCurrentLocale());
        if (TextUtil.isBlank((String)caption)) {
            caption = (String)value.getTranslations().get(Locale.ENGLISH);
        }
        return caption;
    }

    private static String getCode(BaseDictionary value, CodeSystem[] codeSystems) {
        for (CodeSystem sys : codeSystems) {
            String code = (String)value.getCodeVariants().get(sys.name());
            if (code == null) continue;
            return code;
        }
        return value.getCode();
    }
}

