/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.SftpCommonConnectionSettings;
import com.gridnine.xtrip.common.model.export.SftpConnectionSettings;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.export.ConnectionHandler;
import com.gridnine.xtrip.server.model.export.ExportHandler;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpConnectionHandler
implements ConnectionHandler<SftpConnectionSettings, SftpCommonConnectionSettings> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int DEFAULT_TIMEOUT = 30000;
    private static final Random stamp = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sendData(byte[] request, SftpConnectionSettings info, SftpCommonConnectionSettings commonSettings, ExportHandler<? extends BaseExportSettings> exportHandler, List<Message> messages, EntityContainer<ExportDocument> document) throws Exception {
        try {
            String recordName = FilenameUtils.getName((String)((ExportDocument)document.getEntity()).getFileName());
            if (TextUtil.isBlank((String)FilenameUtils.getExtension((String)((ExportDocument)document.getEntity()).getFileName()))) {
                String ext;
                String string = ext = TextUtil.isBlank((String)commonSettings.getFileExtension()) ? "xml" : commonSettings.getFileExtension();
                if (!TextUtil.isBlank((String)recordName)) {
                    if (TextUtil.isBlank((String)FilenameUtils.getExtension((String)recordName))) {
                        recordName = recordName + "." + ext;
                    }
                } else {
                    String prefix = TextUtil.isBlank((String)commonSettings.getFilePrefix()) ? "gridnine" : commonSettings.getFilePrefix();
                    String description = ((ExportDocument)document.getEntity()).getDescription() != null ? ((ExportDocument)document.getEntity()).getDescription().replace(" ", "_") : "";
                    prefix = prefix.replace("${description}", description);
                    SimpleDateFormat sdf = new SimpleDateFormat(TextUtil.isBlank((String)commonSettings.getDateFormatterPattern()) ? "yyyy-MM-dd-HH-mm-ss-SSS" : commonSettings.getDateFormatterPattern());
                    String postfix = commonSettings.isStamp() ? "-" + TextUtil.fillLeft((String)Long.toString(stamp.nextInt(10000)), (char)'0', (int)4) : "";
                    recordName = String.format("%s-%s%s.%s", prefix, sdf.format(new Date()), postfix, ext);
                }
            }
            if (info.getUrl() == null) {
                EntityContainer exportSettings = EntityStorage.get().resolve(((ExportDocument)document.getEntity()).getExportSettings());
                throw Xeption.forEndUser((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d url \u0434\u043b\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 {0}", (Object[])new Object[]{exportSettings != null ? ((BaseExportSettings)exportSettings.getEntity()).getName() : ((ExportDocument)document.getEntity()).getExportSettings().toString()});
            }
            String host = info.getUrl().getHost();
            int port = info.getUrl().getPort();
            this.log.debug(String.format("trying to send data to %s", info.getUrl()));
            JSch jSch = new JSch();
            Session session = jSch.getSession(info.getLogin(), host, port != -1 ? port : 22);
            if (TextUtil.isBlank((String)info.getKey())) {
                session.setPassword(info.getPassword());
            } else {
                jSch.addIdentity(info.getLogin(), info.getKey().getBytes(StandardCharsets.UTF_8), null, MiscUtil.guarded((String)info.getPassword()).getBytes(StandardCharsets.UTF_8));
            }
            session.setConfig("StrictHostKeyChecking", "no");
            Integer commonTimeout = commonSettings.getTimeout();
            int timeout = commonTimeout != null ? commonTimeout : 30000;
            session.setTimeout(timeout);
            session.connect();
            try {
                ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
                channel.connect(timeout);
                String path = MiscUtil.guarded((String)info.getUrl().getPath()).replace('\\', '/');
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                String file = TextUtil.isBlank((String)path) ? recordName : String.format("%s/%s", path, recordName);
                channel.put((InputStream)new ByteArrayInputStream(request), file);
                this.labelIt(document, info.getUrl(), recordName, messages);
            }
            finally {
                session.disconnect();
            }
            return null;
        }
        catch (Throwable t) {
            this.labelItError(document, t);
            throw t;
        }
    }

    private void labelIt(EntityContainer<ExportDocument> document, URL url, String recordName, List<Message> messages) {
        String settings;
        EntityReference relatedObject = ((ExportDocument)document.getEntity()).getObject() != null ? ((ExportDocument)document.getEntity()).getObject().getReference() : null;
        EntityContainer settingsCtr = EntityStorage.get().resolve(((ExportDocument)document.getEntity()).getExportSettings());
        String string = settings = settingsCtr != null ? ((BaseExportSettings)settingsCtr.getEntity()).getName() : "(\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e)";
        if (TextUtil.isBlank((String)settings)) {
            settings = "(\u0431\u0435\u0437 \u0438\u043c\u0435\u043d\u0438)";
        }
        String details = String.format("settings: %s,\nurl: %s,\nfile: %s", settings, url.toString(), recordName);
        SysLogHelper.audit(relatedObject, "export-sftp", MessageHelper.createMessage((String)Messages.ExportConnectionHandler_successfulExport, (String)details, (Object[])new Object[0]));
        messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)details, (Object[])new Object[0]));
    }

    private void labelItError(EntityContainer<ExportDocument> document, Throwable t) {
        Throwable error = t;
        if (t instanceof SocketTimeoutException) {
            error = Xeption.forEndUser((String)"\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430", (Throwable)t, (Object[])new Object[0]);
        }
        EntityReference relatedObject = ((ExportDocument)document.getEntity()).getObject() != null ? ((ExportDocument)document.getEntity()).getObject().getReference() : null;
        SysLogHelper.audit(relatedObject, "export-sftp", MessageHelper.createExceptonMessage((String)Messages.ExportConnectionHandler_exportFail, (Throwable)error, (Object[])new Object[0]));
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.SFTP;
    }

    @Override
    public Class<SftpConnectionSettings> getSettingsClass() {
        return SftpConnectionSettings.class;
    }

    @Override
    public Class<SftpCommonConnectionSettings> getCommonSettingsClass() {
        return SftpCommonConnectionSettings.class;
    }
}

