/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.service;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.ExportReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.metrics.Metrics;
import com.gridnine.xtrip.server.model.export.service.ExportDocumentsHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class BuildExportDocumentsTask
extends BaseScheduledTask {
    private static final String METRICS_KEY = "profiling.export.build-export-documents";
    private static final String PROCESS_KEY = "profiling.export.build-export-documents.process";
    private static final String BUILD_DOCUMENT_KEY = "profiling.export.build-export-documents.build";
    private int threadCount = 2;
    private static AtomicBoolean RUNNING = new AtomicBoolean(false);

    public void configure(Properties config) throws Exception {
        this.threadCount = this.getParameter("thread-count", this.getParameter("threadCount", this.threadCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doJob() throws Exception {
        try {
            if (RUNNING.get()) {
                return;
            }
            try {
                RUNNING.set(true);
                long timing = System.currentTimeMillis();
                try {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getOrders().put(ExportReference.Property.modified.name(), SortOrder.ASC);
                    query.getPreferredProperties().add("refUid");
                    query.getPreferredProperties().add("refType");
                    query.getPreferredProperties().add("refCaption");
                    List data = AssetsStorage.get().search(ExportReference.class, query).getData();
                    if (data.size() == 0) {
                        Metrics.get().timingAndEvent("profiling.export.build-export-documents.process.no-data", timing);
                        this.log.debug("no refs found");
                        return;
                    }
                    Metrics.get().value("profiling.export.build-export-documents.process.data", (long)data.size());
                    ExecutorServiceFacade executor = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool("export-document-builder", this.threadCount);
                    try {
                        LockManager lockManager = LockUtil.getLockManager();
                        String currentUser = LogicalStorage.get().getUser();
                        Locale currentLocale = LocaleManager.get().getCurrentLocale();
                        ArrayList<ExportReference> data2 = new ArrayList<ExportReference>();
                        for (ExportReference item : data) {
                            EntityReference ref = item.getRef();
                            this.log.info("process ExportReference ref=" + (ref != null ? ref.getUid() : "(null)") + ", old.version=" + (item.getOldEntity() != null ? Integer.valueOf(item.getOldEntity().getVersionInfo().getVersionNumber()) : "(null)") + ", old.revision=" + (item.getOldEntity() != null ? item.getOldEntity().getRevision() : "(null)"));
                            if (ref != null && data2.stream().noneMatch(i -> ref.equals((Object)i.getRef()))) {
                                data2.add(item);
                                continue;
                            }
                            Metrics.get().timingAndEvent("profiling.export.build-export-documents.process.not-processed", timing);
                            try {
                                AssetsStorage.get().delete((BaseAsset)item);
                            }
                            catch (Exception e) {
                                this.log.error("an error has occurred. ref to delete: " + ref, (Throwable)e);
                                Metrics.get().timingAndEvent("profiling.export.build-export-documents.process.fail", timing);
                            }
                        }
                        CountDownLatch barrier = new CountDownLatch(data2.size());
                        for (ExportReference item : data2) {
                            if (this.isToBeStopped()) {
                                return;
                            }
                            Logger l = this.log;
                            executor.submit(() -> {
                                EntityReference ref = item.getRef();
                                try {
                                    if (this.isToBeStopped()) {
                                        return;
                                    }
                                    long buildTiming = System.currentTimeMillis();
                                    try {
                                        LogicalStorage.get().setUser(currentUser);
                                        if (currentLocale != null) {
                                            LocaleManager.get().setCurrentLocale(currentLocale);
                                        }
                                        try (NamedLock lock = lockManager.getLock((Object)LockUtil.getLockKey((EntityReference)ref, (String)"build-export-documents"));){
                                            if (!lock.tryLock(1L, TimeUnit.MILLISECONDS)) {
                                                Metrics.get().timingAndEvent("profiling.export.build-export-documents.build.not-processed", buildTiming);
                                                return;
                                            }
                                            try {
                                                ExportReference item2;
                                                block54: {
                                                    item2 = (ExportReference)AssetsStorage.get().load(ExportReference.class, item.getUid());
                                                    if (null == item2) {
                                                        Metrics.get().timingAndEvent("profiling.export.build-export-documents.build.not-processed", buildTiming);
                                                        return;
                                                    }
                                                    if (item2.getRef() == null) {
                                                        Metrics.get().timingAndEvent("profiling.export.build-export-documents.build.not-processed", buildTiming);
                                                        return;
                                                    }
                                                    ref = item2.getRef();
                                                    if (item2.getModified() != null) {
                                                        Metrics.get().value("profiling.export.build-export-documents.build.latency", System.currentTimeMillis() - item2.getModified().getTime());
                                                    }
                                                    try {
                                                        if (!item2.isDeleted()) {
                                                            EntityContainer ctr = EntityStorage.get().resolve(ref);
                                                            if (null == ctr) {
                                                                l.warn("no container found to create export document. " + ref);
                                                                break block54;
                                                            } else {
                                                                this.log.info("build ExportReference ctr=" + ctr.getUid() + ", ctr.version=" + ctr.getVersionInfo().getVersionNumber() + ", ctr.revision=" + ctr.getRevision() + ", old.version=" + (item2.getOldEntity() != null ? Integer.valueOf(item2.getOldEntity().getVersionInfo().getVersionNumber()) : "(null)") + ", old.revision=" + (item2.getOldEntity() != null ? item2.getOldEntity().getRevision() : "(null)"));
                                                                ExportDocumentsHelper.createExportDocuments(ctr, item2.getOldEntity(), null, null, false, false);
                                                            }
                                                            break block54;
                                                        }
                                                        if (null == item2.getOldEntity()) {
                                                            l.warn("no container found to create export document. " + ref);
                                                        } else {
                                                            this.log.info("build delete ExportReference ref=" + ref.getUid());
                                                            ExportDocumentsHelper.createExportDocuments(item2.getOldEntity(), item2.getOldEntity(), null, null, true, false);
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        l.error("an error has occurred while create export document. " + ref, (Throwable)e);
                                                        Metrics.get().timingAndEvent("profiling.export.build-export-documents.build.fail", timing);
                                                    }
                                                }
                                                AssetsStorage.get().delete((BaseAsset)item2);
                                                Metrics.get().timingAndEvent("profiling.export.build-export-documents.build.processed", buildTiming);
                                            }
                                            finally {
                                                lock.unlock();
                                            }
                                        }
                                        l.debug("export document created successfully. " + ref);
                                        return;
                                    }
                                    finally {
                                        Metrics.get().timingAndEvent("profiling.export.build-export-documents.build.all", buildTiming);
                                    }
                                }
                                catch (Throwable t) {
                                    l.error("an unexpected error has occurred while create export document. " + ref, t);
                                    Metrics.get().timingAndEvent("profiling.export.build-export-documents.build.fail", timing);
                                    return;
                                }
                                finally {
                                    barrier.countDown();
                                }
                            });
                        }
                        if (barrier.await(5L, TimeUnit.MINUTES)) return;
                        Metrics.get().timingAndEvent("profiling.export.build-export-documents.process.wait", timing);
                        return;
                    }
                    finally {
                        executor.dispose();
                        Metrics.get().timingAndEvent("profiling.export.build-export-documents.process.data", timing);
                    }
                }
                finally {
                    Metrics.get().timingAndEvent("profiling.export.build-export-documents.process.all", timing);
                }
            }
            finally {
                RUNNING.set(false);
            }
        }
        catch (InterruptedException e) {
            this.log.warn("build export document task interrupted", (Throwable)e);
            Metrics.get().event("profiling.export.build-export-documents.process.fatal");
            return;
        }
        catch (Throwable t) {
            this.log.error("an unexpected error has occurred", t);
            Metrics.get().event("profiling.export.build-export-documents.process.fatal");
        }
    }
}

