/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.service;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BasicCommonExportSettingsIndex;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndex;
import com.gridnine.xtrip.common.model.export.ExportStatus;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class DeleteExportDocumentTask
extends BaseScheduledTask {
    private int defaultRetentionPeriodInHours;

    public void configure(Properties config) throws Exception {
        this.defaultRetentionPeriodInHours = this.getParameter("defaultRetentionPeriodInHours", 48);
    }

    protected void doJob() throws Exception {
        ArrayList<SearchCriterion> others = new ArrayList<SearchCriterion>();
        for (BasicCommonExportSettingsIndex index : EntityStorage.get().search(BasicCommonExportSettingsIndex.class, new SearchQuery()).getData()) {
            int retentionPeriodInHours = (Integer)MiscUtil.guarded((Object)index.getRetentionPeriodInHours(), (Object)this.defaultRetentionPeriodInHours);
            this.process(retentionPeriodInHours, SearchCriterion.eq((String)ExportDocumentIndex.Property.commonSettings.name(), (Object)index.getSource()));
            others.add(SearchCriterion.ne((String)ExportDocumentIndex.Property.commonSettings.name(), (Object)index.getSource()));
        }
        this.process(this.defaultRetentionPeriodInHours, SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ExportDocumentIndex.Property.commonSettings.name(), null), SearchCriterion.and((SearchCriterion[])others.toArray(new SearchCriterion[others.size()]))}));
    }

    private void process(int retentionPeriodInHours, SearchCriterion ... criterions) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().addAll(Arrays.asList(criterions));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)ExportDocumentIndex.Property.createDate.name(), (Object)new Date(new Date().getTime() - (long)retentionPeriodInHours * 3600L * 1000L)));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ExportDocumentIndex.Property.status.name(), (Object)ExportStatus.UNPROCESSED));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ExportDocumentIndex.Property.status.name(), (Object)ExportStatus.ERROR));
        query.getPreferredProperties().add(ExportDocumentIndex.Property.createDate.name());
        List data = EntityStorage.get().search(ExportDocumentIndex.class, query).getData();
        this.log.debug(String.format("got %s documents to delete", Integer.toString(data.size())));
        for (ExportDocumentIndex idx : data) {
            this.log.debug("deleting " + idx.getSource());
            try {
                EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
                EntityStorage.get().delete(ctr);
            }
            catch (Exception e) {
                this.log.error("unable to delete " + idx.getSource(), (Throwable)e);
            }
        }
    }
}

