/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.service;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.server.Service;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportDocumentsExecutor
implements Service {
    private static final Logger log = LoggerFactory.getLogger(ExportDocumentsExecutor.class);
    public static final String UID = "export-documents-executor";
    private volatile int threadCount = 0;
    private volatile ExecutorService executor = null;
    private final Map<Runnable, NamedLock> tasks = new ConcurrentHashMap<Runnable, NamedLock>();
    private static final AtomicInteger executorAge = new AtomicInteger(0);

    public String getUid() {
        return UID;
    }

    public void configure(ExtendedProperties config) throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        ExecutorService old = this.executor;
        this.replaceExecutor(null);
        if (old != null) {
            while (!old.awaitTermination(5L, TimeUnit.MINUTES)) {
            }
        }
    }

    private void replaceExecutor(ExecutorService newExecutor) {
        ExecutorService toStop = this.executor;
        this.executor = newExecutor;
        if (toStop == null) {
            return;
        }
        List<Runnable> rejectedList = toStop.shutdownNow();
        for (Runnable rejected : rejectedList) {
            try {
                NamedLock lock = this.tasks.remove(((Runner)rejected).getTask());
                Throwable throwable = null;
                try {
                    lock.unlock();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lock == null) continue;
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    lock.close();
                }
            }
            catch (Throwable t) {
                log.error("an unexpected error has occurred while process rejected tasks: " + t.getMessage(), t);
            }
        }
    }

    public void setThreadCount(int threadCount) {
        if (this.threadCount == threadCount) {
            return;
        }
        final int age = executorAge.incrementAndGet();
        ExecutorService newExecutor = Executors.newFixedThreadPool(threadCount, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("doc-export-service-%d-%d", age, this.counter.incrementAndGet()));
            }
        });
        this.replaceExecutor(newExecutor);
        this.threadCount = threadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(EntityReference<?> group, Runnable task) throws Exception {
        if (this.executor == null) {
            return false;
        }
        NamedLock lock = LockUtil.getLockManager().getLock((Object)String.format("CLASS:%s,UID:%s,TAG:%s", group.getType().getName(), group.getUid(), "export-documents"));
        boolean lockCaptured = false;
        try {
            lockCaptured = lock.tryLock();
            if (!lockCaptured) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (!lockCaptured) {
                lock.close();
            }
        }
        try {
            this.tasks.put(task, lock);
            this.executor.execute(new Runner(task));
        }
        catch (Throwable t) {
            this.tasks.remove(task);
            try {
                lock.unlock();
            }
            finally {
                lock.close();
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        return true;
    }

    private class Runner
    implements Runnable {
        private final Runnable task;

        public Runner(Runnable task) {
            this.task = task;
        }

        public Runnable getTask() {
            return this.task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.task.run();
            }
            finally {
                NamedLock lock = (NamedLock)ExportDocumentsExecutor.this.tasks.remove(this.task);
                try {
                    try {
                        lock.unlock();
                    }
                    catch (Exception e) {
                        log.error("error while unlock lock: " + e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    try {
                        lock.close();
                    }
                    catch (Exception e) {
                        log.error("error while close lock: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

