/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.service;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.helper.SearchHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.ExportReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.BasicExportSettingsIndex;
import com.gridnine.xtrip.common.model.export.EntityCompressedData;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndex;
import com.gridnine.xtrip.common.model.export.ExportErrorCategory;
import com.gridnine.xtrip.common.model.export.ExportStatus;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.HasDraftState;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.IntegrationBusAdapter;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.export.AutoCreateExportHandler;
import com.gridnine.xtrip.server.model.export.CustomRootEntityExportHandler;
import com.gridnine.xtrip.server.model.export.ExportHandler;
import com.gridnine.xtrip.server.model.export.RootEntityExportHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.ibus.export.IBusExportContextKeys;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportDocumentsHelper {
    protected static final Logger log = LoggerFactory.getLogger(ExportDocumentsHelper.class);
    private static final String EXPORT_AUDIT_MESSAGE_ENABLED_PROPERTY_NAME = "export.audit.message.enabled";
    private static final String BUILD_APP_ID = "build-app-id: ";
    public static final String TAG = "create-export-documents";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryLock(EntityReference<ExportDocument> documentRef) {
        boolean bl;
        LockManager lockManager = LockUtil.getLockManager();
        NamedLock lock = lockManager.getLock((Object)ExportDocumentsHelper.getLockID(documentRef), 60000L);
        try {
            bl = lock.tryLock();
        }
        catch (Throwable throwable) {
            try {
                lock.close();
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        lock.close();
        return bl;
    }

    private static void releaseLock(EntityReference<ExportDocument> documentRef) {
        try {
            LockManager lockManager = LockUtil.getLockManager();
            try (NamedLock lock = lockManager.getLock((Object)ExportDocumentsHelper.getLockID(documentRef), 60000L);){
                lock.unlock();
            }
        }
        catch (Exception e) {
            log.error("unable to release lock " + documentRef, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public static void processDocuments(Collection<EntityReference<ExportDocument>> documents, Collection<Message> externalMessages, boolean force) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void skipByTimeout(EntityContainer<ExportDocument> ctr, List<Message> messages) {
        try {
            ((ExportDocument)ctr.getEntity()).getMessages().clear();
            ((ExportDocument)ctr.getEntity()).setStatus(ExportStatus.ERROR);
            ((ExportDocument)ctr.getEntity()).setErrorCategory(ExportErrorCategory.COMMUNICATION_ERROR);
            ((ExportDocument)ctr.getEntity()).setResponse(null);
            ((ExportDocument)ctr.getEntity()).setLastCommunicationDate(new Date());
            ((ExportDocument)ctr.getEntity()).getMessages().addAll(messages);
            ((ExportDocument)ctr.getEntity()).setMayBeReExported(true);
            ctr.getVersionInfo().setDataSource("export-documents");
            ctr.getVersionInfo().setVersionNotes("skip by timeout");
            EntityStorage.get().save(ctr, false);
        }
        catch (Exception e2) {
            log.error("unable to save document " + ctr, (Throwable)e2);
        }
    }

    private static void addMessage(List<Message> messages, Message message) {
        messages.remove(message);
        messages.add(message);
    }

    public static Set<MessageType> getMessageTypes(List<Message> messages) {
        HashSet<MessageType> result = new HashSet<MessageType>();
        for (Message msg : messages) {
            result.add(msg.getType());
        }
        return result;
    }

    private static String getLockID(EntityReference<ExportDocument> documentRef) {
        return String.format("%s.%s", "process-export-document-lock", documentRef.getUid());
    }

    private ExportDocumentsHelper() {
    }

    public static <E extends BaseEntity> void registerExportDocuments(EntityContainer<E> ctr, EntityContainer<E> oldCtr, SessionCallback ss, boolean deleted, boolean forceExport) {
        block14: {
            try {
                if (!deleted && Boolean.parseBoolean(System.getProperty("midoffice.export.create-documents-on-save", "false"))) {
                    ExportDocumentsHelper.createExportDocuments(ctr, oldCtr, ss, null, deleted, false);
                    return;
                }
                if (null == ctr || ExportDocument.class.isAssignableFrom(ctr.getEntityType())) {
                    return;
                }
                if (!forceExport) {
                    boolean hasExportSettings = false;
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicExportSettingsIndex.Property.createDocuments.name(), (Object)Boolean.TRUE));
                    for (BasicExportSettingsIndex idx : EntityStorage.get().search(BasicExportSettingsIndex.class, query).getData()) {
                        RootEntityExportHandler rootEntityExportHandler;
                        EntityReference settingsRef = idx.getSource();
                        EntityContainer settingsCtr = EntityStorage.get().resolve(settingsRef);
                        if (settingsCtr == null) {
                            log.warn("unable to load " + idx.getSource());
                            continue;
                        }
                        if (settingsRef.getType().getName().equals("com.gridnine.xtrip.common.model.export.IBEBookingXmlExportSettings") && !AppConfiguration.get().isIbeEnabled()) {
                            log.debug("unable to load " + idx.getSource());
                            continue;
                        }
                        if (settingsRef.getType().getName().equals("com.gridnine.xtrip.common.model.export.ens.ENSExportSettings") && !AppConfiguration.get().isOnlineGdsEnabled()) {
                            log.debug("unable to load " + idx.getSource());
                            continue;
                        }
                        ExportHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findExportHandlerBySettings(settingsRef.getType());
                        if (handler == null) {
                            log.warn("unable to find export handler for " + settingsRef);
                            continue;
                        }
                        if (deleted && (!(handler instanceof RootEntityExportHandler) || !((RootEntityExportHandler)handler).isExportDeletedObjects((BaseExportSettings)settingsCtr.getEntity())) || handler instanceof AutoCreateExportHandler && !((AutoCreateExportHandler)((Object)handler)).isAutoCreate((BaseExportSettings)settingsCtr.getEntity())) continue;
                        if (handler instanceof CustomRootEntityExportHandler) {
                            CustomRootEntityExportHandler ceh = (CustomRootEntityExportHandler)handler;
                            if (!ceh.getEntityType().equals(ctr.getEntityType()) || !ceh.accept(ctr.getEntity(), (BaseExportSettings)settingsCtr.getEntity())) continue;
                            hasExportSettings = true;
                            break;
                        }
                        if (!(handler instanceof RootEntityExportHandler) || !(rootEntityExportHandler = (RootEntityExportHandler)handler).getEntityType().isAssignableFrom(ctr.getEntityType()) || !rootEntityExportHandler.accept(ctr.getEntity(), (BaseExportSettings)settingsCtr.getEntity())) continue;
                        hasExportSettings = true;
                        break;
                    }
                    if (!hasExportSettings) {
                        String messageEnabledProperty;
                        boolean messageEnabled;
                        if ((ctr.getEntityType().isAssignableFrom(BookingFile.class) || ctr.getEntityType().isAssignableFrom(Shipment.class)) && (messageEnabled = Boolean.parseBoolean((messageEnabledProperty = ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty(EXPORT_AUDIT_MESSAGE_ENABLED_PROPERTY_NAME, "false")).trim()))) {
                            SysLogHelper.audit(ctr.toReference(), "register-to-export", MessageHelper.createMessage((String)Messages.ExportDocumentsHelper_noExportSettings, (Object[])new Object[0]));
                        }
                        return;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("register-to-export %s %s, login = %s, version = %s, revision = %s, thread = %s, stacktrace =\n %s", MiscUtil.getSimpleClassName((Class)ctr.getEntityType()), ctr.getUid(), UserData.get().getCurrentUser(), ctr.getVersionInfo().getVersionNumber(), ctr.getRevision(), Thread.currentThread().getName(), DebugUtil.getStackTrace()));
                }
                SysLogHelper.audit(ctr.toReference(), "register-to-export", MessageHelper.createMessage((String)Messages.ExportDocumentsHelper_register, (Object[])new Object[0]));
                ExportReference ref = new ExportReference();
                ref.setRef(ctr.toReference());
                ref.setOldEntity(deleted ? ctr : oldCtr);
                ref.setDeleted(deleted);
                AssetsStorage.get().save((BaseAsset)ref);
            }
            catch (Throwable t) {
                log.error("unable to register export document", t);
                if (ctr == null) break block14;
                SysLogHelper.audit(ctr.toReference(), "register-to-export", MessageHelper.createExceptonMessage((String)Messages.ExportDocumentsHelper_cantRegister, (Throwable)t, (Object[])new Object[0]));
            }
        }
    }

    public static <E extends BaseEntity> void createExportDocuments(EntityContainer<E> ctr, boolean deleted, EntityContainer<E> oldCtr) throws Exception {
        ExportDocumentsHelper.createExportDocuments(ctr, oldCtr, null, null, deleted, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E extends BaseEntity> void createExportDocuments(EntityContainer<E> ctr, EntityContainer<E> oldCtr, SessionCallback ss, Collection<EntityReference<BaseExportSettings>> exportSettings, boolean deleted, boolean forceCreate) throws Exception {
        if (!deleted && HasDraftState.class.isAssignableFrom(ctr.getEntityType()) && ((HasDraftState)ctr.getEntity()).isDraftState()) {
            String messageEnabledProperty = ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty(EXPORT_AUDIT_MESSAGE_ENABLED_PROPERTY_NAME, "false");
            boolean messageEnabled = Boolean.parseBoolean(messageEnabledProperty.trim());
            if (messageEnabled) {
                SysLogHelper.audit(ctr.toReference(), TAG, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u044a\u0435\u043a\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u043b\u0441\u044f \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f, \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u044b", (Object[])new Object[0]));
            }
            log.info("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u043b\u0441\u044f \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f, \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u044b: " + ctr.getEntity().toString() + "/" + ctr.getUid() + "/" + ctr.getEntityType().getName());
            return;
        }
        ArrayList<ExportDocument> failExportDocuments = new ArrayList<ExportDocument>();
        boolean hasExportDocument = false;
        boolean hasSkippedExportDocument = false;
        ArrayList<String> toExport = new ArrayList<String>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicExportSettingsIndex.Property.createDocuments.name(), (Object)Boolean.TRUE));
        for (BasicExportSettingsIndex idx : EntityStorage.get().search(BasicExportSettingsIndex.class, query).getData()) {
            byte[] content;
            LinkedList<Message> messages;
            EntityReference lockRef;
            ExportDocument originalDoc;
            EntityContainer originalDocCtr;
            EntityContainer settingsCtr;
            block35: {
                RootEntityExportHandler rootEntityExportHandler;
                EntityReference settingsRef = idx.getSource();
                if (exportSettings != null && !exportSettings.isEmpty() && !exportSettings.contains(settingsRef)) continue;
                settingsCtr = EntityStorage.get().resolve(settingsRef);
                if (settingsCtr == null) {
                    log.warn("unable to load " + idx.getSource());
                    continue;
                }
                if (settingsRef.getType().getName().equals("com.gridnine.xtrip.common.model.export.IBEBookingXmlExportSettings") && !AppConfiguration.get().isIbeEnabled()) {
                    log.debug("unable to load " + idx.getSource());
                    continue;
                }
                if (settingsRef.getType().getName().equals("com.gridnine.xtrip.common.model.export.ens.ENSExportSettings") && !AppConfiguration.get().isOnlineGdsEnabled()) {
                    log.debug("unable to load " + idx.getSource());
                    continue;
                }
                ExportHandler handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findExportHandlerBySettings(settingsRef.getType());
                if (handler == null) {
                    log.warn("unable to find export handler for " + settingsRef);
                    continue;
                }
                if (!forceCreate && handler instanceof AutoCreateExportHandler && !((AutoCreateExportHandler)((Object)handler)).isAutoCreate((BaseExportSettings)settingsCtr.getEntity())) continue;
                if (handler instanceof CustomRootEntityExportHandler) {
                    CustomRootEntityExportHandler ceh = (CustomRootEntityExportHandler)handler;
                    if (!ceh.getEntityType().equals(ctr.getEntityType()) || !ceh.accept(ctr.getEntity(), (BaseExportSettings)settingsCtr.getEntity())) continue;
                    try {
                        boolean created = ceh.createExportDocuments(ctr, oldCtr, (BaseExportSettings)settingsCtr.getEntity(), new ArrayList<Message>());
                        if (created) {
                            hasExportDocument = true;
                        } else {
                            hasSkippedExportDocument = true;
                        }
                    }
                    catch (Exception e) {
                        ExportDocument doc = new ExportDocument();
                        doc.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b", (Throwable)e, (Object[])new Object[0]));
                        hasExportDocument = true;
                        failExportDocuments.add(doc);
                    }
                }
                if (!(handler instanceof RootEntityExportHandler) || !(rootEntityExportHandler = (RootEntityExportHandler)handler).getEntityType().isAssignableFrom(ctr.getEntityType()) || !rootEntityExportHandler.accept(ctr.getEntity(), (BaseExportSettings)settingsCtr.getEntity())) continue;
                originalDocCtr = null;
                originalDoc = null;
                lockRef = null;
                try {
                    boolean hasExportPeriod;
                    boolean bl = hasExportPeriod = ((BaseExportSettings)settingsCtr.getEntity()).getExportPeriod() != null || ((BaseExportSettings)settingsCtr.getEntity()).getExportTime() != null;
                    if (hasExportPeriod) {
                        for (ExportDocumentIndex index : SearchHelper.searchEntity(ExportDocumentIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ExportDocumentIndex.Property.object.name(), (Object)ctr.toReference()), SearchCriterion.eq((String)ExportDocumentIndex.Property.status.name(), (Object)ExportStatus.UNPROCESSED), SearchCriterion.gt((String)ExportDocumentIndex.Property.exportAfter.name(), (Object)new Date()), SearchCriterion.eq((String)ExportDocumentIndex.Property.exportSettings.name(), (Object)settingsRef)})) {
                            EntityReference ref = index.getSource();
                            EntityContainer doc = EntityStorage.get().resolve(ref);
                            if (!ExportDocumentsHelper.tryLock((EntityReference<ExportDocument>)ref)) continue;
                            lockRef = ref;
                            originalDocCtr = doc;
                            originalDoc = (ExportDocument)doc.getEntity();
                            break;
                        }
                    }
                    if (null == originalDoc) {
                        originalDoc = new ExportDocument();
                        originalDocCtr = EntityContainer.create((BaseEntity)originalDoc);
                        if (hasExportPeriod) {
                            LocalDateTime exportAfter;
                            if (((BaseExportSettings)settingsCtr.getEntity()).getExportPeriod() != null) {
                                exportAfter = LocalDateTime.now().plusMinutes(((BaseExportSettings)settingsCtr.getEntity()).getExportPeriod().intValue());
                            } else {
                                if (((BaseExportSettings)settingsCtr.getEntity()).getExportTime() == null) throw new UnsupportedOperationException();
                                LocalDateTime now = LocalDateTime.now();
                                LocalTime time = ((BaseExportSettings)settingsCtr.getEntity()).getExportTime();
                                exportAfter = now.toLocalTime().isAfter(time) ? now.toLocalDate().plusDays(1L).atTime(time) : now.toLocalDate().atTime(time);
                            }
                            originalDoc.setExportAfter(MiscUtil.toDate((LocalDateTime)exportAfter));
                        }
                        originalDoc.setCreateDate(new Date());
                    }
                    originalDoc.setStatus(ExportStatus.UNPROCESSED);
                    originalDoc.setExportSettings(settingsRef);
                    originalDoc.setNewFormat(true);
                    originalDoc.setDeleted(deleted);
                    EntityCompressedData object = new EntityCompressedData();
                    object.setReference(ctr.toReference());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XUtil.serialize(ctr, (OutputStream)baos);
                    object.setContent(GZIPUtil.gzip((byte[])baos.toByteArray()));
                    originalDoc.setObject(object);
                    originalDoc.setDescription(ctr.toReference().toString());
                    messages = new LinkedList<Message>();
                    content = null;
                    try {
                        EntityStorageContext storageContext = EntityStorageHelper.createContext();
                        content = rootEntityExportHandler.createContent(ctr, oldCtr, deleted, settingsCtr, messages, storageContext);
                        if (deleted || oldCtr == null) break block35;
                        byte[] oldContent = null;
                        if (!rootEntityExportHandler.accept(oldCtr.getEntity(), (BaseExportSettings)settingsCtr.getEntity()) || !Arrays.equals(content, oldContent = rootEntityExportHandler.createContent(oldCtr, null, deleted, settingsCtr, new ArrayList<Message>(), storageContext))) break block35;
                        log.info("Export content for new version equals content for old one: skip export, [" + ctr.getUid() + ", " + ctr.getEntityType() + "]");
                        hasSkippedExportDocument = true;
                        if (lockRef == null) continue;
                    }
                    catch (Throwable t) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ExportDocumentsHelper_errorFormatContent, (Throwable)t, (Object[])new Object[0]));
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (lockRef == null) throw throwable;
                    ExportDocumentsHelper.releaseLock(lockRef);
                    throw throwable;
                }
                ExportDocumentsHelper.releaseLock((EntityReference<ExportDocument>)lockRef);
                continue;
            }
            messages.add(0, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(BUILD_APP_ID + Environment.getApplicationId()), (Object[])new Object[0]));
            originalDoc.getMessages().addAll(messages);
            if (content == null || ExportDocumentsHelper.getMessageTypes(messages).contains(MessageType.ERROR)) {
                originalDoc.setStatus(ExportStatus.ERROR);
                originalDoc.setErrorCategory(ExportErrorCategory.CONTENT_ERROR);
            } else {
                originalDoc.setContent(GZIPUtil.gzip((byte[])content));
            }
            try {
                IntegrationBusAdapter adapter = IntegrationBusFacade.get().getRequestReplyAdapter("export:after-create-content");
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put(IBusExportContextKeys.ENTITY_CONTAINER.name(), ctr);
                data.put(IBusExportContextKeys.EXPORT_DOCUMENT.name(), originalDoc);
                adapter.processSync(data);
            }
            catch (Throwable t) {
                log.error("an error has occurred", t);
            }
            toExport.add(((BaseExportSettings)settingsCtr.getEntity()).getName());
            originalDocCtr.getVersionInfo().setDataSource("export-documents");
            originalDocCtr.getVersionInfo().setVersionNotes("create export documents");
            EntityStorage.get().save(originalDocCtr, false);
            if (lockRef != null) {
                ExportDocumentsHelper.releaseLock((EntityReference<ExportDocument>)lockRef);
            }
            hasExportDocument = true;
            if (originalDoc.getStatus() != ExportStatus.ERROR) continue;
            failExportDocuments.add(originalDoc);
        }
        if (hasExportDocument) {
            if (failExportDocuments.size() == 0) {
                ExportDocumentsHelper.addSysLogOK(ctr, toExport, ss);
                return;
            }
            ArrayList<Message> errors = new ArrayList<Message>();
            Iterator iterator = failExportDocuments.iterator();
            block11: while (true) {
                if (!iterator.hasNext()) {
                    ExportDocumentsHelper.addSysLogError(ctr, errors, toExport, ss);
                    return;
                }
                ExportDocument doc = (ExportDocument)iterator.next();
                Iterator iterator2 = doc.getMessages().iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block11;
                    Message msg = (Message)iterator2.next();
                    if (msg.getType() != MessageType.ERROR) continue;
                    errors.add(msg);
                }
                break;
            }
        }
        if (hasSkippedExportDocument) {
            SysLogHelper.audit(ctr.toReference(), TAG, MessageHelper.createMessage((String)Messages.ExportDocumentsHelper_skipExport, (Object[])new Object[0]));
            return;
        }
        SysLogHelper.audit(ctr.toReference(), TAG, MessageHelper.createMessage((String)Messages.ExportDocumentsHelper_noExportSettings, (Object[])new Object[0]));
    }

    public static <E extends BaseEntity> void addSysLogOK(EntityContainer<E> ctr, List<String> toExport, SessionCallback ss) throws Exception {
        EntityReference ref = ctr.toReference();
        SysLogHelper.audit(ref, TAG, SystemHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)"\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b \u0441\u043e\u0437\u0434\u0430\u043d\u044b", (String)("settings: " + TextUtil.join((String)",", toExport) + "\nversion(1..): " + (ctr.getVersionInfo().getVersionNumber() + 1) + "\nrevision: " + ctr.getRevision()), (Object[])new Object[0]));
        ExportDocumentsHelper.updateIndexes(ref, ss);
    }

    public static <E extends BaseEntity> void addSysLogError(EntityContainer<E> ctr, List<Message> errors, List<String> toExport, SessionCallback ss) throws Exception {
        EntityReference ref = ctr.toReference();
        if (errors.size() == 0) {
            SysLogHelper.audit(ref, TAG, SystemHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)"\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", (String)("settings: " + TextUtil.join((String)",", toExport) + "\nversion(1..): " + (ctr.getVersionInfo().getVersionNumber() + 1) + "\nrevision: " + ctr.getRevision()), (Object[])new Object[0]));
        } else {
            String tag = TAG;
            if (errors.size() > 1) {
                tag = tag + "-" + new Date().getTime();
            }
            SysLogHelper.audit(ref, tag, SystemHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0438 \u043e\u0448\u0438\u0431\u043a\u0438", (String)("settings: " + TextUtil.join((String)",", toExport) + "\nversion(1..): " + (ctr.getVersionInfo().getVersionNumber() + 1) + "\nrevision: " + ctr.getRevision()), (Object[])new Object[0]));
            SysLogHelper.audit(ref, tag, errors);
        }
        ExportDocumentsHelper.updateIndexes(ref, ss);
    }

    private static <E extends BaseEntity> void updateIndexes(final EntityReference<E> ref, SessionCallback ss) throws Exception {
        if (!BookingFile.class.isAssignableFrom(ref.getType())) {
            return;
        }
        if (ss != null) {
            ss.addCallback(new Callback(){
                private static final long serialVersionUID = -4033370316853803863L;

                public void execute(SessionCallback ss1) {
                    try {
                        EntityCacheManager.get().check();
                    }
                    catch (Exception e) {
                        log.error("an error has occurred", (Throwable)e);
                    }
                    try {
                        EntityContainer obj = EntityStorage.get().resolve(ref);
                        if (obj != null) {
                            LogicalStorage.get().getEntityStorage().updateIndexes(ss1, obj, obj);
                        }
                    }
                    catch (Exception e) {
                        log.error("unable to rebuild index of " + ref, (Throwable)e);
                    }
                }
            });
        } else {
            LockUtil.lock(ref, (long)5L, (TimeUnit)TimeUnit.MINUTES, () -> {
                EntityCacheManager.get().check();
                EntityContainer obj = EntityStorage.get().resolve(ref);
                if (obj != null) {
                    LogicalStorage.get().getEntityStorage().updateIndexes(obj, obj, false);
                }
            }, () -> {
                throw new TimeoutException("unable to rebuild index of " + ref);
            });
        }
    }

    private static boolean mayBeReExported(Throwable e, List<Message> messages) {
        if (e instanceof SocketTimeoutException) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ExportDocumentsHelper_skipExportDoc, (Throwable)e, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.ExportDocumentsHelper_socketTimeout, (Object[])new Object[0])}));
            return true;
        }
        if (e instanceof NoRouteToHostException) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ExportDocumentsHelper_skipExportDoc, (Throwable)e, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.ExportDocumentsHelper_noRouteToHost, (Object[])new Object[0])}));
            return true;
        }
        if (e instanceof UnknownHostException) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ExportDocumentsHelper_skipExportDoc, (Throwable)e, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.ExportDocumentsHelper_unknownHost, (Object[])new Object[0])}));
            return true;
        }
        if (e instanceof SocketException) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ExportDocumentsHelper_skipExportDoc, (Throwable)e, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.ExportDocumentsHelper_socketException, (Object[])new Object[0])}));
            return true;
        }
        if (e instanceof IOException && StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"No space left")) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ExportDocumentsHelper_skipExportDoc, (Throwable)e, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.ExportDocumentsHelper_noSpaceLeft, (Object[])new Object[0])}));
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$processDocuments$1(String s) {
        return s.contains("settings");
    }

    private static /* synthetic */ String lambda$processDocuments$0(Message m) {
        return m.getMessage().getKey();
    }
}

