/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.service;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.AsyncCommandInfo;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;

public class ProcessAsyncCommandsTask
extends BaseScheduledTask {
    private static final String METRICS_KEY = "profiling.async";
    private static final String PROCESS_KEY = "profiling.async.process";
    private static final String RUN_KEY = "profiling.async.run";
    private int threadCount = 2;
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private static final AtomicBoolean RUNNING = new AtomicBoolean(false);

    public void configure(Properties config) throws Exception {
        this.threadCount = this.getParameter("thread-count", this.getParameter("threadCount", this.threadCount));
        if (this.threadCount < 1) {
            this.threadCount = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doJob() throws Exception {
        if (RUNNING.get()) {
            return;
        }
        try {
            RUNNING.set(true);
            long timing = System.currentTimeMillis();
            try {
                Metrics.get().event("profiling.async.process.heartbeat");
                SearchQuery query = new SearchQuery();
                query.getCriteria().getOrders().put(AsyncCommandInfo.Property.created.name(), SortOrder.ASC);
                query.getPreferredProperties().add(BaseAsset.Property.uid.name());
                List data = AssetsStorage.get().search(AsyncCommandInfo.class, query).getData();
                if (data.size() == 0) {
                    Metrics.get().timingAndEvent("profiling.async.process.no-data", timing);
                    this.log.debug("no refs found");
                    return;
                }
                Metrics.get().value("profiling.async.process.data", (long)data.size());
                ExecutorServiceFacade executor = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool("async", this.threadCount);
                try {
                    String currentUser = LogicalStorage.get().getUser();
                    Locale currentLocale = LocaleManager.get().getCurrentLocale();
                    CountDownLatch barrier = new CountDownLatch(data.size());
                    for (AsyncCommandInfo uidOnlyItem : data) {
                        if (this.isToBeStopped()) {
                            return;
                        }
                        AsyncCommandInfo item = (AsyncCommandInfo)AssetsStorage.get().load(AsyncCommandInfo.class, uidOnlyItem.getUid());
                        Logger l = this.log;
                        executor.submit(() -> {
                            long runStartTime = System.currentTimeMillis();
                            try {
                                if (this.isToBeStopped()) {
                                    return;
                                }
                                try {
                                    LogicalStorage.get().setUser(currentUser);
                                    if (currentLocale != null) {
                                        LocaleManager.get().setCurrentLocale(currentLocale);
                                    }
                                    LockUtil.lock((BaseAsset)item, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS, () -> {
                                        block13: {
                                            AsyncCommandInfo item2 = (AsyncCommandInfo)AssetsStorage.get().load(item.getClass(), item.getUid());
                                            if (null == item2) {
                                                Metrics.get().timingAndEvent("profiling.async.run.not-processed", runStartTime);
                                                Metrics.get().timingAndEvent("profiling.async.run.id." + Metrics.cleanKeyPart((String)this.getId(item)) + ".not-processed", runStartTime);
                                                return;
                                            }
                                            String id = this.getId(item2);
                                            String graphiteId = Metrics.cleanKeyPart((String)id);
                                            if (item2.getModified() != null) {
                                                long latency = System.currentTimeMillis() - item2.getModified().getTime();
                                                Metrics.get().value("profiling.async.run.latency", latency);
                                                Metrics.get().value("profiling.async.run.id." + graphiteId + ".latency", latency);
                                            }
                                            String currentThreadName = Thread.currentThread().getName();
                                            Thread.currentThread().setName(String.format("async-id:[%s]-thread:[%s]-start:[%s]", id, Long.toString(Thread.currentThread().getId()), DATE_FORMAT.format(new Date())));
                                            try {
                                                if (!item2.isLaunched()) {
                                                    boolean fail;
                                                    boolean success;
                                                    block12: {
                                                        success = true;
                                                        fail = false;
                                                        if (item2.getOptions() != null && item2.getOptions().contains(AsyncCommandOption.STRICTLY_SINGLE_RUN)) {
                                                            item2.setLaunched(true);
                                                            AssetsStorage.get().save((BaseAsset)item2);
                                                        }
                                                        byte[] bytes = GZIPUtil.gunzip((byte[])item2.getData());
                                                        AsyncCommand command = (AsyncCommand)MiscUtil.deserialize((byte[])bytes);
                                                        try {
                                                            command.run();
                                                        }
                                                        catch (InterruptedException e) {
                                                            fail = true;
                                                            this.log.warn("execute async command interrupted (" + String.valueOf(item2.getOwner()) + ": " + item2.getUid() + ")", (Throwable)e);
                                                            if (!item2.isLaunched()) {
                                                                success = false;
                                                            }
                                                        }
                                                        catch (Throwable t) {
                                                            fail = true;
                                                            this.log.error("unable to execute async command (" + String.valueOf(item2.getOwner()) + ": " + item2.getUid() + ")", t);
                                                            IncidentsLog.reportException((String)("unable to execute async command (" + String.valueOf(item2.getOwner()) + ": " + item2.getUid() + ")"), (Throwable)t);
                                                            if (item2.getOptions() == null || !item2.getOptions().contains(AsyncCommandOption.RERUN_ON_EXCEPTION) || item2.isLaunched()) break block12;
                                                            success = false;
                                                        }
                                                    }
                                                    if (success) {
                                                        AssetsStorage.get().delete((BaseAsset)item2);
                                                    }
                                                    Metrics.get().timingAndEvent(RUN_KEY + (fail ? ".unhandled" : ".processed"), runStartTime);
                                                    Metrics.get().timingAndEvent("profiling.async.run.id." + graphiteId + (fail ? ".unhandled" : ".processed"), runStartTime);
                                                    break block13;
                                                }
                                                Metrics.get().timingAndEvent("profiling.async.run.not-processed", runStartTime);
                                                Metrics.get().timingAndEvent("profiling.async.run.id." + graphiteId + ".not-processed", runStartTime);
                                            }
                                            finally {
                                                Thread.currentThread().setName(currentThreadName);
                                            }
                                        }
                                    }, () -> {
                                        Metrics.get().timingAndEvent("profiling.async.run.not-processed", runStartTime);
                                        Metrics.get().timingAndEvent("profiling.async.run.id." + Metrics.cleanKeyPart((String)this.getId(item)) + ".not-processed", runStartTime);
                                    });
                                    l.debug("async command executed successfully (" + String.valueOf(item.getOwner()) + ": " + item.getUid() + ")");
                                }
                                finally {
                                    Metrics.get().timingAndEvent("profiling.async.run.all", runStartTime);
                                }
                            }
                            catch (Throwable t) {
                                l.error("an unexpected error has occurred while execute async command (" + String.valueOf(item.getOwner()) + ": " + item.getUid() + ")", t);
                                IncidentsLog.reportException((String)("an unexpected error has occurred while execute async command (" + String.valueOf(item.getOwner()) + ": " + item.getUid() + ")"), (Throwable)t);
                                Metrics.get().timingAndEvent("profiling.async.run.fail", runStartTime);
                                Metrics.get().timingAndEvent("profiling.async.run.id." + Metrics.cleanKeyPart((String)this.getId(item)) + ".fail", runStartTime);
                            }
                            finally {
                                barrier.countDown();
                            }
                        });
                    }
                    while (!barrier.await(30L, TimeUnit.SECONDS)) {
                        Metrics.get().event("profiling.async.process.heartbeat");
                        Metrics.get().timingAndEvent("profiling.async.process.wait", timing);
                    }
                    return;
                }
                finally {
                    executor.dispose();
                    Metrics.get().timingAndEvent("profiling.async.process.data", timing);
                }
            }
            catch (InterruptedException e) {
                Metrics.get().timingAndEvent("profiling.async.process.fail", timing);
                this.log.warn("execute async commands task interrupted", (Throwable)e);
                return;
            }
            catch (Throwable t) {
                Metrics.get().timingAndEvent("profiling.async.process.fail", timing);
                throw t;
            }
            finally {
                Metrics.get().timingAndEvent("profiling.async.process.all", timing);
            }
        }
        finally {
            RUNNING.set(false);
        }
    }

    private String getId(AsyncCommandInfo item) {
        String id = item.getOwner();
        if (TextUtil.isBlank((String)id)) {
            id = "(no name)";
        }
        return id;
    }
}

