/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.service;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndex;
import com.gridnine.xtrip.common.model.export.ExportStatus;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.metrics.Metrics;
import com.gridnine.xtrip.server.model.export.service.ExportDocumentsExecutor;
import com.gridnine.xtrip.server.model.export.service.ExportDocumentsHelper;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class ProcessExportDocumentsTask
extends BaseScheduledTask {
    public static final String METRICS_KEY = "profiling.export.process-export-documents";
    private int threadCount = 1;

    public void configure(Properties config) throws Exception {
        this.threadCount = this.getParameter("thread-\u0441ount", this.getParameter("threadCount", this.threadCount));
    }

    protected void doJob() throws Exception {
        ExportDocumentsExecutor executor = (ExportDocumentsExecutor)((ServerApplication)Environment.getPublished(ServerApplication.class)).getService("export-documents-executor");
        if (executor == null) {
            this.log.warn("executor not published");
            return;
        }
        long timing = System.currentTimeMillis();
        Date now = new Date();
        LinkedHashMap<EntityReference, LinkedList<EntityReference>> documents = new LinkedHashMap<EntityReference, LinkedList<EntityReference>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ExportDocumentIndex.Property.exportSettings.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExportDocumentIndex.Property.status.name(), (Object)ExportStatus.UNPROCESSED));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ExportDocumentIndex.Property.exportAfter.name(), null), SearchCriterion.le((String)ExportDocumentIndex.Property.exportAfter.name(), (Object)now)}));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)ExportDocumentIndex.Property.createDate.name(), (Object)new Date(new Date().getTime() - TimeUnit.SECONDS.toMillis(30L))));
        query.getCriteria().getOrders().put(ExportDocumentIndex.Property.createDate.name(), SortOrder.ASC);
        query.getPreferredProperties().add(ExportDocumentIndex.Property.exportSettings.name());
        for (ExportDocumentIndex item : EntityStorage.get().search(ExportDocumentIndex.class, query).getData()) {
            EntityReference exportSettings = item.getExportSettings();
            LinkedList<EntityReference> docs = (LinkedList<EntityReference>)documents.get(exportSettings);
            if (docs == null) {
                docs = new LinkedList<EntityReference>();
                documents.put(exportSettings, docs);
            }
            docs.add(item.getSource());
        }
        if (documents.isEmpty()) {
            Metrics.get().timingAndEvent("profiling.export.process-export-documents.no-data", timing);
            return;
        }
        executor.setThreadCount(this.threadCount);
        int count = 0;
        for (Map.Entry entry : documents.entrySet()) {
            int size = ((List)entry.getValue()).size();
            count += size;
            EntityReference ref = (EntityReference)entry.getKey();
            EntityContainer exportSettings = EntityStorage.get().resolve(ref);
            if (null == exportSettings || !((BaseExportSettings)exportSettings.getEntity()).isSendData()) {
                Metrics.get().value("profiling.export.process-export-documents.group." + Metrics.key((String[])new String[]{exportSettings != null ? ((BaseExportSettings)exportSettings.getEntity()).getName() : (ref != null ? ref.toString() : null)}) + ".idle", (long)size);
                continue;
            }
            Metrics.get().value("profiling.export.process-export-documents.group." + Metrics.key((String[])new String[]{((BaseExportSettings)exportSettings.getEntity()).getName()}) + ".data", (long)size);
        }
        Metrics.get().timingAndEvent("profiling.export.process-export-documents.data", timing);
        Metrics.get().value("profiling.export.process-export-documents.data", (long)count);
        for (Map.Entry entry : documents.entrySet()) {
            EntityContainer exportSettings = EntityStorage.get().resolve((EntityReference)entry.getKey());
            if (null == exportSettings || !((BaseExportSettings)exportSettings.getEntity()).isSendData()) continue;
            long timing2 = System.currentTimeMillis();
            if (executor.execute((EntityReference)entry.getKey(), () -> {
                long timing3 = System.currentTimeMillis();
                try {
                    if (!((List)entry.getValue()).isEmpty()) {
                        this.log.info(String.format("Start processing %d documents for %s", ((List)entry.getValue()).size(), ((BaseExportSettings)exportSettings.getEntity()).getName()));
                    }
                    LogicalStorage.get().authorizeAsSystem();
                    Metrics.get().timingAndEvent("profiling.export.process-export-documents.group." + Metrics.key((String[])new String[]{((BaseExportSettings)exportSettings.getEntity()).getName()}) + ".latency", timing2);
                    ExportDocumentsHelper.processDocuments((Collection)entry.getValue(), null, false);
                    Metrics.get().timingAndEvent("profiling.export.process-export-documents.group." + Metrics.key((String[])new String[]{((BaseExportSettings)exportSettings.getEntity()).getName()}) + ".processed", timing3);
                    Metrics.get().timing("profiling.export.process-export-documents.group." + Metrics.key((String[])new String[]{((BaseExportSettings)exportSettings.getEntity()).getName()}) + ".one-avg", timing3 / (long)((List)entry.getValue()).size());
                    if (!((List)entry.getValue()).isEmpty()) {
                        this.log.info(String.format("Finished processing %d documents for %s", ((List)entry.getValue()).size(), ((BaseExportSettings)exportSettings.getEntity()).getName()));
                    }
                }
                catch (Throwable t) {
                    Metrics.get().timingAndEvent("profiling.export.process-export-documents.group." + Metrics.key((String[])new String[]{((BaseExportSettings)exportSettings.getEntity()).getName()}) + ".process-failed." + ProcessExportDocumentsTask.getLabel(MiscUtil.getSimpleClassName(t.getClass())) + (!TextUtil.isBlank((String)t.getMessage()) ? " - " + Metrics.key((String[])new String[]{t.getMessage().toLowerCase()}) + "!" : ""), timing3);
                    this.log.error("unable to export items", t);
                }
            })) continue;
            this.log.warn(String.format("pack of documents skipped, export settings %s, uid %s", String.valueOf(((EntityReference)entry.getKey()).getCaption()), ((EntityReference)entry.getKey()).getUid()));
        }
    }

    private static String getLabel(String camel) {
        StringBuilder sb = new StringBuilder();
        int l = 0;
        for (int i = 0; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0 && (l > 0 || 0 == l && i + 1 < camel.length() && Character.isLowerCase(camel.charAt(i + 1)))) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                l = 0;
                continue;
            }
            sb.append(c);
            ++l;
        }
        return sb.toString();
    }
}

