/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.service;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndex;
import com.gridnine.xtrip.common.model.export.ExportStatus;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.BaseScheduledTask;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;

public class ReExportDocumentTask
extends BaseScheduledTask {
    private int cutOff = 120;

    public void configure(Properties config) throws Exception {
        this.cutOff = this.getParameter("cut-off", this.cutOff);
    }

    protected void doJob() throws Exception {
        SearchQuery query = new SearchQuery();
        Calendar cutOffDate = Calendar.getInstance();
        cutOffDate.add(12, -this.cutOff);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExportDocumentIndex.Property.mayBeReExported.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExportDocumentIndex.Property.status.name(), (Object)ExportStatus.ERROR));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ExportDocumentIndex.Property.lastCommunicationDate.name(), null), SearchCriterion.gt((String)ExportDocumentIndex.Property.createDate.name(), (Object)cutOffDate.getTime())}));
        query.getPreferredProperties().add(ExportDocumentIndex.Property.createDate.name());
        List data = EntityStorage.get().search(ExportDocumentIndex.class, query).getData();
        this.log.debug(String.format("got %s documents to re-export", Integer.toString(data.size())));
        for (ExportDocumentIndex idx : data) {
            this.log.debug("re-export " + idx.getSource());
            try {
                EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
                if (null == ctr) {
                    this.log.error("unable to load export document " + idx.getSource() + " (" + idx.getSource().getUid() + ") for clear status, idx " + idx.getUid());
                    continue;
                }
                ((ExportDocument)ctr.getEntity()).setStatus(ExportStatus.UNPROCESSED);
                ((ExportDocument)ctr.getEntity()).setMayBeReExported(false);
                ctr.getVersionInfo().setVersionNotes("change error status to unprocessed");
                ctr.getVersionInfo().setDataSource("re-export-document-task");
                EntityStorage.get().save(ctr, false);
            }
            catch (Exception e) {
                this.log.error("unable to clear export status " + idx.getSource() + " (" + idx.getSource().getUid() + ")", (Throwable)e);
            }
        }
    }
}

