/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.service;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndex;
import com.gridnine.xtrip.common.model.export.ExportStatus;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import java.util.List;
import java.util.Objects;

public class SmartCleaningExportErrorsTask
extends BaseScheduledTask {
    private static final EntityStorageSearchParameters SLAVE_SEARCH_PARAMS = (EntityStorageSearchParameters)new EntityStorageSearchParameters().context("irrelevance-tolerant-query", (Object)Boolean.TRUE);
    private static final EntityStorageLoadParameters SLAVE_LOAD_PARAMS = (EntityStorageLoadParameters)new EntityStorageLoadParameters().context("irrelevance-tolerant-query", (Object)Boolean.TRUE);

    protected void doJob() throws Exception {
        SearchQuery errorQuery = new SearchQuery();
        errorQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExportDocumentIndex.Property.status.name(), (Object)ExportStatus.ERROR));
        errorQuery.getPreferredProperties().add(ExportDocumentIndex.Property.lastCommunicationDate.name());
        errorQuery.getPreferredProperties().add(ExportDocumentIndex.Property.createDate.name());
        errorQuery.getPreferredProperties().add(ExportDocumentIndex.Property.object.name());
        errorQuery.getPreferredProperties().add(ExportDocumentIndex.Property.exportSettings.name());
        List errorData = EntityStorage.get().search(ExportDocumentIndex.class, errorQuery, SLAVE_SEARCH_PARAMS).getData();
        this.log.debug(String.format("got %s error documents", Integer.toString(errorData.size())));
        if (errorData.size() == 0) {
            return;
        }
        SearchQuery okQuery = new SearchQuery();
        okQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExportDocumentIndex.Property.status.name(), (Object)ExportStatus.OK));
        okQuery.getPreferredProperties().add(ExportDocumentIndex.Property.lastCommunicationDate.name());
        okQuery.getPreferredProperties().add(ExportDocumentIndex.Property.object.name());
        okQuery.getPreferredProperties().add(ExportDocumentIndex.Property.exportSettings.name());
        List okData = EntityStorage.get().search(ExportDocumentIndex.class, okQuery).getData();
        this.log.debug(String.format("got %s ok documents", Integer.toString(okData.size())));
        for (ExportDocumentIndex errorIndex : errorData) {
            boolean found = false;
            for (ExportDocumentIndex okIndex : okData) {
                if (okIndex.getObject() == null || errorIndex == null || !Objects.equals(okIndex.getExportSettings(), errorIndex.getExportSettings()) || !MiscUtil.equals((Object)okIndex.getObject(), (Object)errorIndex.getObject()) || okIndex.getLastCommunicationDate() == null || errorIndex.getLastCommunicationDate() == null && errorIndex.getCreateDate() == null || !okIndex.getLastCommunicationDate().after(errorIndex.getLastCommunicationDate() != null ? errorIndex.getLastCommunicationDate() : errorIndex.getCreateDate())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            this.log.debug("deleting " + errorIndex.getSource());
            try {
                EntityContainer ctr = EntityStorage.get().resolve(errorIndex.getSource(), SLAVE_LOAD_PARAMS);
                if (ctr == null) continue;
                EntityStorage.get().delete(ctr);
            }
            catch (Exception e) {
                this.log.error("unable to delete " + errorIndex.getSource(), (Throwable)e);
            }
        }
    }
}

