/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingCommunicationExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ClientExport;
import com.gridnine.xtrip.common.model.export.booking.v2.CustomerContactDetailsExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ExternalSystemCode;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BookingExportFillHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BookingFileExport exportedObject = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingFile booking = (BookingFile)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE);
        Boolean deleted = (Boolean)ctx.getMandatoryObject(IBusBookingContextKeys.BOOKING_FILE_DELETED.name());
        exportedObject.setBookingNumber(booking.getNumber());
        exportedObject.setWorkflowStatus(MetadataBasedExportHelper.convertEnum(booking.getWorkflowStatus()));
        exportedObject.setDeleted(deleted);
        if (booking.getCustomerProfile() != null) {
            EntityReference customerRef = booking.getCustomerProfile();
            EntityContainer container = EntityStorage.get().resolve(customerRef);
            if (container != null && container.getEntity() != null) {
                Organization customerProfile = (Organization)container.getEntity();
                ClientExport clientExport = new ClientExport();
                exportedObject.setClient(clientExport);
                clientExport.setCode(customerProfile.getCode());
                clientExport.setKpp(customerProfile.getKpp());
                MetadataBasedExportHelper.convertL10nStringCollection(clientExport.getNames(), customerProfile.getFullName());
                clientExport.setInn(customerProfile.getRegistrationId());
                clientExport.setBeneficiaryCode(customerProfile.getBeneficiaryCode() != null ? customerProfile.getBeneficiaryCode().toString() : null);
            }
        }
        List<CommunicationType> communicationTypes = Arrays.asList(CommunicationType.EMAIL, CommunicationType.CELL, CommunicationType.MOBILE, CommunicationType.WORK_PHONE);
        Customer customer = booking.getCustomer();
        if (customer != null) {
            EntityContainer person;
            CustomerContactDetailsExport contactDetailsExport = new CustomerContactDetailsExport();
            contactDetailsExport.setContactName(customer.getName());
            ArrayList<String> emails = new ArrayList<String>();
            for (Communication communication : customer.getCommunications()) {
                if (!communicationTypes.contains(communication.getType()) || TextUtil.isBlank((String)communication.getSense())) continue;
                if (CommunicationType.EMAIL == communication.getType()) {
                    emails.add(communication.getSense());
                    continue;
                }
                BookingCommunicationExport communicationExport = new BookingCommunicationExport();
                communicationExport.setType(MetadataBasedExportHelper.convertEnum(communication.getType()));
                communicationExport.setSense(communication.getSense());
                communicationExport.setCountryCode(communication.getCountryCode());
                communicationExport.setCityCode(communication.getCityCode());
                communicationExport.setInternalNumber(communication.getInternalNumber());
                contactDetailsExport.getPhoneNumbers().add(communicationExport);
            }
            MetadataBasedExportHelper.convertStringCollection(contactDetailsExport.getEmails(), emails);
            if (customer.getProfile() != null && (person = EntityStorage.get().resolve(customer.getProfile())) != null) {
                contactDetailsExport.setContactProfileUid(person.getUid());
            }
            exportedObject.setCustomerContactDetails(contactDetailsExport);
        }
        exportedObject.getExternalSystemCodes().addAll(booking.getExternalCodes().stream().map(code -> {
            ExternalSystemCode exportCode = new ExternalSystemCode();
            exportCode.setSystem(code.getSystem().getCode());
            exportCode.setCode(code.getCode());
            return exportCode;
        }).collect(Collectors.toList()));
    }
}

