/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.export.ExportMetadataProvider;
import com.gridnine.xtrip.common.meta.export.ExportedEntityType;
import com.gridnine.xtrip.common.meta.export.ExportedObjectsMetadataHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingExportRestrictionType;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.DictionaryCompressedData;
import com.gridnine.xtrip.common.model.export.ElementExportSettings;
import com.gridnine.xtrip.common.model.export.EntityCompressedData;
import com.gridnine.xtrip.common.model.export.ExportCategory;
import com.gridnine.xtrip.common.model.export.booking.v2.AdditionalServiceProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AeroexpressTicketExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AgencyMemoProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AgentTouchExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.CarRentalProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.DeliveryExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelExport;
import com.gridnine.xtrip.common.model.export.booking.v2.InsuranceAccidentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.InsuranceTouristicExport;
import com.gridnine.xtrip.common.model.export.booking.v2.MCOFeesExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ProductVoidingExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayCrimeaMcoExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayMcoProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayReferenceMCOExport;
import com.gridnine.xtrip.common.model.export.booking.v2.TransferExport;
import com.gridnine.xtrip.common.model.export.booking.v2.UniversalProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.VisaProductExport;
import com.gridnine.xtrip.common.model.export.xml.MetadataBasedExportObjectsXmlHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.export.RootEntityExportHandler;
import com.gridnine.xtrip.server.model.export.standard.booking.ProductExportHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BookingXmlExportHandler
implements RootEntityExportHandler<BookingFile, BookingXmlExportSettings> {
    private static final Map<Class<? extends BaseEntityExport>, Class<? extends BaseProduct>> classMap = new HashMap<Class<? extends BaseEntityExport>, Class<? extends BaseProduct>>();

    @Override
    public byte[] export(EntityCompressedData object, EntityCompressedData previousVersion, List<EntityCompressedData> referencedEntities, List<DictionaryCompressedData> referencedDictionaries, EntityContainer<BookingXmlExportSettings> settings, List<Message> messages) throws Exception {
        return new byte[0];
    }

    @Override
    public boolean accept(BookingFile entity, BookingXmlExportSettings settings) throws Exception {
        List<Class<? extends BaseProduct>> classes = this.getClasses(settings);
        return this.acceptClients(entity, settings) && this.acceptSubagency(entity, settings, classes) && this.acceptSuppliers(entity, settings, classes) && this.acceptProducts(entity, settings, classes);
    }

    private List<Class<? extends BaseProduct>> getClasses(BookingXmlExportSettings settings) {
        ServerHandlersRegistry registry = (ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class);
        Collection<ProductExportHandler> handlers = registry.getAllProductExportHandlers();
        for (ProductExportHandler handler : handlers) {
            handler.fillProductExportClassMap(classMap);
        }
        return this.getAllChildren(settings.getRootExportSettings().getChildren().stream()).filter(ElementExportSettings::isExported).map(ElementExportSettings::getName).map(n -> ExportedObjectsMetadataHelper.getAllCollections((ExportedEntityType)((ExportMetadataProvider)Environment.getPublished(ExportMetadataProvider.class)).getEntity(BookingFileExport.class.getName())).values().stream().flatMap(ect -> ect.getPossibleElements().entrySet().stream()).filter(e -> TextUtil.equals((String)((String)e.getKey()), (String)n, (boolean)false)).map(Map.Entry::getValue).findFirst().orElse(null)).filter(Objects::nonNull).map(n -> {
            try {
                return Class.forName(n);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }).filter(Objects::nonNull).map(classMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Stream<ElementExportSettings> getAllChildren(Stream<ElementExportSettings> children) {
        return children.flatMap(e -> {
            if (e.getChildren() != null && !e.getChildren().isEmpty()) {
                return Stream.concat(this.getAllChildren(e.getChildren().stream()), Stream.of(e));
            }
            return Stream.of(e);
        });
    }

    @Override
    public byte[] createContent(EntityContainer<BookingFile> objectCtr, EntityContainer<BookingFile> oldObjectCtr, boolean deleted, EntityContainer<BookingXmlExportSettings> settings, List<Message> messages, EntityStorageContext storageContext) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        BookingFileExport exportEtt = new BookingFileExport();
        List<? extends BaseProduct> validProducts = this.getValidProducts((BookingXmlExportSettings)settings.getEntity(), objectCtr);
        EntityContainer<BookingXmlExportSettings> previousSettings = null;
        if (oldObjectCtr != null) {
            previousSettings = this.getPreviousBookingXmlExportSettings(settings, oldObjectCtr.getVersionInfo().getModified());
        }
        ctx.put(IBusStandardContextKeys.EXPORTED_OBJECT.name(), exportEtt);
        ctx.put(IBusBookingContextKeys.BOOKING_FILE_CONTAINER.name(), objectCtr);
        ctx.put(IBusBookingContextKeys.BOOKING_FILE.name(), objectCtr.getEntity());
        ctx.put(IBusStandardContextKeys.EXPORT_SETTINGS.name(), settings.getEntity());
        ctx.put(IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS.name(), previousSettings != null ? previousSettings.getEntity() : settings.getEntity());
        ctx.put(IBusBookingContextKeys.VALID_PRODUCTS.name(), this.getProductMap(validProducts, oldObjectCtr));
        ctx.put(IBusBookingContextKeys.BOOKING_FILE_DELETED.name(), deleted);
        IntegrationBusFacade.get().processRouteSync("export:booking:export", ctx);
        String result = MetadataBasedExportObjectsXmlHelper.generateXml((BaseEntityExport)exportEtt, (ElementExportSettings)((BookingXmlExportSettings)settings.getEntity()).getRootExportSettings());
        return result.getBytes(StandardCharsets.UTF_8);
    }

    private List<? extends BaseProduct> getValidProducts(BookingXmlExportSettings settings, EntityContainer<BookingFile> bookingFile) {
        List<Class<? extends BaseProduct>> classes = this.getClasses(settings);
        return BookingHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).filter(p -> !settings.isOnlyWithoutValidationErrors() || !BookingXmlExportHandler.hasErrors(p) && !this.relatedProductHasError((BaseProduct)p)).filter(p -> classes == null || classes.contains(p.getClass())).filter(p -> settings.getSubagencyRestrictionType() == null || settings.getSubagencyRestrictionType() == BookingExportRestrictionType.ONLY && settings.getSubagency().contains(GeneralProductHelper.getSubagency((BaseProduct)p)) || settings.getSubagencyRestrictionType() == BookingExportRestrictionType.EXCEPT && !settings.getSubagency().contains(GeneralProductHelper.getSubagency((BaseProduct)p))).filter(p -> settings.getSupplierRestrictionType() == null || settings.getSupplierRestrictionType() == BookingExportRestrictionType.ONLY && settings.getSuppliers().contains(GeneralProductHelper.getSupplier((BaseProduct)p)) || settings.getSupplierRestrictionType() == BookingExportRestrictionType.EXCEPT && !settings.getSuppliers().contains(GeneralProductHelper.getSupplier((BaseProduct)p))).filter(p -> {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)p);
            return handler == null || handler.getTicketType(p) != TicketType.FAKE && (handler.getStatus(p) == ProductStatus.SELL || handler.getStatus(p) == ProductStatus.EXCHANGE || handler.getStatus(p) == ProductStatus.REFUND || handler.getStatus(p) == ProductStatus.VOID) && handler.findIssueDate(p) != null;
        }).collect(Collectors.toList());
    }

    private EntityContainer<BookingXmlExportSettings> getPreviousBookingXmlExportSettings(EntityContainer<BookingXmlExportSettings> settings, Date date) {
        Integer versionNumber = LogicalStorage.get().getEntityStorage().getVersionInfos(settings.toReference()).stream().filter(item -> date.after(item.getModified())).map(VersionInfo::getVersionNumber).max(Comparator.naturalOrder()).orElse(null);
        if (versionNumber != null) {
            return EntityStorage.get().load(settings.getEntityType(), settings.getUid(), versionNumber);
        }
        return null;
    }

    private Map<BaseProduct, BaseProduct> getProductMap(List<? extends BaseProduct> products, EntityContainer<BookingFile> bookingFile) {
        HashMap<BaseProduct, BaseProduct> result = new HashMap<BaseProduct, BaseProduct>();
        for (BaseProduct baseProduct : products) {
            if (bookingFile == null) {
                result.put(baseProduct, null);
                continue;
            }
            result.put(baseProduct, BookingHelper.findProduct(bookingFile, (String)baseProduct.getUid()));
        }
        return result;
    }

    @Override
    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    @Override
    public ExportCategory getExportCategory() {
        return ExportCategory.BOOKING_XML;
    }

    @Override
    public Class<BookingXmlExportSettings> getSettingsClass() {
        return BookingXmlExportSettings.class;
    }

    @Override
    public boolean isExportDeletedObjects(BookingXmlExportSettings settings) {
        return settings.isCreateDocumentsOnDeleting();
    }

    private boolean acceptClients(BookingFile entity, BookingXmlExportSettings settings) {
        if (settings.getClientRestrictionType() == null) {
            return true;
        }
        if (entity.getCustomerProfile() == null) {
            return settings.getClients().isEmpty() && settings.getClientRestrictionType() == BookingExportRestrictionType.EXCEPT;
        }
        boolean found = settings.getClients().stream().anyMatch(ref -> ref.equals((Object)entity.getCustomerProfile()));
        if (found) {
            return settings.getClientRestrictionType() == BookingExportRestrictionType.ONLY;
        }
        return settings.getClientRestrictionType() == BookingExportRestrictionType.EXCEPT;
    }

    private boolean acceptSubagency(BookingFile bookingFile, BookingXmlExportSettings settings, List<Class<? extends BaseProduct>> classes) {
        if (settings.getSubagencyRestrictionType() == null) {
            return true;
        }
        List bookingFileSubagencies = BookingHelper.getBaseProductsStream((BookingFile)bookingFile).filter(p -> classes == null || classes.contains(p.getClass())).map(GeneralProductHelper::getSubagency).filter(Objects::nonNull).collect(Collectors.toList());
        if (bookingFileSubagencies.isEmpty()) {
            return settings.getSubagency().isEmpty() && settings.getSubagencyRestrictionType() == BookingExportRestrictionType.EXCEPT;
        }
        return settings.getSubagencyRestrictionType() == BookingExportRestrictionType.ONLY && bookingFileSubagencies.stream().anyMatch(s -> settings.getSubagency().contains(s)) || settings.getSubagencyRestrictionType() == BookingExportRestrictionType.EXCEPT && bookingFileSubagencies.stream().anyMatch(s -> !settings.getSubagency().contains(s));
    }

    private boolean acceptSuppliers(BookingFile bookingFile, BookingXmlExportSettings settings, List<Class<? extends BaseProduct>> classes) {
        if (settings.getSupplierRestrictionType() == null) {
            return true;
        }
        List bookingFileSuppliers = BookingHelper.getBaseProductsStream((BookingFile)bookingFile).filter(p -> classes == null || classes.contains(p.getClass())).map(GeneralProductHelper::getSupplier).filter(Objects::nonNull).collect(Collectors.toList());
        if (bookingFileSuppliers.isEmpty()) {
            return settings.getSuppliers().isEmpty() && settings.getSupplierRestrictionType() == BookingExportRestrictionType.EXCEPT;
        }
        return settings.getSupplierRestrictionType() == BookingExportRestrictionType.ONLY && bookingFileSuppliers.stream().anyMatch(s -> settings.getSuppliers().contains(s)) || settings.getSupplierRestrictionType() == BookingExportRestrictionType.EXCEPT && bookingFileSuppliers.stream().anyMatch(s -> !settings.getSuppliers().contains(s));
    }

    private boolean acceptProducts(BookingFile entity, BookingXmlExportSettings settings, List<Class<? extends BaseProduct>> classes) {
        List products = BookingHelper.getProducts((BookingFile)entity);
        if (classes != null && !classes.isEmpty()) {
            products = products.stream().filter(p -> classes.contains(p.getClass())).collect(Collectors.toList());
        }
        if (products.size() == 0) {
            return settings.isCreateDocumentsOnDeleting();
        }
        if (!settings.isOnlyWithoutValidationErrors()) {
            return true;
        }
        for (BaseProduct product : products) {
            if (BookingXmlExportHandler.hasErrors(product)) continue;
            return true;
        }
        return false;
    }

    static boolean hasErrors(BaseProduct product) {
        return GeneralProductHelper.getValidationMessages((BaseProduct)product).stream().filter(Objects::nonNull).map(ValidationMessage::getSeverity).anyMatch(arg_0 -> ValidationMessageSeverity.ERROR.equals(arg_0));
    }

    private boolean relatedProductHasError(BaseProduct product) {
        List relatedProducts = ProductHandler.of((BaseProduct)product).getRelatedProducts(product);
        if (relatedProducts == null || relatedProducts.isEmpty()) {
            return false;
        }
        return relatedProducts.stream().anyMatch(BookingXmlExportHandler::hasErrors);
    }

    static {
        classMap.put(AirProductExport.class, Product.class);
        classMap.put(RailwayProductExport.class, RailwayProduct.class);
        classMap.put(RailwayReferenceMCOExport.class, RailwayReferenceMCO.class);
        classMap.put(RailwayCrimeaMcoExport.class, RailwayCrimeaMco.class);
        classMap.put(RailwayMcoProductExport.class, RailwayMcoProduct.class);
        classMap.put(HotelExport.class, HotelProduct.class);
        classMap.put(AeroexpressTicketExport.class, AeroexpressTicket.class);
        classMap.put(VisaProductExport.class, VisaProduct.class);
        classMap.put(DeliveryExport.class, Delivery.class);
        classMap.put(MCOFeesExport.class, MCOFees.class);
        classMap.put(InsuranceAccidentExport.class, InsuranceAccident.class);
        classMap.put(TransferExport.class, Transfer.class);
        classMap.put(InsuranceTouristicExport.class, InsuranceTouristic.class);
        classMap.put(UniversalProductExport.class, UniversalProduct.class);
        classMap.put(CarRentalProductExport.class, CarRentalProduct.class);
        classMap.put(AgencyMemoProductExport.class, AgencyMemoProduct.class);
        classMap.put(AgentTouchExport.class, AgentTouch.class);
        classMap.put(ProductVoidingExport.class, ProductVoiding.class);
        classMap.put(AdditionalServiceProductExport.class, AdditionalServiceProduct.class);
    }
}

