/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.export.ExportMetadataProvider;
import com.gridnine.xtrip.common.meta.export.ExportedEntityType;
import com.gridnine.xtrip.common.meta.export.ExportedObjectsMetadataHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ElementExportSettings;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ContractExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ExternalSystemCodeExport;
import com.gridnine.xtrip.common.model.export.xml.MetadataBasedExportObjectsXmlHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;

public class BookingXmlExportHelper {
    public static boolean isBaseEntityExportModified(BaseEntityExport currentEntityExport, BaseEntityExport previousEntityExport, BookingXmlExportSettings currentSettings, BookingXmlExportSettings previousSettings) throws XMLStreamException, IOException {
        if (previousEntityExport == null) {
            return true;
        }
        Date date = new Date();
        ElementExportSettings currentElementSettings = BookingXmlExportHelper.getElementExportSettings(currentSettings, currentEntityExport);
        String currentResult = currentElementSettings != null ? MetadataBasedExportObjectsXmlHelper.generateXml((BaseEntityExport)currentEntityExport, (ElementExportSettings)currentElementSettings, (Date)date) : null;
        ElementExportSettings previousElementSettings = BookingXmlExportHelper.getElementExportSettings(previousSettings, previousEntityExport);
        String previousResult = previousElementSettings != null ? MetadataBasedExportObjectsXmlHelper.generateXml((BaseEntityExport)previousEntityExport, (ElementExportSettings)previousElementSettings, (Date)date) : null;
        return !TextUtil.equals((String)currentResult, (String)previousResult, (boolean)false);
    }

    private static ElementExportSettings getElementExportSettings(BookingXmlExportSettings settings, BaseEntityExport entityExport) {
        String name = ExportedObjectsMetadataHelper.getAllCollections((ExportedEntityType)((ExportMetadataProvider)Environment.getPublished(ExportMetadataProvider.class)).getEntity(BookingFileExport.class.getName())).values().stream().flatMap(item -> item.getPossibleElements().entrySet().stream()).filter(item -> TextUtil.equals((String)((String)item.getValue()), (String)entityExport.getClass().getName(), (boolean)false)).map(Map.Entry::getKey).findFirst().orElse(null);
        return BookingXmlExportHelper.getAllChildren(settings.getRootExportSettings().getChildren().stream()).filter(ElementExportSettings::isExported).filter(item -> TextUtil.equals((String)item.getName(), (String)name, (boolean)false)).findFirst().orElse(null);
    }

    private static Stream<ElementExportSettings> getAllChildren(Stream<ElementExportSettings> children) {
        return children.flatMap(e -> {
            if (e.getChildren() != null && !e.getChildren().isEmpty()) {
                return Stream.concat(BookingXmlExportHelper.getAllChildren(e.getChildren().stream()), Stream.of(e));
            }
            return Stream.of(e);
        });
    }

    public static void setContract(BaseContractRelationData contractRelation, Consumer<ContractExport> client, Consumer<ContractExport> subagency, Consumer<ContractExport> vendor, Consumer<ContractExport> technicalProvider) {
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
        GeneralProductHelper.getContract((BaseContractRelationData)contractRelation).ifPresent(contract -> {
            ContractExport contractExport = new ContractExport();
            contractExport.setNumber(contract.getNumber());
            if (contract.getAgreementType() != null) {
                contractExport.setType(contract.getAgreementType().name());
            }
            switch (contractType) {
                case CLIENT: {
                    client.accept(contractExport);
                    break;
                }
                case SUBAGENCY: {
                    subagency.accept(contractExport);
                    break;
                }
                case VENDOR: {
                    vendor.accept(contractExport);
                    break;
                }
                case TECHNICAL_PROVIDER: {
                    technicalProvider.accept(contractExport);
                }
            }
        });
    }

    public static List<ExternalSystemCodeExport> getPersonExternalCodes(EntityReference<Person> personRef) {
        if (personRef != null) {
            EntityContainer personCtr = EntityStorage.get().resolve(personRef);
            return BookingXmlExportHelper.getPersonExternalCodes((EntityContainer<Person>)personCtr);
        }
        return Collections.emptyList();
    }

    public static List<ExternalSystemCodeExport> getPersonExternalCodes(EntityContainer<Person> personCtr) {
        if (personCtr != null) {
            return ((Person)personCtr.getEntity()).getExternalCodesV2().stream().map(MetadataBasedExportHelper::convertExternalSystemCode).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

