/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingExportRestrictionType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.export.ExportCategory;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.finance.export.v2.RelatedDocumentsExportSettings;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DocumentHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.export.RootEntityExportHandler;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class RelatedDocumentsExportHandler
implements RootEntityExportHandler<Document, RelatedDocumentsExportSettings> {
    @Override
    public boolean accept(Document document, RelatedDocumentsExportSettings settings) throws Exception {
        BookingFile bookingFile = (BookingFile)EntityStorage.get().resolve(document.getOwner()).getEntity();
        return this.acceptDocumentType(document, settings) && this.acceptClients(bookingFile, settings) && this.acceptSubagency(bookingFile, settings) && this.acceptSuppliers(bookingFile, settings);
    }

    @Override
    public byte[] createContent(EntityContainer<Document> objectCtr, EntityContainer<Document> oldObjectCtr, boolean deleted, EntityContainer<RelatedDocumentsExportSettings> settings, List<Message> messages, EntityStorageContext storageContext) throws Exception {
        Document document = (Document)objectCtr.getEntity();
        if (document.getContentType() == ContentType.JASPERPRINT) {
            document.setContent(JasperUtil.convertToPdf((byte[])document.getContent()));
            document.setContentType(ContentType.PDF);
        }
        return document.getContent();
    }

    @Override
    public ExportCategory getExportCategory() {
        return ExportCategory.RELATED_DOCUMENTS;
    }

    @Override
    public Class<Document> getEntityType() {
        return Document.class;
    }

    @Override
    public Class<RelatedDocumentsExportSettings> getSettingsClass() {
        return RelatedDocumentsExportSettings.class;
    }

    @Override
    public String getOriginalName(EntityContainer<ExportDocument> exportDocumentCtr) throws Exception {
        String fileName = null;
        if (((ExportDocument)exportDocumentCtr.getEntity()).getObject() != null && ((ExportDocument)exportDocumentCtr.getEntity()).getObject().getContent() != null) {
            String extension;
            byte[] unzippedContent = GZIPUtil.gunzip((byte[])((ExportDocument)exportDocumentCtr.getEntity()).getObject().getContent());
            EntityContainer documentCtr = (EntityContainer)XUtil.deserialize((byte[])unzippedContent);
            fileName = ((Document)documentCtr.getEntity()).getName();
            if (TextUtil.isBlank((String)fileName)) {
                fileName = "document_" + UUID.randomUUID();
            }
            if ((extension = (String)CollectionUtil.head((Iterable)DocumentHelper.getExtensions((ContentType)((Document)documentCtr.getEntity()).getContentType()))) != null && !fileName.endsWith(extension)) {
                fileName = String.format("%s.%s", fileName, extension);
            }
        }
        return fileName;
    }

    @Override
    public URL updateUrl(EntityContainer<ExportDocument> exportDocumentCtr, RelatedDocumentsExportSettings settings) throws Exception {
        URL url = settings.getConnectionSettings().getUrl();
        if (settings.getGroupByUdid() != null && ((ExportDocument)exportDocumentCtr.getEntity()).getObject() != null) {
            byte[] unzippedContent = GZIPUtil.gunzip((byte[])((ExportDocument)exportDocumentCtr.getEntity()).getObject().getContent());
            EntityContainer documentCtr = (EntityContainer)XUtil.deserialize((byte[])unzippedContent);
            BookingFile bookingCtr = (BookingFile)EntityStorage.get().resolve(((Document)documentCtr.getEntity()).getOwner()).getEntity();
            BaseProduct relatedProduct = BookingHelper.findProduct((BookingFile)bookingCtr, (String)((Document)documentCtr.getEntity()).getNavigationKey());
            Optional<String> optCcValue = StatisticsHelper.getProductCostCodes((BaseProduct)relatedProduct, null).stream().filter(costCode -> settings.getGroupByUdid().equals((Object)costCode.getCostCodeProperties().getCategory())).map(CostCode::getValue).findAny();
            if (optCcValue.isPresent()) {
                return new URL(url.toString().replace(url.getPath(), String.format("%s/%s", url.getPath(), optCcValue.get().replace("/", "_"))));
            }
        }
        return url;
    }

    private boolean acceptDocumentType(Document document, RelatedDocumentsExportSettings settings) {
        return settings.getDocumentType().isEmpty() || settings.getDocumentType().contains(document.getType());
    }

    private boolean acceptClients(BookingFile bookingFile, RelatedDocumentsExportSettings settings) {
        if (settings.getClientRestrictionType() == null) {
            return true;
        }
        if (bookingFile.getCustomerProfile() == null) {
            return settings.getClients().isEmpty() && settings.getClientRestrictionType() == BookingExportRestrictionType.EXCEPT;
        }
        boolean found = settings.getClients().stream().anyMatch(ref -> ref.equals((Object)bookingFile.getCustomerProfile()));
        if (found) {
            return settings.getClientRestrictionType() == BookingExportRestrictionType.ONLY;
        }
        return settings.getClientRestrictionType() == BookingExportRestrictionType.EXCEPT;
    }

    private boolean acceptSubagency(BookingFile bookingFile, RelatedDocumentsExportSettings settings) {
        if (settings.getSubagencyRestrictionType() == null) {
            return true;
        }
        List bookingFileSubagencies = BookingHelper.getBaseProductsStream((BookingFile)bookingFile).map(GeneralProductHelper::getSubagency).filter(Objects::nonNull).collect(Collectors.toList());
        if (bookingFileSubagencies.isEmpty()) {
            return settings.getSubagency().isEmpty() && settings.getSubagencyRestrictionType() == BookingExportRestrictionType.EXCEPT;
        }
        switch (settings.getSubagencyRestrictionType()) {
            case ONLY: {
                return new HashSet(settings.getSubagency()).containsAll(bookingFileSubagencies);
            }
            case EXCEPT: {
                return settings.getSubagency().stream().noneMatch(bookingFileSubagencies::contains);
            }
        }
        return false;
    }

    private boolean acceptSuppliers(BookingFile bookingFile, RelatedDocumentsExportSettings settings) {
        if (settings.getSupplierRestrictionType() == null) {
            return true;
        }
        List bookingFileSuppliers = BookingHelper.getBaseProductsStream((BookingFile)bookingFile).map(GeneralProductHelper::getSupplier).filter(Objects::nonNull).collect(Collectors.toList());
        if (bookingFileSuppliers.isEmpty()) {
            return settings.getSuppliers().isEmpty() && settings.getSupplierRestrictionType() == BookingExportRestrictionType.EXCEPT;
        }
        switch (settings.getSupplierRestrictionType()) {
            case ONLY: {
                return new HashSet(settings.getSuppliers()).containsAll(bookingFileSuppliers);
            }
            case EXCEPT: {
                return settings.getSuppliers().stream().noneMatch(bookingFileSuppliers::contains);
            }
        }
        return false;
    }
}

