/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking.additionalserviceproduct;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AdditionalServiceProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductSegmentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductSpecialServiceRequestExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductTechStopInfoExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.TravellerExport;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BookingExportAdditionalServiceFillProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AdditionalServiceProduct product = (AdditionalServiceProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        AdditionalServiceProductExport productExport = new AdditionalServiceProductExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        AdditionalServiceProductExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof AdditionalServiceProduct) {
            previousProductExport = new AdditionalServiceProductExport();
            this.updateProductExport(previousProductExport, (AdditionalServiceProduct)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, settings, previousSettings)));
    }

    private void updateProductExport(AdditionalServiceProductExport productExport, AdditionalServiceProduct product) {
        ProductStatus status = product.getStatus();
        boolean negate = ProductStatus.EXCHANGE.equals((Object)status) || ProductStatus.REFUND.equals((Object)status) || ProductStatus.VOID.equals((Object)status);
        productExport.setUid(product.getUid());
        productExport.setCategory(MetadataBasedExportHelper.convertEnum(product.getCategory()));
        productExport.setStatus(MetadataBasedExportHelper.convertEnum(status));
        productExport.setTicketNumber(product.getSystemNumber());
        productExport.setIssueDate(product.getIssueDate());
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)AdditionalServiceProductHelper.getAgency((AdditionalServiceProduct)product)));
        productExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)AdditionalServiceProductHelper.getSubagency((AdditionalServiceProduct)product)));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference<SalesPoint>)product.getSalesPoint()));
        productExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)product.getAgent()));
        productExport.setPnr(CommonReservationGdsNameInfoHelper.getExport1CRecordLocator((Reservation)product.getReservation()));
        productExport.setGdsName(MetadataBasedExportHelper.convertEnum(CommonReservationGdsNameInfoHelper.getExport1CGdsName((Reservation)product.getReservation())));
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum(product.getTicketType() != null ? product.getTicketType() : TicketType.OWN));
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        String subagencyEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
        String clientEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.CLIENT);
        productExport.setTotalSubagencyCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.commissionPropertyTypes, productExport.getSubagencyCommissions(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.commissionPropertyTypes, productExport.getClientCommissions(), clientEquivalentCurrency, negate));
        productExport.setTotalSubagencyServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.serviceFeePropertyTypes, productExport.getSubagencyServiceFee(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.serviceFeePropertyTypes, productExport.getClientServiceFee(), clientEquivalentCurrency, negate));
        MetadataBasedExportHelper.convertStringCollection(productExport.getRelatedProductUids(), product.getRelatedProducts().stream().map(BaseIdentity::getUid).collect(Collectors.toList()));
        for (Traveller traveller : product.getTravellers()) {
            TravellerExport travellerExport = new TravellerExport();
            travellerExport.setName(traveller.getName());
            travellerExport.setNameInGds(traveller.getNameInGds());
            travellerExport.setNameInCyrillic(traveller.getCyrillicName());
            if (traveller.getPassenger() != null) {
                EntityContainer personCtr = EntityStorage.get().resolve(traveller.getPassenger());
                travellerExport.setPassengerUid(traveller.getPassenger().getUid());
                if (personCtr != null) {
                    travellerExport.getExternalCodes().addAll(BookingXmlExportHelper.getPersonExternalCodes((EntityContainer<Person>)personCtr));
                    travellerExport.setCode(((Person)personCtr.getEntity()).getCode());
                }
            }
            productExport.getTravellers().add(travellerExport);
        }
        for (SegmentTariff segmentTariff : product.getSegments()) {
            boolean first = true;
            for (Segment segment : segmentTariff.getSegments()) {
                CodeSystem[] codeSystemArray;
                AirProductSegmentExport segmentExport = new AirProductSegmentExport();
                segmentExport.setCouponNumber(Integer.valueOf(segment.getRecordNumber()));
                if (segment.getDefaultCodeSystem() == null) {
                    CodeSystem[] codeSystemArray2 = new CodeSystem[4];
                    codeSystemArray2[0] = CodeSystem.IATA;
                    codeSystemArray2[1] = CodeSystem.ISO;
                    codeSystemArray2[2] = CodeSystem.ISO_ALPHA3;
                    codeSystemArray = codeSystemArray2;
                    codeSystemArray2[3] = CodeSystem.CRT;
                } else {
                    CodeSystem[] codeSystemArray3 = new CodeSystem[1];
                    codeSystemArray = codeSystemArray3;
                    codeSystemArray3[0] = segment.getDefaultCodeSystem();
                }
                CodeSystem[] codeSystems = codeSystemArray;
                segmentExport.setDepartureLocation(MetadataBasedExportHelper.convertLocation((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
                segmentExport.setArriveLocation(MetadataBasedExportHelper.convertLocation((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
                segmentExport.setDepartureLocationCode(MetadataBasedExportHelper.getLocationCode((DictionaryReference<GeoLocation>)segment.getDepartureLocation(), codeSystems));
                segmentExport.setArriveLocationCode(MetadataBasedExportHelper.getLocationCode((DictionaryReference<GeoLocation>)segment.getArriveLocation(), codeSystems));
                segmentExport.setAirline(MetadataBasedExportHelper.convertAirline((DictionaryReference<Airline>)segment.getAirline(), codeSystems));
                segmentExport.setFlightNo(segment.getFlightNo());
                segmentExport.setClassOfService(!TextUtil.isBlank((String)segment.getClassOfSvcCode()) ? segment.getClassOfSvcCode() : segment.getClassOfService());
                segmentExport.setServiceClass(segment.getServiceClass() != null ? segment.getServiceClass().toString() : null);
                segmentExport.setDepartureDate(segment.getStartDate());
                segmentExport.setSeatNo(segment.getSeatNo());
                segmentExport.setFareBasis(segment.getFareBasis());
                segmentExport.setConnectedSegment(Boolean.valueOf(!first));
                first = false;
                segmentExport.setArriveDate(segment.getEndDate());
                segmentExport.setLuggage(AirProductHelper.luggageInfoToSring((LuggageInfo)segment.getLuggageInfo(), (Locale)Locale.ENGLISH));
                segmentExport.setMealServiceIndicator(MetadataBasedExportHelper.convertDictionary(segment.getMealServiceIndicator()));
                segmentExport.setNotValidBefore(segment.getNotValidBefore());
                segmentExport.setNotValidAfter(segment.getNotValidAfter());
                segmentExport.setAirlineLocator(segment.getAirlineLocator());
                segmentExport.setCodeShareCarrier(MetadataBasedExportHelper.convertDictionary(segment.getCodeShareCarrier()));
                for (TechStopInfo techStopInfo : segment.getTechStopInfos()) {
                    AirProductTechStopInfoExport techStopInfoExport = new AirProductTechStopInfoExport();
                    techStopInfoExport.setLocation(MetadataBasedExportHelper.convertDictionary(techStopInfo.getLocation()));
                    techStopInfoExport.setArrivalDate(MetadataBasedExportHelper.convertDateTime(techStopInfo.getArrivalDateTime()));
                    techStopInfoExport.setDepartureDate(MetadataBasedExportHelper.convertDateTime(techStopInfo.getDepartureDateTime()));
                    techStopInfoExport.setDuration(Integer.valueOf(techStopInfo.getDuration()));
                    segmentExport.getTechStopInfos().add(techStopInfoExport);
                }
                for (SpecialServiceRequest ssr : segment.getSsrs()) {
                    AirProductSpecialServiceRequestExport ssrExport = new AirProductSpecialServiceRequestExport();
                    ssrExport.setType(MetadataBasedExportHelper.convertDictionary(ssr.getType()));
                    ssrExport.setStatus(MetadataBasedExportHelper.convertEnum(ssr.getStatus()));
                    ssrExport.setRequest(ssr.getRequestFreeText());
                    ssrExport.setResponse(ssr.getResponseFreeText());
                    segmentExport.getSpecialServiceRequests().add(ssrExport);
                }
                productExport.getSegments().add(segmentExport);
            }
        }
        List contractRelations = AdditionalServiceProductHelper.getContractRelations((AdditionalServiceProduct)product);
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
            if (contractType == ContractType.VENDOR) continue;
            BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, arg_0 -> ((AdditionalServiceProductExport)productExport).setClientContract(arg_0), arg_0 -> ((AdditionalServiceProductExport)productExport).setSubagencyContract(arg_0), null, arg_0 -> ((AdditionalServiceProductExport)productExport).setTechnicalProviderContract(arg_0));
            List<GeneralProductFop> fops = MetadataBasedExportHelper.getSortedFops(contractRelation.getFops());
            for (GeneralProductFop fop : fops) {
                ReferenceItemExport commissionExport;
                Object card;
                FopExport fopExport = new FopExport();
                productExport.getFops().add(fopExport);
                FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
                fopExport.setContractType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())));
                fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getAgreementType((BaseContractRelationData)contractRelation)));
                fopExport.setCategory(MetadataBasedExportHelper.getFopCategory(fop));
                fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum(fop.getType()));
                fopExport.setAmount(MetadataBasedExportHelper.convertMoney(MoneyHelper.buildMoney((BigDecimal)fop.getEquivalentAmount(), (String)GeneralProductHelper.getContractCurrency((GeneralProductContractRelationData)contractRelation)), negate));
                PaymentType paymentType = fop.getType();
                if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setDetails(MetadataBasedExportHelper.convertEnum(card.getVendor()));
                        fopExport.setCardNumber(card.getNumber());
                        fopExport.setCardExpirationDate(card.getExpiration());
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                } else {
                    fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum(fop.getPassengerStatus()) : null));
                    fopExport.setNumber(fop.getRelatedTicketNumber());
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                }
                fopExport.setOperationDate(fop.getOperationDate());
                fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)fop.getAgent()));
                fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
                fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)fop.getPayer()));
                for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                    commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                    fopExport.getServiceFees().add(commissionExport);
                }
                for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.discountPropertyTypes, null, null)) {
                    commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                }
                List<FopComponent> components = MetadataBasedExportHelper.getSortedFopComponents(fopDetalization.getComponents());
                for (FopComponent component : components) {
                    FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent(component, negate);
                    fopExport.getFopComponents().add(componentExport);
                }
            }
        }
    }
}

