/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking.agencymemo;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntry;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductRelatedProductGroup;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AgencyMemoProductEntryExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AgencyMemoProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AgencyMemoProductItemGroupExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AgencyMemoProductRelatedProductGroupExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.util.List;
import java.util.Map;

public class BookingFileExportAgencyMemoProductFillHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AgencyMemoProduct product = (AgencyMemoProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        AgencyMemoProductExport productExport = new AgencyMemoProductExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        AgencyMemoProductExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof AgencyMemoProduct) {
            previousProductExport = new AgencyMemoProductExport();
            this.updateProductExport(previousProductExport, (AgencyMemoProduct)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, settings, previousSettings)));
    }

    private void updateProductExport(AgencyMemoProductExport productExport, AgencyMemoProduct product) {
        productExport.setUid(product.getUid());
        productExport.setBlankOwner(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)product.getBlankOwner()));
        EntityReference supplierRef = product.getSupplier();
        productExport.setSupplier(MetadataBasedExportHelper.convertSupplier((EntityReference<Organization>)supplierRef));
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)product.getAgency()));
        productExport.setAirlineCode(product.getAirlineCode());
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setType(MetadataBasedExportHelper.convertEnum(product.getType()));
        productExport.setIssueDate(product.getIssueDate());
        productExport.setAcceptDate(product.getAcceptDate());
        productExport.setSourceReportDate(product.getSourceReportDate());
        productExport.setTargetReportDate(product.getTargetReportDate());
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setIncludeToReport(Boolean.valueOf(product.isIncludeToReport()));
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        this.convertEntries(product.getEntries(), productExport.getEntries());
        productExport.setComments(product.getComments());
        for (AgencyMemoProductItemGroup itemGroup : product.getItemGroups()) {
            AgencyMemoProductItemGroupExport itemGroupExport = new AgencyMemoProductItemGroupExport();
            itemGroupExport.setAmount(MetadataBasedExportHelper.convertMoney(itemGroup.getAmount()));
            itemGroupExport.setDescription(itemGroup.getDescription());
            itemGroupExport.setEquivalentAmount(itemGroup.getEquivalentAmount());
            itemGroupExport.setType(MetadataBasedExportHelper.convertEnum(itemGroup.getType()));
            this.convertEntries(itemGroup.getEntries(), itemGroupExport.getEntries());
            productExport.getItemGroups().add(itemGroupExport);
        }
        for (AgencyMemoProductRelatedProductGroup relatedProductGroup : product.getRelatedProductGroups()) {
            AgencyMemoProductRelatedProductGroupExport relatedProductGroupExport = new AgencyMemoProductRelatedProductGroupExport();
            relatedProductGroupExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)relatedProductGroup.getAgent()));
            relatedProductGroupExport.setAssociationType(MetadataBasedExportHelper.convertEnum(relatedProductGroup.getAssociationType()));
            relatedProductGroupExport.setClient(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)relatedProductGroup.getClient()));
            relatedProductGroupExport.setRelatedProductNumber(relatedProductGroup.getRelatedProductNumber());
            relatedProductGroupExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference<SalesPoint>)relatedProductGroup.getSalesPoint()));
            relatedProductGroupExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)relatedProductGroup.getSubagency()));
            this.convertEntries(relatedProductGroup.getEntries(), relatedProductGroupExport.getEntries());
            productExport.getRelatedProductGroups().add(relatedProductGroupExport);
        }
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
    }

    private void convertEntries(List<AgencyMemoProductEntry> entries, List<AgencyMemoProductEntryExport> entriesExport) {
        for (AgencyMemoProductEntry entry : entries) {
            AgencyMemoProductEntryExport entryExport = new AgencyMemoProductEntryExport();
            entryExport.setAmount(MetadataBasedExportHelper.convertMoney(entry.getAmount()));
            entryExport.setAssociationType(MetadataBasedExportHelper.convertEnum(entry.getAssociationType()));
            entryExport.setDescription(entry.getDescription());
            entryExport.setEquivalentAmount(entry.getEquivalentAmount());
            if (entry.getProduct() != null) {
                entryExport.setProductUid(entry.getProduct().getUid());
            }
            entryExport.setRelatedProductNumber(entry.getRelatedProductNumber());
            entryExport.setType(MetadataBasedExportHelper.convertEnum(entry.getType()));
            entriesExport.add(entryExport);
        }
    }
}

