/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking.air;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.TripartitePublicFareDiscount;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LuggageUnits;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductFareExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductFopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductLuggageExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductOBFeeExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductSegmentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductSpecialServiceRequestExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductTaxExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductTechStopInfoExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductTravellerExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductTripartiteContractDetailsExport;
import com.gridnine.xtrip.common.model.export.booking.v2.AirProductTripartitePublicFareDiscountExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RelatedTicket;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BookingExportAirFillProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        AirProductExport productExport = new AirProductExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        AirProductExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof Product) {
            previousProductExport = new AirProductExport();
            this.updateProductExport(previousProductExport, (Product)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, settings, previousSettings)));
    }

    private void updateProductExport(AirProductExport productExport, Product product) throws Exception {
        BigDecimal addCollectTaxes;
        ProductStatus status = product.getStatus();
        boolean negate = ProductStatus.EXCHANGE.equals((Object)status) || ProductStatus.REFUND.equals((Object)status) || ProductStatus.VOID.equals((Object)status);
        productExport.setCategory(MetadataBasedExportHelper.convertEnum(product.getProductCategory()));
        productExport.setUid(product.getUid());
        productExport.setBlankType(MetadataBasedExportHelper.convertDictionary(product.getBlankType()));
        productExport.setStatus(MetadataBasedExportHelper.convertEnum(status));
        productExport.setTariffType(MetadataBasedExportHelper.convertEnum(product.getTariffType()));
        productExport.setTransportationType(this.convertTransportationType(product));
        productExport.setMcoCategory(MetadataBasedExportHelper.convertEnum(product.getMcoCategory()));
        productExport.setBlankOwnerNumber(product.getBlankOwnerNumber());
        productExport.setBlankOwner(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)product.getBlankOwnerRef()));
        productExport.setValidatingCarrierNumber(product.getCarrierNumber());
        productExport.setValidatingCarrierCode(this.findAirlineCode((DictionaryReference<Airline>)product.getCarrier()));
        productExport.setTicketNumber(product.getSystemNumber());
        productExport.setConjunctionCount(Integer.valueOf(product.getConjCount()));
        productExport.setETicket(Boolean.valueOf(product.isEticket()));
        MetadataBasedExportHelper.convertStringCollection(productExport.getScns(), product.getScns());
        EntityReference supplierRef = AirProductHelper.getSupplier((Product)product);
        productExport.setSupplier(MetadataBasedExportHelper.convertSupplier((EntityReference<Organization>)supplierRef));
        productExport.setIssueDate(product.getIssueDate());
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)AirProductHelper.getAgency((Product)product)));
        productExport.setValidator(product.getValidatorCode());
        productExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)AirProductHelper.getSubagency((Product)product)));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference<SalesPoint>)product.getSalesPoint()));
        productExport.setCashier(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)product.getCashier()));
        productExport.setTraveller(this.convertTraveller(product));
        productExport.setPnr(CommonReservationGdsNameInfoHelper.getExport1CRecordLocator((Reservation)product.getReservation()));
        productExport.setPcc(product.getPcc());
        productExport.setTourCode(product.getTourCode());
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum(product.getTicketType() != null ? product.getTicketType() : TicketType.OWN));
        productExport.setLuggage(this.convertLuggage(product.getLuggageWeight(), product.getLuggageUnits()));
        productExport.setComments(product.getComments());
        if (ProductStatus.REFUND == status || ProductStatus.EXCHANGE == status) {
            productExport.setForced(Boolean.valueOf(product.isForcedRefund()));
        } else {
            productExport.setDuplicate(Boolean.valueOf(product.isDuplicate()));
        }
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            productExport.setExchangeTicketNumber(product.getPreviousProduct().getSystemNumber());
        }
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            boolean first = true;
            for (Segment segment : segmentTariff.getSegments()) {
                CodeSystem[] codeSystemArray;
                AirProductSegmentExport segmentExport = new AirProductSegmentExport();
                segmentExport.setCouponNumber(Integer.valueOf(segment.getRecordNumber()));
                if (segment.getDefaultCodeSystem() == null) {
                    CodeSystem[] codeSystemArray2 = new CodeSystem[4];
                    codeSystemArray2[0] = CodeSystem.IATA;
                    codeSystemArray2[1] = CodeSystem.ISO;
                    codeSystemArray2[2] = CodeSystem.ISO_ALPHA3;
                    codeSystemArray = codeSystemArray2;
                    codeSystemArray2[3] = CodeSystem.CRT;
                } else {
                    CodeSystem[] codeSystemArray3 = new CodeSystem[1];
                    codeSystemArray = codeSystemArray3;
                    codeSystemArray3[0] = segment.getDefaultCodeSystem();
                }
                CodeSystem[] codeSystems = codeSystemArray;
                segmentExport.setDepartureLocation(MetadataBasedExportHelper.convertLocation((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
                segmentExport.setArriveLocation(MetadataBasedExportHelper.convertLocation((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
                segmentExport.setDepartureLocationCode(MetadataBasedExportHelper.getLocationCode((DictionaryReference<GeoLocation>)segment.getDepartureLocation(), codeSystems));
                segmentExport.setArriveLocationCode(MetadataBasedExportHelper.getLocationCode((DictionaryReference<GeoLocation>)segment.getArriveLocation(), codeSystems));
                segmentExport.setAirline(MetadataBasedExportHelper.convertAirline((DictionaryReference<Airline>)segment.getAirline(), codeSystems));
                segmentExport.setFlightNo(segment.getFlightNo());
                segmentExport.setClassOfService(!TextUtil.isBlank((String)segment.getClassOfSvcCode()) ? segment.getClassOfSvcCode() : segment.getClassOfService());
                segmentExport.setServiceClass(segment.getServiceClass() != null ? segment.getServiceClass().toString() : null);
                segmentExport.setDepartureDate(segment.getStartDate());
                segmentExport.setSeatNo(segment.getSeatNo());
                segmentExport.setFareBasis(segment.getFareBasis());
                segmentExport.setConnectedSegment(Boolean.valueOf(!first));
                first = false;
                segmentExport.setArriveDate(segment.getEndDate());
                segmentExport.setLuggage(AirProductHelper.luggageInfoToSring((LuggageInfo)segment.getLuggageInfo(), (Locale)Locale.ENGLISH));
                segmentExport.setMealServiceIndicator(MetadataBasedExportHelper.convertDictionary(segment.getMealServiceIndicator()));
                segmentExport.setNotValidBefore(segment.getNotValidBefore());
                segmentExport.setNotValidAfter(segment.getNotValidAfter());
                segmentExport.setAirlineLocator(segment.getAirlineLocator());
                segmentExport.setCodeShareCarrier(MetadataBasedExportHelper.convertDictionary(segment.getCodeShareCarrier()));
                for (TechStopInfo techStopInfo : segment.getTechStopInfos()) {
                    AirProductTechStopInfoExport techStopInfoExport = new AirProductTechStopInfoExport();
                    techStopInfoExport.setLocation(MetadataBasedExportHelper.convertDictionary(techStopInfo.getLocation()));
                    techStopInfoExport.setArrivalDate(MetadataBasedExportHelper.convertDateTime(techStopInfo.getArrivalDateTime()));
                    techStopInfoExport.setDepartureDate(MetadataBasedExportHelper.convertDateTime(techStopInfo.getDepartureDateTime()));
                    techStopInfoExport.setDuration(Integer.valueOf(techStopInfo.getDuration()));
                    segmentExport.getTechStopInfos().add(techStopInfoExport);
                }
                for (SpecialServiceRequest ssr : segment.getSsrs()) {
                    AirProductSpecialServiceRequestExport ssrExport = new AirProductSpecialServiceRequestExport();
                    ssrExport.setType(MetadataBasedExportHelper.convertDictionary(ssr.getType()));
                    ssrExport.setStatus(MetadataBasedExportHelper.convertEnum(ssr.getStatus()));
                    ssrExport.setRequest(ssr.getRequestFreeText());
                    ssrExport.setResponse(ssr.getResponseFreeText());
                    segmentExport.getSpecialServiceRequests().add(ssrExport);
                }
                productExport.getSegments().add(segmentExport);
            }
        }
        String vendorEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.VENDOR);
        String subagencyEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
        String clientEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.CLIENT);
        String gdsCurrency = TextUtil.isBlank((String)product.getGdsCurrency()) ? DictHelper.getEquivCurrency() : product.getGdsCurrency();
        boolean addCollectVisible = product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
        BigDecimal addCollectEquivalent = addCollectVisible ? product.getAddCollectEquivalent() : null;
        BigDecimal bigDecimal = addCollectTaxes = addCollectVisible ? AirProductHelper.calculateTaxesEquivalentAddCollect((Product)product) : null;
        BigDecimal addCollectTotal = addCollectVisible ? (addCollectEquivalent != null ? addCollectEquivalent : BigDecimal.ZERO).add(addCollectTaxes != null ? addCollectTaxes : BigDecimal.ZERO) : null;
        productExport.setFare(MetadataBasedExportHelper.convertProductAmount(AirProductHelper.getBaseFare((Product)product), null, product.getAddCollectBase(), negate));
        productExport.setEquivalentFare(MetadataBasedExportHelper.convertProductAmount(AirProductHelper.getEquivalentFare((Product)product), gdsCurrency, AirProductHelper.calculateTariffEquivalentVat((Product)product), addCollectEquivalent, negate));
        productExport.setTax(MetadataBasedExportHelper.convertProductAmount(AirProductHelper.calculateTaxesEquivalentAmount((Product)product), gdsCurrency, AirProductHelper.calculateTaxesVatAmount((Product)product), addCollectTaxes, negate));
        productExport.setPenalty(MetadataBasedExportHelper.convertVatAmount(product.getPenalty(), gdsCurrency, AirProductHelper.getPenaltyVatAmount((Product)product)));
        productExport.setTotal(MetadataBasedExportHelper.convertProductAmount(AirProductHelper.calculateTotalEquivalentFare((Product)product), gdsCurrency, product.getTotalVendorEquivalentVatAmount(), addCollectTotal, negate));
        ProductFare totalFare = this.getProductFare(product);
        productExport.setRoe(MetadataBasedExportHelper.convertSum(totalFare != null ? totalFare.getRoe() : null));
        productExport.setNuc(MetadataBasedExportHelper.convertSum(totalFare != null ? totalFare.getNucFare() : null, negate));
        productExport.setRate(MetadataBasedExportHelper.convertSum(this.getRate(product, totalFare)));
        productExport.setGdsCurrency(MetadataBasedExportHelper.convertCurrency(product.getGdsCurrency()));
        for (Object fare : product.getFares()) {
            AirProductFareExport fareExport = new AirProductFareExport();
            fareExport.setSegmentNo(this.getSegmentNo(fare.getSegmentTariff()));
            fareExport.setAmount(MetadataBasedExportHelper.convertMoney(fare.getBaseFare(), negate));
            fareExport.setEquivalentAmount(MetadataBasedExportHelper.convertMoney(fare.getEquivalentFare(), gdsCurrency, negate));
            fareExport.setRoe(MetadataBasedExportHelper.convertSum(fare.getRoe()));
            fareExport.setNuc(MetadataBasedExportHelper.convertSum(fare.getNucFare(), negate));
            productExport.getFares().add(fareExport);
        }
        HashSet<String> taxCodes = new HashSet<String>();
        for (Tax tax : product.getTaxes()) {
            AirProductTaxExport taxExport = new AirProductTaxExport();
            taxExport.setSegmentNo(this.getSegmentNo(tax.getSegmentTariff()));
            taxExport.setCode(tax.getCode());
            taxExport.setAmount(MetadataBasedExportHelper.convertMoney(tax.getAmount(), negate));
            taxExport.setEquivalentAmount(MetadataBasedExportHelper.convertProductAmount(tax.getEquivalentAmount(), gdsCurrency, AirProductHelper.calculateTaxVatAmount((Product)product, (Tax)tax, (boolean)taxCodes.contains(tax.getCode())), tax.getAddCollect(), negate));
            taxCodes.add(tax.getCode());
            productExport.getTaxes().add(taxExport);
        }
        for (Object OBFee2 : product.getObFees()) {
            AirProductOBFeeExport OBFeeExport = new AirProductOBFeeExport();
            OBFeeExport.setDescription(OBFee2.getDescription());
            OBFeeExport.setAmount(MetadataBasedExportHelper.convertMoney(OBFee2.getAmount(), negate));
            productExport.getOBFees().add(OBFeeExport);
        }
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        List contractRelations = AirProductHelper.getContractRelations((Product)product);
        for (AirProductContractRelationData contractRelation : contractRelations) {
            BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, arg_0 -> ((AirProductExport)productExport).setClientContract(arg_0), arg_0 -> ((AirProductExport)productExport).setSubagencyContract(arg_0), arg_0 -> ((AirProductExport)productExport).setVendorContract(arg_0), arg_0 -> ((AirProductExport)productExport).setTechnicalProviderContract(arg_0));
            List fops = contractRelation.getFops().stream().sorted((o1, o2) -> {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getAmount() == null) {
                    return o2.getAmount() == null ? MiscUtil.compare((Comparable)((Object)o1.getUid()), (Comparable)((Object)o2.getUid())) : -1;
                }
                if (o2.getAmount() == null) {
                    return 1;
                }
                int result = MiscUtil.compare((Comparable)o1.getAmount().getValue(), (Comparable)o2.getAmount().getValue());
                if (result == 0) {
                    return MiscUtil.compare((Comparable)((Object)o1.getUid()), (Comparable)((Object)o2.getUid()));
                }
                return result;
            }).collect(Collectors.toList());
            for (ProductFop fop : fops) {
                ReferenceItemExport commissionExport;
                Object card;
                AirProductFopExport fopExport = new AirProductFopExport();
                productExport.getFops().add(fopExport);
                FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
                fopExport.setContractType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())));
                fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getAgreementType((BaseContractRelationData)contractRelation)));
                fopExport.setCategory(BookingExportAirFillProductHeaderProcessor.getFopCategory(fop));
                fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum(fop.getType()));
                fopExport.setAmount(MetadataBasedExportHelper.convertMoney(fop.getAmount(), negate));
                PaymentType paymentType = fop.getType();
                if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setDetails(MetadataBasedExportHelper.convertEnum(card.getVendor()));
                        fopExport.setCardNumber(card.getNumber());
                        fopExport.setCardExpirationDate(card.getExpiration());
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                } else {
                    fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum(fop.getPassengerStatus()) : null));
                    fopExport.setNumber(fop.getRelatedTicketNumber());
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                }
                fopExport.setOperationDate(fop.getOperationDate());
                fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)fop.getAgent()));
                fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
                fopExport.setBankName(fop.getBankName());
                fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)fop.getPayer()));
                fopExport.setAccompanyingDocumentType(MetadataBasedExportHelper.convertEnum(fop.getTchCCAccompanyingDocumentType()));
                for (Commission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                    commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                    fopExport.getServiceFees().add(commissionExport);
                }
                for (Commission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.discountPropertyTypes, null, null)) {
                    commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                    fopExport.getDiscounts().add(commissionExport);
                }
                List<FopComponent> components = MetadataBasedExportHelper.getSortedFopComponents(fopDetalization.getComponents());
                for (FopComponent component : components) {
                    FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent(component, negate);
                    fopExport.getFopComponents().add(componentExport);
                }
            }
        }
        if (AirProductHelper.isBSPTicket((Product)product)) {
            ArrayList<Commission> commissions = new ArrayList<Commission>(GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionPropertyTypes, null, null));
            Collection bspCommissions = GeneralProductHelper.filterCommissions(commissions, null, (Set)GeneralProductHelper.bspCommissionTypes, null);
            Commission fakeBSPCommission = new Commission();
            fakeBSPCommission.setContractType(ContractType.VENDOR);
            fakeBSPCommission.setCommissionProperties(new EntityReference("bsp_commission", CommissionProperties.class, "BSP Commission"));
            fakeBSPCommission.setRate(null);
            fakeBSPCommission.setAmount(null);
            fakeBSPCommission.setEquivalentAmount(null);
            Double rate = product.getBspCommissionRate();
            Money value = product.getBspCommissionValue();
            if (rate != null || value != null && value.getValue() != null && value.getCurrency() != null) {
                if (rate != null) {
                    fakeBSPCommission.setRate(rate);
                } else {
                    fakeBSPCommission.setAmount(value);
                }
                fakeBSPCommission.setEquivalentAmount(value != null ? value.getValue() : null);
            }
            commissions.removeAll(bspCommissions);
            commissions.add(fakeBSPCommission);
            productExport.setTotalVendorCommissions(MetadataBasedExportHelper.calculateCommissions(commissions, productExport.getVendorCommissions(), vendorEquivalentCurrency, negate));
        } else {
            productExport.setTotalVendorCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.VENDOR, GeneralProductHelper.commissionPropertyTypes, productExport.getVendorCommissions(), vendorEquivalentCurrency, negate));
        }
        productExport.setTotalSubagencyCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.commissionPropertyTypes, productExport.getSubagencyCommissions(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.commissionPropertyTypes, productExport.getClientCommissions(), clientEquivalentCurrency, negate));
        productExport.setTotalVendorServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.VENDOR, GeneralProductHelper.serviceFeePropertyTypes, productExport.getVendorServiceFee(), vendorEquivalentCurrency, negate));
        productExport.setTotalSubagencyServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.serviceFeePropertyTypes, productExport.getSubagencyServiceFee(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.serviceFeePropertyTypes, productExport.getClientServiceFee(), clientEquivalentCurrency, negate));
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
        if (product.getProductCategory() == ProductCategory.MCO && CollectionUtil.isNotEmpty((Collection)product.getRelatedProducts())) {
            productExport.getRelatedTickets().addAll(product.getRelatedProducts().stream().map(BaseTicketProduct::getSystemNumber).filter(Objects::nonNull).map(this::convertToRelatedTicket).collect(Collectors.toList()));
        }
        productExport.setDiscountDocumentCode(product.getDiscountDocumentCode());
        productExport.setDiscountDocumentNumber(product.getDiscountDocumentNumber());
        productExport.setTripartiteContractDetails(this.convertTripartiteContractDetails(product.getTripartiteContractDetails()));
        productExport.setGdsName(MetadataBasedExportHelper.convertEnum(CommonReservationGdsNameInfoHelper.getExport1CGdsName((Reservation)product.getReservation())));
    }

    private AirProductTripartiteContractDetailsExport convertTripartiteContractDetails(TripartiteContractDetails tripartiteContractDetails) {
        if (tripartiteContractDetails == null) {
            return null;
        }
        AirProductTripartiteContractDetailsExport result = new AirProductTripartiteContractDetailsExport();
        result.setTourcodeType(MetadataBasedExportHelper.convertEnum(tripartiteContractDetails.getTourcodeType()));
        result.setDiscountCode(tripartiteContractDetails.getDiscountCode());
        result.setDiscountRate(tripartiteContractDetails.getDiscountRate() != null ? BigDecimal.valueOf(tripartiteContractDetails.getDiscountRate()) : null);
        result.setDiscountValue(tripartiteContractDetails.getDiscountValue());
        result.setDiscountCurrency(tripartiteContractDetails.getDiscountCurrency());
        result.setPublicFareDiscount(this.convertPublicFareDiscount(tripartiteContractDetails.getPublicFareDiscount()));
        result.setContract(MetadataBasedExportHelper.convertReference(tripartiteContractDetails.getContract()));
        result.setTripartiteContract(MetadataBasedExportHelper.convertReference(tripartiteContractDetails.getTripartiteContract()));
        result.setNotApplyTripartiteContracts(Boolean.valueOf(tripartiteContractDetails.isNotApplyTripartiteContracts()));
        result.setSubstitutePassengerType(MetadataBasedExportHelper.convertDictionary(tripartiteContractDetails.getSubstitutePassengerType()));
        result.setContractCode(tripartiteContractDetails.getContractCode());
        result.setIssuedUnder3d(Boolean.valueOf(tripartiteContractDetails.isIssuedUnder3d()));
        result.setUsePersonDiscountCard(Boolean.valueOf(tripartiteContractDetails.isUsePersonDiscountCard()));
        result.setTripartiteContractRemark(tripartiteContractDetails.getTripartiteContractRemark());
        MetadataBasedExportHelper.convertStringCollection(result.getSsrs(), tripartiteContractDetails.getSsrs());
        return result;
    }

    private AirProductTripartitePublicFareDiscountExport convertPublicFareDiscount(TripartitePublicFareDiscount tripartitePublicFareDiscount) {
        if (tripartitePublicFareDiscount == null) {
            return null;
        }
        AirProductTripartitePublicFareDiscountExport result = new AirProductTripartitePublicFareDiscountExport();
        result.setValue(tripartitePublicFareDiscount.getValue());
        result.setRate(Boolean.valueOf(tripartitePublicFareDiscount.isRate()));
        result.setCurrency(tripartitePublicFareDiscount.getCurrency());
        result.setTicketDesignator(tripartitePublicFareDiscount.getTicketDesignator());
        return result;
    }

    private RelatedTicket convertToRelatedTicket(String ticketNumber) {
        RelatedTicket relatedTicket = new RelatedTicket();
        relatedTicket.setNumber(ticketNumber);
        return relatedTicket;
    }

    private ObjectReferenceExport convertTransportationType(Product product) {
        TransportationType type = AirProductHelper.getTransportationType((Product)product);
        if (type == null) {
            return null;
        }
        switch (type) {
            case DOMESTIC: {
                return MetadataBasedExportHelper.createReference("VVL", "\u0412\u0412\u041b");
            }
            case INTERNATIONAL: {
                return MetadataBasedExportHelper.createReference("MVL", "\u041c\u0412\u041b");
            }
            case COMBINED: {
                return MetadataBasedExportHelper.createReference("MVLVVL", "\u0412\u0412\u041b+\u041c\u0412\u041b");
            }
        }
        return null;
    }

    private String findAirlineCode(DictionaryReference<Airline> carrier) {
        Airline airline = (Airline)DictionaryCache.get().resolveReference(carrier);
        if (airline == null) {
            return null;
        }
        String res = (String)airline.getCodeVariants().get(CodeSystem.IATA.name());
        return res != null ? res : (String)CollectionUtil.firstNonNull(airline.getCodeVariants().values());
    }

    private AirProductLuggageExport convertLuggage(Double weight, LuggageUnits units) {
        if (weight == null && units == null) {
            return null;
        }
        AirProductLuggageExport result = new AirProductLuggageExport();
        result.setWeight(weight != null ? BigDecimal.valueOf(weight) : null);
        result.setUnit(MetadataBasedExportHelper.convertEnum(units));
        return result;
    }

    private AirProductTravellerExport convertTraveller(Product product) {
        Traveller traveller = product.getTraveller();
        if (traveller == null) {
            return null;
        }
        AirProductTravellerExport result = new AirProductTravellerExport();
        result.setName(traveller.getName());
        result.setType(MetadataBasedExportHelper.convertDictionary(product.getPassengerType()));
        result.setNameInGds(traveller.getNameInGds());
        result.setNameInCyrillic(traveller.getCyrillicName());
        if (traveller.getPassenger() != null) {
            result.setPassengerUid(traveller.getPassenger().getUid());
            EntityContainer personCtr = EntityStorage.get().resolve(traveller.getPassenger());
            if (personCtr != null) {
                result.getExternalCodes().addAll(BookingXmlExportHelper.getPersonExternalCodes((EntityContainer<Person>)personCtr));
                result.setCode(((Person)personCtr.getEntity()).getCode());
            }
        }
        return result;
    }

    private ProductFare getProductFare(Product product) throws Exception {
        ProductFare totalFare = null;
        boolean segmentTariffs = false;
        for (ProductFare fare : product.getFares()) {
            if (fare.getSegmentTariff() == null) {
                totalFare = (ProductFare)XCloneHelper.clone((XCloneable)fare);
                break;
            }
            segmentTariffs = true;
        }
        if (totalFare == null && segmentTariffs) {
            totalFare = new ProductFare();
        }
        if (totalFare != null) {
            boolean updateBaseFare = false;
            boolean updateEquivalentFare = false;
            boolean updateNuc = false;
            boolean updateRoe = false;
            Money baseFare = totalFare.getBaseFare();
            if (baseFare == null) {
                baseFare = new Money();
                totalFare.setBaseFare(baseFare);
                updateBaseFare = true;
            }
            if (totalFare.getEquivalentFare() == null) {
                updateEquivalentFare = true;
            }
            if (totalFare.getRoe() == null) {
                updateRoe = true;
            }
            if (totalFare.getNucFare() == null) {
                updateNuc = true;
            }
            for (ProductFare fare : product.getFares()) {
                if (fare.getSegmentTariff() == null) continue;
                if (updateBaseFare && fare.getBaseFare() != null) {
                    baseFare.setValue(baseFare.getValue() != null && fare.getBaseFare().getValue() != null ? baseFare.getValue().add(fare.getBaseFare().getValue()) : fare.getBaseFare().getValue());
                    baseFare.setCurrency(fare.getBaseFare().getCurrency());
                }
                if (updateEquivalentFare && fare.getEquivalentFare() != null) {
                    totalFare.setEquivalentFare(totalFare.getEquivalentFare() != null ? totalFare.getEquivalentFare().add(fare.getEquivalentFare()) : fare.getEquivalentFare());
                }
                if (updateNuc && fare.getNucFare() != null) {
                    totalFare.setNucFare(totalFare.getNucFare() != null ? totalFare.getNucFare().add(fare.getNucFare()) : fare.getNucFare());
                }
                if (!updateRoe || fare.getRoe() == null) continue;
                totalFare.setRoe(totalFare.getRoe() != null ? totalFare.getRoe().add(fare.getRoe()) : fare.getRoe());
            }
        }
        return totalFare;
    }

    private BigDecimal getRate(Product product, ProductFare totalFare) {
        CurrencyRate currencyRate;
        Date date;
        BigDecimal rate = null;
        if (totalFare != null && totalFare.getBaseFare() != null && totalFare.getBaseFare().getCurrency() != null && (date = AirProductHelper.getCurrencyRateDate((Product)product)) != null && (currencyRate = BookingHelper.findCurrencyRateWithIndirectChecking((String)totalFare.getBaseFare().getCurrency(), (Date)date, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)product.getTariffType(), (EntityReference)product.getBlankOwnerRef(), (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product))) != null) {
            rate = BigDecimal.valueOf(currencyRate.getRate());
        }
        return rate;
    }

    private String getSegmentNo(SegmentTariff segmentTariff) {
        return segmentTariff == null ? null : segmentTariff.getSegments().stream().map(Segment::getRecordNumber).map(i -> Integer.toString(i)).collect(Collectors.joining(" - "));
    }

    private static ObjectReferenceExport getFopCategory(ProductFop fop) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        if (!AirProductHelper.isServiceFop((ProductFop)fop)) {
            boolean payment = false;
            boolean discount = false;
            for (Commission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    payment = true;
                    break;
                }
                if (commission.getCommissionProperties() == null || !GeneralProductHelper.discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                discount = true;
                break;
            }
            if (payment) {
                result.setCode("PAYMENT_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            } else if (discount) {
                result.setCode("DISCOUNT");
                result.setCaption("\u0421\u043a\u0438\u0434\u043a\u0430");
            } else {
                result.setCode("SERVICE_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440");
            }
        } else {
            result.setCode("PRODUCT");
            result.setCaption("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        }
        return result;
    }
}

