/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking.delivery;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.DeliveryExport;
import com.gridnine.xtrip.common.model.export.booking.v2.DeliveryItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BookingExportDeliveryFillProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Delivery product = (Delivery)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        DeliveryExport productExport = new DeliveryExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        DeliveryExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof Delivery) {
            previousProductExport = new DeliveryExport();
            this.updateProductExport(previousProductExport, (Delivery)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, settings, previousSettings)));
    }

    private void updateProductExport(DeliveryExport productExport, Delivery product) {
        String equivCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.CLIENT);
        productExport.setUid(product.getUid());
        productExport.setContractRulesApplied(Boolean.valueOf(product.isContractRulesApplied()));
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setIssueDate(product.getIssueDate());
        productExport.setStatus(MetadataBasedExportHelper.convertEnum(product.getStatus()));
        productExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)product.getAgent()));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference<SalesPoint>)product.getSalesPoint()));
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)product.getAgency()));
        productExport.setAddresseeName(product.getAddresseeName() != null ? product.getAddresseeName() : (product.getAddressee() != null ? product.getAddressee().toString() : null));
        for (DeliveryItem item : product.getDeliveryItems()) {
            NestedEntityReference productReference;
            DeliveryItemExport itemExport = new DeliveryItemExport();
            itemExport.setName(item.getObject() != null ? item.getObject().toString() : null);
            itemExport.setCost(item.getCost());
            itemExport.setPaymentType(MetadataBasedExportHelper.convertEnum(item.getPaymentType()));
            if (item.getType() == DeliveryItemType.PRODUCT && (productReference = (NestedEntityReference)item.getObject()) != null) {
                itemExport.setBookingFileUid(productReference.getUid());
                itemExport.setProductUid(productReference.getNestedEntityUid());
            }
            productExport.getDeliveryItems().add(itemExport);
        }
        productExport.setStartDate(product.getStartDate());
        productExport.setEndDate(product.getEndDate());
        productExport.setUrgent(Boolean.valueOf(product.isUrgent()));
        productExport.setWithDocuments(Boolean.valueOf(product.isWithDocuments()));
        productExport.setAdditionalInfo(product.getAdditionalInfo());
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setAddress(product.getAddress());
        productExport.setMetroStation(MetadataBasedExportHelper.convertDictionary(product.getMetroStation()));
        productExport.setDeliveryRegion(MetadataBasedExportHelper.convertDictionary(product.getDeliveryRegion()));
        productExport.setContactPersonName(product.getContactPersonName() != null ? product.getContactPersonName() : (product.getContactPerson() != null ? product.getContactPerson().toString() : null));
        productExport.setContactPhone(product.getContactPhone());
        productExport.setCourier(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)product.getCourier()));
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        productExport.setComments(product.getComments());
        List<GeneralProductFop> clientFops = MetadataBasedExportHelper.getSortedFops(product.getClientFops());
        for (GeneralProductFop fop : clientFops) {
            Object card;
            FopExport fopExport = new FopExport();
            FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
            fopExport.setContractType(MetadataBasedExportHelper.convertEnum(ContractType.CLIENT));
            fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getAgreementType((BaseContractRelationData)GeneralProductHelper.getClientContractRelation((BaseProduct)product))));
            fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)fop.getAgent()));
            fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum(fop.getType()));
            PaymentType paymentType = fop.getType();
            if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                card = fop.getCard();
                if (card != null) {
                    fopExport.setDetails(MetadataBasedExportHelper.convertEnum(card.getVendor()));
                    fopExport.setCardNumber(card.getNumber());
                    fopExport.setCardExpirationDate(card.getExpiration());
                    fopExport.setCardSecurityCode(card.getSecurityCode());
                }
            } else {
                fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum(fop.getPassengerStatus()) : null));
                fopExport.setNumber(fop.getRelatedTicketNumber());
                card = fop.getCard();
                if (card != null) {
                    fopExport.setCardSecurityCode(card.getSecurityCode());
                }
            }
            fopExport.setOperationDate(fop.getOperationDate());
            fopExport.setAmount(MetadataBasedExportHelper.convertMoney(MoneyHelper.buildMoney((BigDecimal)fop.getEquivalentAmount(), (String)equivCurrency), false));
            fopExport.setCategory(BookingExportDeliveryFillProductHeaderProcessor.getFopCategory(fop));
            fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
            fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)fop.getPayer()));
            for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                ReferenceItemExport commissionExport = new ReferenceItemExport();
                commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                fopExport.getServiceFees().add(commissionExport);
            }
            List<FopComponent> components = MetadataBasedExportHelper.getSortedFopComponents(fopDetalization.getComponents());
            for (FopComponent component : components) {
                FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent(component, false);
                fopExport.getFopComponents().add(componentExport);
            }
            productExport.getFops().add(fopExport);
        }
        productExport.setTotalClientCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.commissionPropertyTypes, productExport.getClientCommissions(), equivCurrency, false));
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
    }

    private static ObjectReferenceExport getFopCategory(GeneralProductFop fop) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
            boolean payment = false;
            boolean discount = false;
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    payment = true;
                    break;
                }
                if (commission.getCommissionProperties() == null || !GeneralProductHelper.discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                discount = true;
                break;
            }
            if (payment) {
                result.setCode("PAYMENT_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            } else if (discount) {
                result.setCode("DISCOUNT");
                result.setCaption("\u0421\u043a\u0438\u0434\u043a\u0430");
            } else {
                result.setCode("SERVICE_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440");
            }
        } else {
            result.setCode("PRODUCT");
            result.setCaption("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        }
        return result;
    }
}

