/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking.hotel;

import com.com.gridnine.xtrip.common.model.booking.xtriphotels.HotelDepositCard;
import com.com.gridnine.xtrip.common.model.booking.xtriphotels.HotelGuaranteeCard;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CommissionInfo;
import com.gridnine.xtrip.common.model.booking.xtriphotels.DailyRate;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Meal;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelAdditionalServiceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelCancellationChargeExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelCommissionInfoExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelDepositCardExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelFopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelGuaranteeCardExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelPenaltyExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelRoomExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelRoomRateExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelTaxExport;
import com.gridnine.xtrip.common.model.export.booking.v2.HotelTravellerExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BookingExportHotelFillProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HotelProduct product = (HotelProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        HotelExport productExport = new HotelExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        HotelExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof HotelProduct) {
            previousProductExport = new HotelExport();
            this.updateProductExport(previousProductExport, (HotelProduct)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, settings, previousSettings)));
    }

    private void updateProductExport(HotelExport productExport, HotelProduct product) throws Exception {
        boolean negate;
        ProductStatus status = product.getStatus();
        boolean bl = negate = ProductStatus.EXCHANGE.equals((Object)status) || ProductStatus.REFUND.equals((Object)status);
        if (product.getPreviousProduct() != null) {
            if (product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                productExport.setExchangeTicketNumber(product.getPreviousProduct().getSystemNumber());
            }
            if (product.getPreviousProduct().getStatus() == ProductStatus.SELL) {
                productExport.setPreviousSellProductUid(product.getPreviousProduct().getUid());
            }
        }
        productExport.setCountry(MetadataBasedExportHelper.convertDictionary(product.getHotelCountry()));
        productExport.setId(product.getUid());
        productExport.setHotelStars(product.getHotelStars());
        productExport.setProviderHotelCode(product.getProviderHotelCode());
        productExport.setHotelPropertyId(product.getHotelPropertyId());
        productExport.setHotelAddress(product.getHotelAddress());
        productExport.setHotelPhone(product.getHotelPhone());
        productExport.setHotelFax(product.getHotelFax());
        productExport.setHotelLocation(MetadataBasedExportHelper.convertDictionary(product.getHotelLocation()));
        productExport.setHotelName(product.getHotelName());
        productExport.setHotelChainCode(product.getHotelChainCode());
        if (product.getLoc() != null) {
            productExport.setLongitude(BigDecimal.valueOf(product.getLoc().getLongitude()));
            productExport.setLatitude(BigDecimal.valueOf(product.getLoc().getLatitude()));
        }
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setStatus(MetadataBasedExportHelper.convertEnum(product.getStatus()));
        productExport.setTariffType(MetadataBasedExportHelper.convertEnum(product.getTariffType()));
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum(product.getTicketType()));
        productExport.setBlankOwnerCode(HotelProductHelper.getBlankOwnerCode((EntityReference)product.getBlankOwnerRef()));
        productExport.setBlankOwner(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)product.getBlankOwnerRef()));
        EntityReference supplierRef = HotelProductHelper.getSupplier((HotelProduct)product);
        productExport.setSupplier(MetadataBasedExportHelper.convertSupplier((EntityReference<Organization>)supplierRef));
        productExport.setProvider(MetadataBasedExportHelper.convertEnum(product.getProvider()));
        productExport.setIssueDate(product.getIssueDate());
        productExport.setUnholdDate(product.getUnholdDate());
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)HotelProductHelper.getAgency((HotelProduct)product)));
        productExport.setAgencyCode(product.getAgencyCode());
        productExport.setCashierCode(product.getCashierCode());
        productExport.setValidatorCode(product.getValidatorCode());
        productExport.setValidatorUid(product.getValidatorUid());
        productExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)HotelProductHelper.getSubagency((HotelProduct)product)));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference<SalesPoint>)product.getSalesPoint()));
        productExport.setCashier(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)product.getCashier()));
        productExport.setForcedRefund(Boolean.valueOf(product.isForcedRefund()));
        for (Traveller traveller : product.getTravellers()) {
            HotelTravellerExport travellerExport = new HotelTravellerExport();
            travellerExport.setName(traveller.getName());
            travellerExport.setType(MetadataBasedExportHelper.convertDictionary(this.findPassengerTypeForTraveller(product, traveller)));
            if (traveller.getPassenger() != null) {
                EntityContainer personCtr = EntityStorage.get().resolve(traveller.getPassenger());
                travellerExport.setPassengerUid(traveller.getPassenger().getUid());
                if (personCtr != null) {
                    travellerExport.getExternalCodes().addAll(BookingXmlExportHelper.getPersonExternalCodes((EntityContainer<Person>)personCtr));
                    travellerExport.setCode(((Person)personCtr.getEntity()).getCode());
                }
            }
            productExport.getTravellers().add(travellerExport);
        }
        productExport.setPcc(product.getPcc());
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setFinalized(product.getFinalized());
        productExport.setFreeSales(product.getFreeSales());
        productExport.setContractRulesApplied(Boolean.valueOf(product.isContractRulesApplied()));
        productExport.setCurrencyRateDate(product.getCurrencyRateDate());
        productExport.setUsedPcc(product.getUsedPcc());
        productExport.setProviderProfileId(product.getProviderProfileId());
        productExport.setCF(product.getCF());
        productExport.setHotelCommissionInfo(this.getHotelCommissionInfoExport(product));
        productExport.setGuaranteeCard(this.getHotelGuaranteeCardExport(product));
        productExport.setDepositCard(this.getHotelDepositCardExport(product));
        productExport.setCorporateDiscount(product.getCorporateDiscount());
        productExport.setAgencyContract(product.getAgencyContract());
        productExport.setGuaranteeType(MetadataBasedExportHelper.convertEnum(product.getGuaranteeType()));
        productExport.setGuaranteeCode(product.getGuaranteeCode());
        productExport.setPromoCoupon(product.getPromoCoupon());
        productExport.setCancellable(Boolean.valueOf(product.isCancellable()));
        productExport.setCancellableNow(product.getCancellableNow());
        productExport.setCancellationPolicyText(product.getCancellationPolicyText());
        for (CancellationCharge cancellationCharge : product.getCancellationCharges()) {
            HotelCancellationChargeExport chargeExport = new HotelCancellationChargeExport();
            chargeExport.setEndDate(cancellationCharge.getEndDate());
            if (cancellationCharge.getPenalty() != null) {
                chargeExport.setPenalty(MetadataBasedExportHelper.convertRateMoney(cancellationCharge.getPenalty().getMoney(), cancellationCharge.getPenalty().getRate()));
            }
            chargeExport.setPolicyText(cancellationCharge.getPolicyText());
            chargeExport.setStartDate(cancellationCharge.getStartDate());
            productExport.getCancellationCharges().add(chargeExport);
        }
        String vendorEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.VENDOR);
        String subagencyEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
        String clientEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.CLIENT);
        String gdsCurrency = TextUtil.isBlank((String)product.getGdsCurrency()) ? DictHelper.getEquivCurrency() : product.getGdsCurrency();
        for (Room room : product.getRooms()) {
            HotelRoomExport roomExport = new HotelRoomExport();
            if (room.getCheckInTime() != null) {
                roomExport.setCheckIn(MiscUtil.setMinutes((Date)room.getCheckInDate(), (int)room.getCheckInTime()));
            } else {
                roomExport.setCheckIn(room.getCheckInDate());
            }
            if (room.getCheckOutTime() != null) {
                roomExport.setCheckOut(MiscUtil.setMinutes((Date)room.getCheckOutDate(), (int)room.getCheckOutTime()));
            } else {
                roomExport.setCheckOut(room.getCheckOutDate());
            }
            roomExport.setEquivalentPrice(MetadataBasedExportHelper.convertVatAmount(room.getEquivalentPrice(), gdsCurrency, room.getEquivalentVatPrice()));
            Meal meal = room.getMeal();
            if (meal != null && (TextUtil.nonBlank((String)meal.getCode()) || TextUtil.nonBlank((String)meal.getCaption()))) {
                ObjectReferenceExport mealExport = new ObjectReferenceExport();
                mealExport.setCode(TextUtil.nonBlank((String)meal.getCode()) ? meal.getCode() : meal.getCaption());
                mealExport.setCaption(meal.getCaption());
                roomExport.setMeal(mealExport);
            }
            roomExport.setName(room.getRoomName());
            roomExport.setNumberOfNigths(Integer.valueOf(HotelProductHelper.calculateNights((Date)room.getCheckInDate(), (Date)room.getCheckOutDate())));
            roomExport.setNumberOfPeople(room.getNumberOfPeople());
            roomExport.setPriceLocal(MetadataBasedExportHelper.convertMoney(room.getBasePrice()));
            roomExport.setPricePerNightLocal(MetadataBasedExportHelper.convertMoney(room.getBaseRate()));
            roomExport.setSize(room.getRoomSize());
            roomExport.setPricePerNightAgency(room.getEquivalentRate());
            for (DailyRate dailyRate : room.getDailyRates()) {
                HotelRoomRateExport rateExport = new HotelRoomRateExport();
                rateExport.setEndDate(dailyRate.getEndDate());
                rateExport.setStartDate(dailyRate.getStartDate());
                rateExport.setRate(MetadataBasedExportHelper.convertMoney(dailyRate.getRate()));
                rateExport.setSurcharge(MetadataBasedExportHelper.convertMoney(dailyRate.getSurcharge()));
                rateExport.setTax(MetadataBasedExportHelper.convertMoney(dailyRate.getTax()));
                roomExport.getRates().add(rateExport);
            }
            productExport.getRooms().add(roomExport);
        }
        productExport.setCotsGuaranteed(Boolean.valueOf(product.isCotsGuaranteed()));
        productExport.setSharingBedding(product.getSharingBedding());
        productExport.setWaitingForRefundConfirmation(Boolean.valueOf(product.isWaitingForRefundConfirmation()));
        productExport.setComments(product.getComments());
        productExport.setDescription(product.getDescription());
        productExport.setBookingMethod(MetadataBasedExportHelper.convertEnum(product.getBookingMethod()));
        productExport.setClientContractNumber(product.getClientContractNumber());
        productExport.setGdsCurrency(product.getGdsCurrency());
        if (product.getVendorCurrencyRate() != null) {
            productExport.setVendorCurrencyRate(BigDecimal.valueOf(product.getVendorCurrencyRate()));
        }
        for (AdditionalService additionalService : product.getAdditionalServices()) {
            HotelAdditionalServiceExport additionalServiceExport = new HotelAdditionalServiceExport();
            additionalServiceExport.setName(additionalService.getName());
            additionalServiceExport.setCode(additionalService.getCode());
            additionalServiceExport.setAmount(MetadataBasedExportHelper.convertMoney(additionalService.getBaseAmount()));
            additionalServiceExport.setEquivalentAmount(MetadataBasedExportHelper.convertVatAmount(additionalService.getEquivalentAmount(), gdsCurrency, additionalService.getEquivalentVatAmount()));
            additionalServiceExport.setType(MetadataBasedExportHelper.convertEnum(additionalService.getType()));
            productExport.getServices().add(additionalServiceExport);
        }
        productExport.setFare(MetadataBasedExportHelper.convertProductAmount(HotelProductHelper.calcBasePrice((HotelProduct)product), null, null, negate));
        productExport.setEquivalentFare(MetadataBasedExportHelper.convertProductAmount(HotelProductHelper.getEquivalentFare((HotelProduct)product), gdsCurrency, HotelProductHelper.getEquivalentVatFare((HotelProduct)product), null, negate));
        productExport.setTax(MetadataBasedExportHelper.convertProductAmount(HotelProductHelper.calculateTaxesEquivalentAmount((HotelProduct)product), gdsCurrency, HotelProductHelper.calculateTaxesEquivalentVatAmount((HotelProduct)product), null, negate));
        productExport.setPenalty(MetadataBasedExportHelper.convertVatAmount(HotelProductHelper.calculatePenaltyEquivalentAmount((HotelProduct)product, (boolean)true), gdsCurrency, HotelProductHelper.calculatePenaltyEquivalentVatAmount((HotelProduct)product, (boolean)true)));
        productExport.setTotal(MetadataBasedExportHelper.convertProductAmount(HotelProductHelper.calculateTotalEquivalentFare((HotelProduct)product), gdsCurrency, HotelProductHelper.calculateTotalVatAmount((HotelProduct)product), null, negate));
        for (HotelProductTax tax : product.getTaxes()) {
            HotelTaxExport taxExport = new HotelTaxExport();
            taxExport.setCode(tax.getCode());
            taxExport.setAmount(MetadataBasedExportHelper.convertMoney(tax.getAmount(), negate));
            taxExport.setEquivalentAmount(MetadataBasedExportHelper.convertProductAmount(tax.getEquivalentAmount(), gdsCurrency, tax.getEquivalentVatAmount(), tax.getAddCollect(), negate));
            productExport.getTaxes().add(taxExport);
        }
        for (Penalty penalty : product.getPenalties()) {
            HotelPenaltyExport penaltyExport = new HotelPenaltyExport();
            penaltyExport.setCode(penalty.getCode());
            penaltyExport.setName(penalty.getName());
            penaltyExport.setEquivalentAmount(MetadataBasedExportHelper.convertVatAmount(penalty.getEquivalentAmount(), gdsCurrency, penalty.getEquivalentVatAmount()));
            productExport.getPenalties().add(penaltyExport);
        }
        List contractRelations = HotelProductHelper.getContractRelations((HotelProduct)product);
        for (HotelProductContractRelationData contractRelation : contractRelations) {
            BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, s -> {}, arg_0 -> ((HotelExport)productExport).setSubagencyContract(arg_0), arg_0 -> ((HotelExport)productExport).setVendorContract(arg_0), arg_0 -> ((HotelExport)productExport).setTechnicalProviderContract(arg_0));
            List fops = contractRelation.getFops().stream().sorted((o1, o2) -> {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getAmount() == null) {
                    return o2.getAmount() == null ? MiscUtil.compare((Comparable)((Object)o1.getUid()), (Comparable)((Object)o2.getUid())) : -1;
                }
                if (o2.getAmount() == null) {
                    return 1;
                }
                int result = MiscUtil.compare((Comparable)o1.getAmount().getValue(), (Comparable)o2.getAmount().getValue());
                if (result == 0) {
                    return MiscUtil.compare((Comparable)((Object)o1.getUid()), (Comparable)((Object)o2.getUid()));
                }
                return result;
            }).collect(Collectors.toList());
            for (HotelProductFop fop : fops) {
                Object card;
                HotelFopExport fopExport = new HotelFopExport();
                productExport.getFops().add(fopExport);
                FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
                fopExport.setContractType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())));
                fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getAgreementType((BaseContractRelationData)contractRelation)));
                fopExport.setCategory(BookingExportHotelFillProductHeaderProcessor.getFopCategory(fop));
                fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum(fop.getType()));
                fopExport.setAmount(MetadataBasedExportHelper.convertMoney(fop.getAmount(), negate));
                PaymentType paymentType = fop.getType();
                if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setDetails(MetadataBasedExportHelper.convertEnum(card.getVendor()));
                        fopExport.setCardNumber(card.getNumber());
                        fopExport.setCardExpirationDate(card.getExpiration());
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                } else {
                    fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum(fop.getPassengerStatus()) : null));
                    fopExport.setNumber(fop.getRelatedTicketNumber());
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                }
                fopExport.setOperationDate(fop.getOperationDate());
                fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)fop.getAgent()));
                fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
                fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)fop.getPayer()));
                for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                    ReferenceItemExport commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                    fopExport.getServiceFees().add(commissionExport);
                }
                List<FopComponent> components = MetadataBasedExportHelper.getSortedFopComponents(fopDetalization.getComponents());
                for (FopComponent component : components) {
                    FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent(component, negate);
                    fopExport.getFopComponents().add(componentExport);
                }
            }
        }
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        productExport.setTotalVendorCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.VENDOR, GeneralProductHelper.commissionPropertyTypes, productExport.getVendorCommissions(), vendorEquivalentCurrency, negate));
        productExport.setTotalSubagencyCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.commissionPropertyTypes, productExport.getSubagencyCommissions(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.commissionPropertyTypes, productExport.getClientCommissions(), clientEquivalentCurrency, negate));
        productExport.setTotalVendorServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.VENDOR, GeneralProductHelper.serviceFeePropertyTypes, productExport.getVendorServiceFee(), vendorEquivalentCurrency, negate));
        productExport.setTotalSubagencyServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.serviceFeePropertyTypes, productExport.getSubagencyServiceFee(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.serviceFeePropertyTypes, productExport.getClientServiceFee(), clientEquivalentCurrency, negate));
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
        productExport.setTripartiteAgreement(Boolean.valueOf(product.isTripartiteAgreement()));
        productExport.setClientTariffCode(product.getClientTariffCode());
    }

    private DictionaryReference<PassengerType> findPassengerTypeForTraveller(HotelProduct product, Traveller t) {
        if (t == null) {
            return null;
        }
        for (PassengerTypeReference ptr : product.getTravellersPassengerTypes()) {
            if (ptr == null || ptr.getTravellerUid() == null || !ptr.getTravellerUid().equals(t.getUid())) continue;
            return ptr.getPassengerType();
        }
        return null;
    }

    private HotelCommissionInfoExport getHotelCommissionInfoExport(HotelProduct product) {
        if (product == null || product.getHotelCommissionInfo() == null) {
            return null;
        }
        HotelCommissionInfoExport infoExport = new HotelCommissionInfoExport();
        CommissionInfo originalInfo = product.getHotelCommissionInfo();
        infoExport.setCMN(originalInfo.getCMN());
        infoExport.setCMT(originalInfo.getCMT());
        infoExport.setTAC(originalInfo.getTAC());
        return infoExport;
    }

    private HotelGuaranteeCardExport getHotelGuaranteeCardExport(HotelProduct product) {
        if (product == null || product.getGuaranteeCard() == null) {
            return null;
        }
        HotelGuaranteeCardExport guaranteeCardExport = new HotelGuaranteeCardExport();
        HotelGuaranteeCard guaranteeCard = product.getGuaranteeCard();
        guaranteeCardExport.setName(guaranteeCard.getName());
        guaranteeCardExport.setCardNumber(guaranteeCard.getCardNumber());
        guaranteeCardExport.setCardType(guaranteeCard.getCardType());
        guaranteeCardExport.setExpDate(guaranteeCard.getExpDate());
        guaranteeCardExport.setType(MetadataBasedExportHelper.convertEnum(guaranteeCard.getType()));
        return guaranteeCardExport;
    }

    private HotelDepositCardExport getHotelDepositCardExport(HotelProduct product) {
        if (product == null || product.getDepositCard() == null) {
            return null;
        }
        HotelDepositCardExport depositCardExport = new HotelDepositCardExport();
        HotelDepositCard card = product.getDepositCard();
        depositCardExport.setCardNumber(card.getCardNumber());
        depositCardExport.setExpDate(card.getExpDate());
        depositCardExport.setCardVendor(MetadataBasedExportHelper.convertEnum(card.getCardVendor()));
        depositCardExport.setType(MetadataBasedExportHelper.convertEnum(card.getType()));
        return depositCardExport;
    }

    private static ObjectReferenceExport getFopCategory(HotelProductFop fop) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
            boolean payment = false;
            boolean discount = false;
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    payment = true;
                    break;
                }
                if (commission.getCommissionProperties() == null || !GeneralProductHelper.discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                discount = true;
                break;
            }
            if (payment) {
                result.setCode("PAYMENT_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            } else if (discount) {
                result.setCode("DISCOUNT");
                result.setCaption("\u0421\u043a\u0438\u0434\u043a\u0430");
            } else {
                result.setCode("SERVICE_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440");
            }
        } else {
            result.setCode("PRODUCT");
            result.setCaption("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        }
        return result;
    }
}

