/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking.inshurance.accident;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.InsuranceAccidentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BookingExportInsuranceAccidentFillProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        InsuranceAccident product = (InsuranceAccident)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        InsuranceAccidentExport productExport = new InsuranceAccidentExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        InsuranceAccidentExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof InsuranceAccident) {
            previousProductExport = new InsuranceAccidentExport();
            this.updateProductExport(previousProductExport, (InsuranceAccident)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, settings, previousSettings)));
    }

    private void updateProductExport(InsuranceAccidentExport productExport, InsuranceAccident product) {
        ProductStatus status = product.getStatus();
        String vendorEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.VENDOR);
        String subagencyEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
        String clientEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.CLIENT);
        boolean negate = ProductStatus.EXCHANGE.equals((Object)status) || ProductStatus.REFUND.equals((Object)status);
        productExport.setUid(product.getUid());
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum(product.getTicketType()));
        productExport.setDepartureDate(product.getDepartureDate());
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setFlightNumber(product.getFlightNumber());
        productExport.setPassengerType(MetadataBasedExportHelper.convertDictionary(product.getPassengerType()));
        productExport.setContractRulesApplied(Boolean.valueOf(product.isContractRulesApplied()));
        productExport.setBlankOwner(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)product.getBlankOwner()));
        productExport.setBlankType(MetadataBasedExportHelper.convertDictionary(product.getBlankType()));
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setEticket(Boolean.valueOf(product.isEticket()));
        productExport.setIssueDate(product.getIssueDate());
        productExport.setStatus(MetadataBasedExportHelper.convertEnum(product.getStatus()));
        productExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)product.getAgent()));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference<SalesPoint>)product.getSalesPoint()));
        productExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)InsuranceAccidentHelper.getSubagency((InsuranceAccident)product)));
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)InsuranceAccidentHelper.getAgency((InsuranceAccident)product)));
        EntityReference supplierRef = InsuranceAccidentHelper.getSupplier((InsuranceAccident)product);
        EntityContainer supplierCtr = EntityStorage.get().resolve(supplierRef);
        productExport.setSupplier(MetadataBasedExportHelper.convertSupplier((EntityReference<Organization>)supplierRef));
        productExport.setScn(product.getScn());
        productExport.setPcc(product.getPcc());
        productExport.setRelatedProductUid(product.getRelatedProductUid());
        productExport.setTravellerUid(product.getTravellerUid());
        productExport.setDepartureLocationName(product.getDepartureLocationName());
        productExport.setArrivalLocationName(product.getArrivalLocationName());
        productExport.setInsuranceSum(MetadataBasedExportHelper.convertMoney(product.getInsuranceSum()));
        productExport.setEquivalentSum(product.getEquivalentSum());
        productExport.setBusiness(Boolean.valueOf(product.isBusiness()));
        productExport.setComments(product.getComments());
        List contractRelations = InsuranceAccidentHelper.getContractRelations((InsuranceAccident)product);
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, arg_0 -> ((InsuranceAccidentExport)productExport).setClientContract(arg_0), arg_0 -> ((InsuranceAccidentExport)productExport).setSubagencyContract(arg_0), arg_0 -> ((InsuranceAccidentExport)productExport).setVendorContract(arg_0), arg_0 -> ((InsuranceAccidentExport)productExport).setTechnicalProviderContract(arg_0));
            List<GeneralProductFop> fops = MetadataBasedExportHelper.getSortedFops(contractRelation.getFops());
            for (GeneralProductFop fop : fops) {
                Object card;
                FopExport fopExport = new FopExport();
                productExport.getFops().add(fopExport);
                FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
                fopExport.setContractType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())));
                fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getAgreementType((BaseContractRelationData)contractRelation)));
                fopExport.setCategory(BookingExportInsuranceAccidentFillProductHeaderProcessor.getFopCategory(fop));
                fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum(fop.getType()));
                fopExport.setAmount(MetadataBasedExportHelper.convertMoney(MoneyHelper.buildMoney((BigDecimal)fop.getEquivalentAmount(), (String)GeneralProductHelper.getContractCurrency((GeneralProductContractRelationData)contractRelation)), negate));
                PaymentType paymentType = fop.getType();
                if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setDetails(MetadataBasedExportHelper.convertEnum(card.getVendor()));
                        fopExport.setCardNumber(card.getNumber());
                        fopExport.setCardExpirationDate(card.getExpiration());
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                } else {
                    fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum(fop.getPassengerStatus()) : null));
                    fopExport.setNumber(fop.getRelatedTicketNumber());
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                }
                fopExport.setOperationDate(fop.getOperationDate());
                fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)fop.getAgent()));
                fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
                fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)fop.getPayer()));
                for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                    ReferenceItemExport commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                    fopExport.getServiceFees().add(commissionExport);
                }
                List<FopComponent> components = MetadataBasedExportHelper.getSortedFopComponents(fopDetalization.getComponents());
                for (FopComponent component : components) {
                    FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent(component, negate);
                    fopExport.getFopComponents().add(componentExport);
                }
            }
        }
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        productExport.setTotalVendorCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.VENDOR, GeneralProductHelper.commissionPropertyTypes, productExport.getVendorCommissions(), vendorEquivalentCurrency, negate));
        productExport.setTotalSubagencyCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.commissionPropertyTypes, productExport.getSubagencyCommissions(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.commissionPropertyTypes, productExport.getClientCommissions(), clientEquivalentCurrency, negate));
        productExport.setTotalVendorServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.VENDOR, GeneralProductHelper.serviceFeePropertyTypes, productExport.getVendorServiceFee(), vendorEquivalentCurrency, negate));
        productExport.setTotalSubagencyServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.serviceFeePropertyTypes, productExport.getSubagencyServiceFee(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.serviceFeePropertyTypes, productExport.getClientServiceFee(), clientEquivalentCurrency, negate));
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
    }

    private static ObjectReferenceExport getFopCategory(GeneralProductFop fop) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
            boolean payment = false;
            boolean discount = false;
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    payment = true;
                    break;
                }
                if (commission.getCommissionProperties() == null || !GeneralProductHelper.discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                discount = true;
                break;
            }
            if (payment) {
                result.setCode("PAYMENT_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            } else if (discount) {
                result.setCode("DISCOUNT");
                result.setCaption("\u0421\u043a\u0438\u0434\u043a\u0430");
            } else {
                result.setCode("SERVICE_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440");
            }
        } else {
            result.setCode("PRODUCT");
            result.setCaption("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        }
        return result;
    }
}

