/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.export.standard.booking.universal;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameter;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.TaxExport;
import com.gridnine.xtrip.common.model.export.booking.v2.UniversalProductCustomParameterDescriptionExport;
import com.gridnine.xtrip.common.model.export.booking.v2.UniversalProductCustomParameterExport;
import com.gridnine.xtrip.common.model.export.booking.v2.UniversalProductDescriptionExport;
import com.gridnine.xtrip.common.model.export.booking.v2.UniversalProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.UniversalProductTravellerExport;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BookingExportUniversalProductFillHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UniversalProduct product = (UniversalProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        UniversalProductExport productExport = new UniversalProductExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        UniversalProductExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof UniversalProduct) {
            previousProductExport = new UniversalProductExport();
            this.updateProductExport(previousProductExport, (UniversalProduct)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, settings, previousSettings)));
    }

    private void updateProductExport(UniversalProductExport productExport, UniversalProduct product) {
        boolean negate;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        ProductStatus status = product.getStatus();
        String vendorEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.VENDOR);
        String subagencyEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
        String clientEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.CLIENT);
        boolean bl = negate = ProductStatus.EXCHANGE.equals((Object)status) || ProductStatus.REFUND.equals((Object)status);
        if (product.getPreviousProduct() != null) {
            if (product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                productExport.setExchangeTicketNumber(product.getPreviousProduct().getSystemNumber());
            }
            if (product.getPreviousProduct().getStatus() == ProductStatus.SELL) {
                productExport.setPreviousSellProductUid(product.getPreviousProduct().getUid());
            }
        }
        productExport.setUid(product.getUid());
        productExport.setDescription(this.getUniversalProductDescription(product));
        productExport.setContractRulesApplied(Boolean.valueOf(product.isContractRulesApplied()));
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum(product.getTicketType()));
        productExport.setBlankOwner(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)product.getBlankOwner()));
        productExport.setBlankType(MetadataBasedExportHelper.convertDictionary(product.getBlankType()));
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setEticket(Boolean.valueOf(product.isEticket()));
        productExport.setIssueDate(product.getIssueDate());
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setHasVat(Boolean.valueOf(product.isHasVat()));
        productExport.setDontRecalcVat(Boolean.valueOf(product.isDontRecalcVat()));
        productExport.setStatus(MetadataBasedExportHelper.convertEnum(product.getStatus()));
        productExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)product.getAgent()));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference<SalesPoint>)product.getSalesPoint()));
        productExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)UniversalProductHelper.getSubagency((UniversalProduct)product)));
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)UniversalProductHelper.getAgency((UniversalProduct)product)));
        EntityReference supplierRef = UniversalProductHelper.getSupplier((UniversalProduct)product);
        productExport.setSupplier(MetadataBasedExportHelper.convertSupplier((EntityReference<Organization>)supplierRef));
        productExport.setForcedRefund(Boolean.valueOf(product.isForcedRefund()));
        productExport.setScn(product.getScn());
        MetadataBasedExportHelper.convertStringCollection(productExport.getTravellersUids(), product.getTravellersUids());
        for (String uid : product.getTravellersUids()) {
            product.getReservation().getBookingFile().getTravellers().stream().filter(item -> MiscUtil.equals((Object)uid, (Object)item.getUid())).findFirst().ifPresent(traveller -> productExport.getTravellers().add(this.convertTraveller((Traveller)traveller)));
        }
        productExport.setNotes(product.getNotes());
        productExport.setEquivalentFare(product.getEquivalentFare());
        productExport.setBaseFare(MetadataBasedExportHelper.convertMoney(product.getBaseFare()));
        productExport.setRateWithCoeff(product.getRateWithCoeff());
        productExport.setRate(product.getRate());
        productExport.setTotalVat(product.getTotalVat());
        productExport.setPenalty(product.getPenalty());
        for (GeneralProductTax tax : product.getTaxes()) {
            TaxExport taxExport = new TaxExport();
            taxExport.setAmount(MetadataBasedExportHelper.convertMoney(tax.getAmount()));
            taxExport.setCode(tax.getCode());
            taxExport.setEquivalentAmount(tax.getEquivalentAmount());
            productExport.getTaxes().add(taxExport);
        }
        productExport.setComments(product.getComments());
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        List contractRelations = UniversalProductHelper.getContractRelations((UniversalProduct)product);
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, arg_0 -> ((UniversalProductExport)productExport).setClientContract(arg_0), arg_0 -> ((UniversalProductExport)productExport).setSubagencyContract(arg_0), arg_0 -> ((UniversalProductExport)productExport).setVendorContract(arg_0), arg_0 -> ((UniversalProductExport)productExport).setTechnicalProviderContract(arg_0));
            List<GeneralProductFop> fops = MetadataBasedExportHelper.getSortedFops(contractRelation.getFops());
            for (GeneralProductFop fop : fops) {
                Object commission2;
                Object card;
                FopExport fopExport = new FopExport();
                productExport.getFops().add(fopExport);
                FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
                fopExport.setContractType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())));
                fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum(GeneralProductHelper.getAgreementType((BaseContractRelationData)contractRelation)));
                fopExport.setCategory(BookingExportUniversalProductFillHeaderProcessor.getFopCategory(fop));
                fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum(fop.getType()));
                fopExport.setAmount(MetadataBasedExportHelper.convertMoney(MoneyHelper.buildMoney((BigDecimal)fop.getEquivalentAmount(), (String)GeneralProductHelper.getContractCurrency((GeneralProductContractRelationData)contractRelation)), negate));
                PaymentType paymentType = fop.getType();
                if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setDetails(MetadataBasedExportHelper.convertEnum(card.getVendor()));
                        fopExport.setCardNumber(card.getNumber());
                        fopExport.setCardExpirationDate(card.getExpiration());
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                } else {
                    fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum(fop.getPassengerStatus()) : null));
                    fopExport.setNumber(fop.getRelatedTicketNumber());
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                }
                fopExport.setOperationDate(fop.getOperationDate());
                fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference<Person>)fop.getAgent()));
                fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
                fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference<Organization>)fop.getPayer()));
                for (Object commission2 : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                    ReferenceItemExport commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission2));
                    fopExport.getServiceFees().add(commissionExport);
                }
                List<FopComponent> components = MetadataBasedExportHelper.getSortedFopComponents(fopDetalization.getComponents());
                commission2 = components.iterator();
                while (commission2.hasNext()) {
                    FopComponent component = (FopComponent)commission2.next();
                    FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent(component, negate);
                    fopExport.getFopComponents().add(componentExport);
                }
            }
        }
        productExport.setTotalVendorCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.VENDOR, GeneralProductHelper.commissionPropertyTypes, productExport.getVendorCommissions(), vendorEquivalentCurrency, negate));
        productExport.setTotalSubagencyCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.commissionPropertyTypes, productExport.getSubagencyCommissions(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.commissionPropertyTypes, productExport.getClientCommissions(), clientEquivalentCurrency, negate));
        productExport.setTotalVendorServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.VENDOR, GeneralProductHelper.serviceFeePropertyTypes, productExport.getVendorServiceFee(), vendorEquivalentCurrency, negate));
        productExport.setTotalSubagencyServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.SUBAGENCY, GeneralProductHelper.serviceFeePropertyTypes, productExport.getSubagencyServiceFee(), subagencyEquivalentCurrency, negate));
        productExport.setTotalClientServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, ContractType.CLIENT, GeneralProductHelper.serviceFeePropertyTypes, productExport.getClientServiceFee(), clientEquivalentCurrency, negate));
        productExport.setClientShipmentsDate(product.getShipmentsDate());
        for (UniversalProductCustomParameter customParameter : product.getCustomParameters()) {
            UniversalProductCustomParameterExport customParameterExport = new UniversalProductCustomParameterExport();
            String caption = customParameter.getId();
            customParameterExport.setName(caption);
            Object value = customParameter.getValue();
            UniversalProductCustomParameterDescriptionExport descriptionExport = null;
            if (productExport.getDescription() != null) {
                for (UniversalProductCustomParameterDescriptionExport description : productExport.getDescription().getCustomParameters()) {
                    if (!TextUtil.isSame((String)description.getId(), (String)caption)) continue;
                    descriptionExport = description;
                    break;
                }
            }
            String type = null;
            if (descriptionExport != null && descriptionExport.getType() != null) {
                type = descriptionExport.getType().getCode();
            }
            if (TextUtil.nonBlank(type) && value != null) {
                switch (type) {
                    case "STRING": {
                        customParameterExport.setValue((String)value);
                        break;
                    }
                    case "NUMBER": {
                        Number numberValue = (Number)value;
                        customParameterExport.setValue(numberValue.toString());
                        break;
                    }
                    case "DATE": {
                        Date valueDate = (Date)value;
                        customParameterExport.setValue(dateFormat.format(valueDate));
                        break;
                    }
                    case "DATE_TIME": {
                        Date valueDateTime = (Date)value;
                        customParameterExport.setValue(dateTimeFormat.format(valueDateTime));
                        break;
                    }
                    case "DICTIONARY": {
                        DictionaryReference reference = (DictionaryReference)value;
                        customParameterExport.setValue(MetadataBasedExportHelper.convertDictionary(reference).getCaption());
                        if (value instanceof GeoLocationReference) {
                            customParameterExport.setCityCode(this.getCityCode((GeoLocationReference)value));
                        }
                        if (!(value instanceof CountryReference)) break;
                        customParameterExport.setCountryCode(this.getCountryCode((CountryReference)value));
                        break;
                    }
                    case "BOOLEAN": {
                        Boolean booleanValue = (Boolean)value;
                        customParameterExport.setValue(booleanValue.toString());
                        break;
                    }
                    default: {
                        customParameterExport.setValue(value.toString());
                    }
                }
            }
            if (!TextUtil.nonBlank((String)customParameterExport.getName()) || !TextUtil.nonBlank((String)customParameterExport.getValue())) continue;
            productExport.getCustomParameters().add(customParameterExport);
        }
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
    }

    private UniversalProductDescriptionExport getUniversalProductDescription(UniversalProduct product) {
        if (product.getDescription() == null) {
            return null;
        }
        EntityContainer cont = EntityStorage.get().resolve(product.getDescription());
        UniversalProductDescription description = null;
        if (cont != null) {
            description = (UniversalProductDescription)cont.getEntity();
        }
        if (description == null) {
            return null;
        }
        UniversalProductDescriptionExport descriptionExport = new UniversalProductDescriptionExport();
        descriptionExport.setAutoGeneratedSystemNumbers(Boolean.valueOf(description.isAutoGeneratedSystemNumbers()));
        descriptionExport.setBaseFareSupported(Boolean.valueOf(description.isBaseFareSupported()));
        descriptionExport.setBlankOwnerAndSupplierAreAgency(Boolean.valueOf(description.isBlankOwnerAndSupplierAreAgency()));
        descriptionExport.setBlankTypePolicy(MetadataBasedExportHelper.convertEnum(description.getBlankTypePolicy()));
        descriptionExport.setExchangeSupported(Boolean.valueOf(description.isExchangeSupported()));
        descriptionExport.setExportTagName(description.getExportTagName());
        descriptionExport.setFewTravellersSupported(Boolean.valueOf(description.isFewTravellersSupported()));
        descriptionExport.setName(description.getName());
        descriptionExport.setNotesSupported(Boolean.valueOf(description.isNotesSupported()));
        descriptionExport.setRefundSupported(Boolean.valueOf(description.isRefundSupported()));
        descriptionExport.setRelatedDocumentsSupported(Boolean.valueOf(description.isRelatedDocumentsSupported()));
        descriptionExport.setRulesSupported(Boolean.valueOf(description.isRulesSupported()));
        descriptionExport.setTaxesSupported(Boolean.valueOf(description.isTaxesSupported()));
        description.getCustomParameters().forEach(parameter -> descriptionExport.getCustomParameters().add(this.convertCustomParameterDescription((UniversalProductCustomParameterDescription)parameter)));
        return descriptionExport;
    }

    private static ObjectReferenceExport getFopCategory(GeneralProductFop fop) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
            boolean payment = false;
            boolean discount = false;
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    payment = true;
                    break;
                }
                if (commission.getCommissionProperties() == null || !GeneralProductHelper.discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                discount = true;
                break;
            }
            if (payment) {
                result.setCode("PAYMENT_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            } else if (discount) {
                result.setCode("DISCOUNT");
                result.setCaption("\u0421\u043a\u0438\u0434\u043a\u0430");
            } else {
                result.setCode("SERVICE_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440");
            }
        } else {
            result.setCode("PRODUCT");
            result.setCaption("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        }
        return result;
    }

    private UniversalProductCustomParameterDescriptionExport convertCustomParameterDescription(UniversalProductCustomParameterDescription customParameterDescription) {
        UniversalProductCustomParameterDescriptionExport customParameterDescriptionExport = new UniversalProductCustomParameterDescriptionExport();
        customParameterDescriptionExport.setId(customParameterDescription.getId());
        customParameterDescriptionExport.setDisplayName(customParameterDescription.getDisplayName());
        customParameterDescriptionExport.setType(MetadataBasedExportHelper.convertEnum(customParameterDescription.getType()));
        customParameterDescriptionExport.setRole(MetadataBasedExportHelper.convertEnum(customParameterDescription.getRole()));
        return customParameterDescriptionExport;
    }

    private UniversalProductTravellerExport convertTraveller(Traveller traveller) {
        UniversalProductTravellerExport travellerExport = new UniversalProductTravellerExport();
        travellerExport.setUid(traveller.getUid());
        travellerExport.setName(traveller.getName());
        if (traveller.getPassenger() != null) {
            EntityContainer personCtr = EntityStorage.get().resolve(traveller.getPassenger());
            travellerExport.setPassengerUid(traveller.getPassenger().getUid());
            if (personCtr != null) {
                travellerExport.getExternalCodes().addAll(BookingXmlExportHelper.getPersonExternalCodes((EntityContainer<Person>)personCtr));
                travellerExport.setCode(((Person)personCtr.getEntity()).getCode());
            }
        }
        return travellerExport;
    }

    private String getCityCode(GeoLocationReference geoLocationReference) {
        String code = null;
        GeoLocation geoLocation = (GeoLocation)DictionaryCache.get().resolveReference((DictionaryReference)geoLocationReference);
        if (geoLocation != null) {
            GeoLocation parent;
            if (!LocationType.CITY.equals((Object)geoLocation.getType()) && !LocationType.AIRPORT.equals((Object)geoLocation.getType())) {
                return null;
            }
            code = this.getDictionaryCode((BaseDictionary)geoLocation);
            if (code == null && LocationType.CITY.equals((Object)geoLocation.getType())) {
                code = geoLocation.getCode();
            }
            if (code == null && LocationType.AIRPORT.equals((Object)geoLocation.getType()) && geoLocation.getParent() != null && (parent = (GeoLocation)DictionaryCache.get().resolveReference(geoLocation.getParent())) != null && LocationType.CITY.equals((Object)parent.getType()) && (code = this.getDictionaryCode((BaseDictionary)parent)) == null) {
                code = parent.getCode();
            }
        }
        return code;
    }

    private String getCountryCode(CountryReference countryReference) {
        String code = null;
        Country country = (Country)DictionaryCache.get().resolveReference((DictionaryReference)countryReference);
        if (country != null) {
            code = this.getDictionaryCode((BaseDictionary)country);
        }
        return code;
    }

    private String getDictionaryCode(BaseDictionary dictionary) {
        String code = DictHelper.getCodeVariant((BaseDictionary)dictionary, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA, CodeSystem.CRT});
        if (code == null) {
            code = dictionary.getCodeVariants().values().stream().filter(TextUtil::nonBlank).findFirst().orElse(null);
        }
        return code;
    }
}

